/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.location.AbstractSwingLocationHandler;
import com.elluminate.framework.location.DefaultMenuHandler;
import com.elluminate.framework.location.DefaultMenuHandlerProvider;
import com.elluminate.gui.event.PopupGestureHandler;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPopupMenu;

@Singleton
public class ContextualMenuLocation
extends AbstractSwingLocationHandler {
    public static final String LOCATION = "menus.context";
    private static final String ADD_TO_MENU_HINT = "contextMenu.addToMenu";
    private static final String INSTALL_MENU_HINT = "contextMenu.installMenu";
    private DefaultMenuHandlerProvider mHandlerProvider;
    private Map<String, DefaultMenuHandler> handlerMap = new HashMap<String, DefaultMenuHandler>();
    private Map<String, PopupGestureHandler> popupHandlerMap = new HashMap<String, PopupGestureHandler>();

    @Inject
    public ContextualMenuLocation(DefaultMenuHandlerProvider mHandlerProvider) {
        this.mHandlerProvider = mHandlerProvider;
    }

    protected void addFeatureSwing(Feature feature) {
        String installMenuHint = (String)feature.getHintValue(INSTALL_MENU_HINT, String.class);
        if (installMenuHint != null) {
            this.addMenuToFeature(feature, installMenuHint);
            return;
        }
        String menuId = (String)feature.getHintValue(ADD_TO_MENU_HINT, String.class);
        this.addFeatureToMenu(feature, menuId);
    }

    protected void removeFeatureSwing(Feature feature) {
        String installMenuHint = (String)feature.getHintValue(INSTALL_MENU_HINT, String.class);
        if (installMenuHint != null) {
            this.removeMenuFromFeature(feature, installMenuHint);
            return;
        }
        String menuId = (String)feature.getHintValue(ADD_TO_MENU_HINT, String.class);
        this.removeFeatureFromMenu(feature, menuId);
    }

    private void addMenuToFeature(Feature feature, String id) {
        if (feature instanceof ComponentFeature) {
            Component c = ((ComponentFeature)feature).getComponent();
            JPopupMenu popup = this.getContextualMenu("", id);
            PopupGestureHandler handler = this.getPopupHandler(id, popup, true);
            c.addMouseListener((MouseListener)handler);
        }
    }

    private void removeMenuFromFeature(Feature feature, String id) {
        if (feature instanceof ComponentFeature) {
            Component c = ((ComponentFeature)feature).getComponent();
            PopupGestureHandler handler = null;
            handler = this.getPopupHandler(id, null, false);
            c.removeMouseListener((MouseListener)handler);
        }
    }

    private void addFeatureToMenu(Feature feature, String id) {
        DefaultMenuHandler mHandler = this.getContextualMenuHandler("", id);
        if (mHandler == null) {
            return;
        }
        mHandler.addFeatureSwing(feature);
    }

    private void removeFeatureFromMenu(Feature feature, String id) {
        DefaultMenuHandler mHandler = this.getContextualMenuHandler("", id);
        if (mHandler == null) {
            return;
        }
        mHandler.removeFeatureSwing(feature);
    }

    private PopupGestureHandler getPopupHandler(String id, JPopupMenu popup, boolean createIfNeeded) {
        PopupGestureHandler handler = this.popupHandlerMap.get(id);
        if (handler == null && createIfNeeded) {
            handler = new PopupGestureHandler(popup);
            this.popupHandlerMap.put(id, handler);
        }
        return handler;
    }

    private DefaultMenuHandler getContextualMenuHandler(String name, String id) {
        if (id == null) {
            return null;
        }
        DefaultMenuHandler mHandler = this.handlerMap.get(id);
        if (mHandler == null) {
            mHandler = this.mHandlerProvider.get(name, id, -1);
            this.handlerMap.put(id, mHandler);
        }
        return mHandler;
    }

    private JPopupMenu getContextualMenu(String name, String id) {
        DefaultMenuHandler mHandler = this.getContextualMenuHandler(name, id);
        if (mHandler == null) {
            return null;
        }
        return mHandler.getMenu().getPopupMenu();
    }
}

