/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.swing.RectDistance;
import com.elluminate.classroom.swing.components.SWindow;
import com.elluminate.classroom.swing.location.MenuSectionSupport;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.platform.Platform;
import com.elluminate.util.Preferences;
import com.elluminate.util.SwingRunner;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class ChildWindow
extends SWindow
implements ComponentListener {
    public static final Integer DFT_MIN_WIDTH = new Integer(50);
    public static final Integer DFT_MIN_HEIGHT = new Integer(75);
    private static final int ON_SCREEN_MIN = 50;
    private static final Dimension ON_SCREEN_AREA = new Dimension(50, 50);
    public static final String MIN_WIDTH_HINT = "window.minWidth";
    public static final String MIN_HEIGHT_HINT = "window.minHeight";
    private static final String BLANK_SECTION = "";
    private WindowAdapter windowAdapter = new WindowAdapter(){

        @Override
        public void windowClosing(final WindowEvent e) {
            super.windowClosing(e);
            ChildWindow.this.windowListeners.fire((FiringFunctor)new FiringFunctor<WindowListener>(){

                public void fire(WindowListener listener) {
                    listener.windowClosing(e);
                }
            });
        }

        @Override
        public void windowClosed(final WindowEvent e) {
            ChildWindow.this.windowListeners.fire((FiringFunctor)new FiringFunctor<WindowListener>(){

                public void fire(WindowListener listener) {
                    listener.windowClosed(e);
                }
            });
        }
    };
    private JDialog dialog = null;
    private String title = null;
    private boolean cwEnabled = false;
    private String posnPref;
    private String sizePref;
    private MetaRunner metaRunner = new MetaRunner();
    private DialogParentProvider parentProv;
    private Preferences prefs;
    private SwingRunner runner;
    private MenuSectionSupport menuSection;
    private ListenerRegistry<WindowListener> windowListeners = null;

    @Inject
    public void initParentProvider(DialogParentProvider prov) {
        this.parentProv = prov;
    }

    @Inject
    public void initPreferences(Preferences prefs) {
        this.prefs = prefs;
    }

    @Inject
    public void initSwingRunner(SwingRunner sr) {
        this.runner = sr;
    }

    @Inject
    public void initMenuSectionSupport(MenuSectionSupport mss) {
        this.menuSection = mss;
    }

    @Inject
    public void initListenerRegistry(ListenerRegistry<WindowListener> lr) {
        this.windowListeners = lr;
    }

    public void addWindowListener(WindowListener listener) {
        this.windowListeners.add((Object)listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.cwEnabled = enabled;
        this.metaDataChanged(null);
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        this.metaDataChanged(null);
    }

    public void addToOptionsMenu(JComponent comp, String section, float order) {
        if (this.menuSection == null || this.menuSection.getMenu() == null) {
            this.menuSection.setMenu(this.getOptionsMenu());
            this.menuSection.addSection(BLANK_SECTION);
        }
        String string = section = section == null ? BLANK_SECTION : section;
        if (!this.menuSection.hasSection(section)) {
            this.menuSection.addSection(section);
        }
        this.menuSection.add(comp, String.valueOf(section), order);
    }

    public void setContentArea(JComponent comp) {
        this.setupJDialog();
        this.getContentPane().add(comp);
        this.dialog.add(this);
        this.dialog.pack();
        this.updateBounds();
        this.dialog.setTitle(this.title);
        this.dialog.setVisible(this.cwEnabled);
    }

    private void setupJDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.parentProv.getDialogParent(), false);
            this.dialog.addWindowListener(this.windowAdapter);
            this.dialog.addComponentListener(this);
            this.dialog.setDefaultCloseOperation(0);
            String actionName = "close-window";
            InputMap im = this.dialog.getRootPane().getInputMap(2);
            im.put(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), actionName);
            this.dialog.getRootPane().getActionMap().put(actionName, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChildWindow.this.fireCloseAction();
                }
            });
            if (Platform.getOS() == 202) {
                this.dialog.getRootPane().putClientProperty("Window.style", "small");
            }
        }
    }

    public void removeContent(JComponent comp) {
        this.dialog.setVisible(false);
        this.dialog.remove(comp);
    }

    public void removeOption(JComponent comp) {
        this.menuSection.remove(comp);
    }

    private void fireCloseAction() {
        this.setEnabled(false);
        this.windowListeners.fire((FiringFunctor)new FiringFunctor<WindowListener>(){

            public void fire(WindowListener listener) {
                listener.windowClosing(new WindowEvent(ChildWindow.this.dialog, 201));
            }
        });
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.sizePref != null) {
            this.prefs.setSetting(this.sizePref, this.dialog.getSize());
        }
        if (this.posnPref != null) {
            this.prefs.setSetting(this.posnPref, this.dialog.getLocation());
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (this.sizePref != null) {
            this.prefs.setSetting(this.sizePref, this.dialog.getSize());
        }
        if (this.posnPref != null) {
            this.prefs.setSetting(this.posnPref, this.dialog.getLocation());
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    private void updateBounds() {
        Dimension size = this.getSize();
        Point posn = this.getPosition(size);
        Rectangle rect = new Rectangle(posn, size);
        this.ensureOnScreen(rect);
        this.dialog.setBounds(rect);
    }

    private Point getPosition(Dimension size) {
        Rectangle main = this.parentProv.getDialogParent().getBounds();
        Point point = null;
        if (this.posnPref != null && (point = this.prefs.getPointSetting(this.posnPref, null)) != null) {
            return point;
        }
        point = new Point(main.x + (main.width - size.width) / 2, main.y + (main.height - size.height) / 2);
        return point;
    }

    @Override
    public Dimension getSize() {
        Dimension dimension = null;
        if (this.sizePref != null && (dimension = this.prefs.getDimensionSetting(this.sizePref, null)) != null) {
            return dimension;
        }
        if (dimension == null) {
            dimension = this.dialog.getSize();
        }
        return dimension;
    }

    public void metaDataChanged(MetaDataEvent ev) {
        this.runner.invokeLater((Runnable)this.metaRunner);
    }

    private void ensureOnScreen(Rectangle rect) {
        GraphicsDevice[] gds;
        ArrayList<Rectangle> screens = new ArrayList<Rectangle>();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        for (GraphicsDevice gd : gds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration config = gd.getDefaultConfiguration();
            Rectangle screenRect = config.getBounds();
            Insets insets = toolkit.getScreenInsets(config);
            screenRect.x += insets.left;
            screenRect.y += insets.top;
            screenRect.width -= insets.left + insets.right;
            screenRect.height -= insets.top + insets.bottom;
            screens.add(screenRect);
        }
        Point tl = rect.getLocation();
        Point tr = new Point(tl.x + rect.width - 50, tl.y);
        Rectangle rl = new Rectangle(tl, ON_SCREEN_AREA);
        Rectangle rr = new Rectangle(tr, ON_SCREEN_AREA);
        if (this.isOnScreen(rl, screens) || this.isOnScreen(rr, screens)) {
            return;
        }
        RectDistance best = null;
        for (Rectangle screen : screens) {
            RectDistance d = new RectDistance(rl, screen);
            best = d.nearer(best);
            d = new RectDistance(rr, screen);
            best = d.nearer(best);
        }
        best.apply(rect);
    }

    private boolean isOnScreen(Rectangle r, List<Rectangle> screens) {
        for (Rectangle screen : screens) {
            if (!screen.contains(r)) continue;
            return true;
        }
        return false;
    }

    public void addToToolbar(JComponent comp, String borderLayoutConstraints) {
        JPanel toolbar = this.getToolbar();
        JPanel pnl = new JPanel(new BorderLayout(4, 0));
        pnl.setOpaque(true);
        pnl.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        pnl.add((Component)comp, "Center");
        pnl.add((Component)this.getSeparator(), "East");
        toolbar.add((Component)pnl, borderLayoutConstraints);
    }

    private JSeparator getSeparator() {
        JSeparator sep = new JSeparator(1){

            @Override
            public void paint(Graphics g) {
                int h = this.getHeight();
                Graphics2D g2 = (Graphics2D)g;
                g2.fillRect(0, 0, 1, this.getHeight());
            }
        };
        return sep;
    }

    public void setPositionPreference(String pref) {
        this.posnPref = pref;
    }

    public void setSizePreference(String pref) {
        this.sizePref = pref;
    }

    class MetaRunner
    implements Runnable {
        MetaRunner() {
        }

        @Override
        public void run() {
            if (ChildWindow.this.cwEnabled) {
                ChildWindow.this.updateBounds();
                ChildWindow.this.dialog.setTitle(ChildWindow.this.title);
                ChildWindow.this.dialog.setVisible(true);
            } else {
                ChildWindow.this.dialog.setVisible(false);
            }
        }
    }
}

