/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.swing.ChatPanel;
import com.elluminate.classroom.swing.SwingDebug;
import com.elluminate.classroom.swing.chat.ChatServerProperties;
import com.elluminate.classroom.swing.location.MenuSectionSupport;
import com.elluminate.classroom.swing.location.NotificationHints;
import com.elluminate.classroom.swing.location.NotificationSupport;
import com.elluminate.classroom.swing.location.StringsProperties;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.BrokerAdapter;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.ListElementChangeEvent;
import com.elluminate.framework.feature.ListElementChangeListener;
import com.elluminate.framework.feature.ListFeature;
import com.elluminate.framework.feature.LocationHandler;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.Notification;
import com.elluminate.framework.location.AbstractSwingLocationHandler;
import com.elluminate.framework.location.ActionFeatureAdapter;
import com.elluminate.framework.location.ActionFeatureAdapterProvider;
import com.elluminate.framework.location.BooleanFeatureAdapter;
import com.elluminate.framework.location.BooleanFeatureAdapterProvider;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.framework.location.SwingListElementChangeListener;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRParticipantAdapter;
import com.elluminate.framework.session.listener.CRParticipantListener;
import com.elluminate.framework.session.listener.event.CRParticipantEvent;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.feature.chat.SimpleChatMessage;
import com.elluminate.gui.swing.CCheckBoxMenuItem;
import com.elluminate.gui.swing.CMenuItem;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.ArraySet;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ChatLocationHandler
extends AbstractSwingLocationHandler
implements NotificationHints {
    private static final String LOCATION = "chat";
    private static final String AREA = "chatArea";
    private static final String TITLE_BAR_AREA = "titleBar";
    private static final String OPTIONS_MENU_AREA = "optionsMenu";
    private static final String MESSAGE_AREA = "messageArea";
    private static final String INPUT_AREA = "inputArea";
    private static final String SEND_TO_PARTICPANTS_FEATURE = "sendMessageToParticipants";
    private static final String SEND_TO_ROOM_FEATURE = "sendMessageToRoom";
    private static final String SEND_TO_MODERATORS_FEATURE = "sendMessageToModerators";
    private static final String CHAT_ACTIVE_FEATURE = "chatActive";
    private static final String FORBIDDEN_PARTICIPANTS_FEATURE = "forbiddenParticipants";
    private static final String SHOW_EMOTICONS_FEATURE = "showEmoticons";
    private static final String MENU_SECTION = "chatMenuSection";
    private static final String FILE_SECTION = "fileSection";
    private static final String ACTION_SECTION = "actionSection";
    private static final String OPTION_SECTION = "optionSection";
    private static final String PANEL_SECTION = "panelSection";
    private static final String ORDER = "order";
    private I18n i18n;
    private Map<Feature, FeatureAdapter> adapters = new HashMap<Feature, FeatureAdapter>();
    private NotificationSupport notificationSupport = new NotificationSupport();
    private MenuSectionSupport menuSupport = new MenuSectionSupport();
    private ChatPanel chatPanel;
    private ActionFeatureAdapterProvider actionAdapterProvider;
    private BooleanFeatureAdapterProvider booleanAdapterProvider;
    private IncomingMessageListener incomingMessageListener = new IncomingMessageListener();
    private OutgoingMessageListener outgoingMessageListener = new OutgoingMessageListener();
    private ActionFeature sendMessageToParticipantsFeature;
    private ActionFeature sendMessageToRoomFeature;
    private ActionFeature sendMessageToModeratorsFeature;
    private BooleanFeature chatActiveFeature;
    private ListFeature<CRParticipant> forbiddenParticipantsFeature;
    private BooleanFeature showEmoticonsFeature;
    private CRSession session = null;
    private ChairProtocol chairProtocol;
    private Set<String> departedParticipantNames = new HashSet<String>();
    private ListElementChangeListener forbiddenParticipantsListener = new ForbiddenParticipantsListener();
    private ClientList clients = null;
    private ClientProvider clientProvider = null;

    @Inject
    public void initI18n(I18nProvider provider) {
        this.i18n = provider.get((Object)this);
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    public void initBrokerAdapter(BrokerAdapter brokerAdapter) {
        brokerAdapter.addLocationHandler(LOCATION, (LocationHandler)this);
    }

    @Inject
    public void initAdapterProviders(ActionFeatureAdapterProvider actionAdapterProvider, BooleanFeatureAdapterProvider booleanAdapterProvider) {
        this.actionAdapterProvider = actionAdapterProvider;
        this.booleanAdapterProvider = booleanAdapterProvider;
    }

    @Inject
    protected void initCRSession(CRSession session) {
        this.session = session;
        this.session.addParticipantListener((CRParticipantListener)new CRParticipantAdapter(){
            private boolean fullyJoined = false;

            public void onParticipantRenamed(CRParticipantEvent event) {
                final CRParticipant p = event.getParticipant();
                if (p.isMe()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ChatLocationHandler.this.chatPanel.setMyDisplayName(p.getDisplayName());
                        }
                    });
                }
            }

            public void onParticipantAdded(CRParticipantEvent event) {
                final CRParticipant p = event.getParticipant();
                if (p.isMe()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ChatLocationHandler.this.chatPanel.setMyDisplayName(p.getDisplayName());
                        }
                    });
                }
            }

            public void onParticipantLeftRoom(CRParticipantEvent event) {
                final CRParticipant p = event.getParticipant();
                final CRRoom r = event.getRoom();
                ClientList clients = p.getConnection().getClientList();
                final ClientInfo ci = clients.get(p.getID());
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ci != null && ci.isServer()) {
                            fullyJoined = false;
                        }
                        String participantName = p.getDisplayName();
                        if (ChatLocationHandler.this.departedParticipantNames.add(participantName)) {
                            ChatLocationHandler.this.updateFilterSet();
                        }
                        if ((p.isMe() || fullyJoined) && p.isVisible()) {
                            String roomName = r.isMain() ? "" : r.getName();
                            ChatLocationHandler.this.chatPanel.appendLeftEventMessage(participantName, roomName, new Date());
                        }
                    }
                });
            }

            public void onParticipantJoinedRoom(CRParticipantEvent event) {
                final CRParticipant p = event.getParticipant();
                final CRRoom r = event.getRoom();
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (p.isMe()) {
                            fullyJoined = true;
                        }
                        String participantName = p.getDisplayName();
                        if (ChatLocationHandler.this.departedParticipantNames.remove(participantName)) {
                            ChatLocationHandler.this.updateFilterSet();
                        }
                        if ((p.isMe() || fullyJoined) && p.isVisible()) {
                            String roomName = r.isMain() ? "" : r.getName();
                            ChatLocationHandler.this.chatPanel.appendJoinedEventMessage(participantName, roomName, new Date());
                        }
                    }
                });
            }
        });
    }

    @Inject
    public void initChairProtocol(ChairProtocol chairProtocol) {
        this.chairProtocol = chairProtocol;
    }

    public void setChatPanel(ChatPanel chatPanel) {
        this.chatPanel = chatPanel;
        this.menuSupport.setMenu(chatPanel.getOptionsMenu());
        this.menuSupport.addSection(FILE_SECTION);
        this.menuSupport.addSection(ACTION_SECTION);
        this.menuSupport.addSection(OPTION_SECTION);
        this.menuSupport.addSection(PANEL_SECTION);
        chatPanel.addPropertyChangeListener("expanded", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ChatLocationHandler.this.notificationSupport.notifyInterestedFeatures("displayed", e.getNewValue());
            }
        });
        chatPanel.setOutgoingMessageListener(this.outgoingMessageListener);
        chatPanel.setInputFieldDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateChatActiveProperty(e.getDocument());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateChatActiveProperty(e.getDocument());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateChatActiveProperty(e.getDocument());
            }

            private void updateChatActiveProperty(Document document) {
                String text = null;
                try {
                    text = document.getText(0, document.getLength());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (text == null || ChatLocationHandler.this.chatActiveFeature == null) {
                    return;
                }
                ChatLocationHandler.this.chatActiveFeature.setValue((Object)(text.trim().length() > 0 ? 1 : 0));
            }
        });
    }

    protected void addFeatureSwing(Feature feature) {
        Object area;
        Object notification = feature.getHintValue("notification");
        if (notification != null) {
            this.notificationSupport.addInterestedFeature(feature, String.valueOf(notification));
        }
        if ((area = feature.getHintValue(AREA)) != null) {
            if (area.equals(OPTIONS_MENU_AREA)) {
                this.addOption(feature);
            } else if (area.equals(MESSAGE_AREA)) {
                if (feature instanceof ListFeature) {
                    ListFeature lf = (ListFeature)feature;
                    lf.addListElementListener((ListElementChangeListener)this.incomingMessageListener);
                }
            } else if (area.equals(INPUT_AREA)) {
                if (feature.getPath().endsWith(SEND_TO_PARTICPANTS_FEATURE)) {
                    this.sendMessageToParticipantsFeature = (ActionFeature)feature;
                } else if (feature.getPath().endsWith(SEND_TO_MODERATORS_FEATURE)) {
                    this.sendMessageToModeratorsFeature = (ActionFeature)feature;
                    this.chatPanel.showModeratorsTab();
                } else if (feature.getPath().endsWith(SEND_TO_ROOM_FEATURE)) {
                    this.sendMessageToRoomFeature = (ActionFeature)feature;
                    this.chatPanel.setMainRoomChatEnabled(true);
                } else if (feature.getPath().endsWith(CHAT_ACTIVE_FEATURE)) {
                    this.chatActiveFeature = (BooleanFeature)feature;
                } else if (feature.getPath().endsWith(FORBIDDEN_PARTICIPANTS_FEATURE)) {
                    this.forbiddenParticipantsFeature = (ListFeature)feature;
                    this.forbiddenParticipantsFeature.addListElementListener(this.forbiddenParticipantsListener);
                } else if (feature.getPath().endsWith(SHOW_EMOTICONS_FEATURE)) {
                    this.showEmoticonsFeature = (BooleanFeature)feature;
                    this.showEmoticonsFeature.addValueChangeListener(new MetaDataListener(){

                        public void metaDataChanged(MetaDataEvent event) {
                            boolean emoticonsEnabled = (Boolean)event.getNewValue();
                            ChatLocationHandler.this.chatPanel.updateEmoticonState(emoticonsEnabled);
                        }
                    });
                }
            } else if (area.equals(TITLE_BAR_AREA) && feature instanceof BooleanFeature) {
                BooleanFeature supervisedFeature = (BooleanFeature)feature;
                supervisedFeature.addValueChangeListener(new MetaDataListener(){

                    public void metaDataChanged(MetaDataEvent ev) {
                        ChatLocationHandler.this.chatPanel.setSupervised((Boolean)ev.getNewValue());
                    }
                });
            }
        }
    }

    protected void removeFeatureSwing(Feature feature) {
        Object area;
        Object notification = feature.getHintValue("notification");
        if (notification != null) {
            this.notificationSupport.removeInterestedFeature(feature, String.valueOf(notification));
        }
        if ((area = feature.getHintValue(AREA)) != null) {
            if (area.equals(OPTIONS_MENU_AREA)) {
                this.removeOption(feature);
            } else if (area.equals(MESSAGE_AREA)) {
                if (feature instanceof ListFeature) {
                    ListFeature lf = (ListFeature)feature;
                    lf.removeListElementListener((ListElementChangeListener)this.incomingMessageListener);
                }
            } else if (area.equals(INPUT_AREA)) {
                if (feature.getPath().endsWith(SEND_TO_PARTICPANTS_FEATURE)) {
                    this.sendMessageToParticipantsFeature = null;
                } else if (feature.getPath().endsWith(SEND_TO_MODERATORS_FEATURE)) {
                    this.sendMessageToModeratorsFeature = null;
                    this.chatPanel.hideModeratorsTab();
                } else if (feature.getPath().endsWith(SEND_TO_ROOM_FEATURE)) {
                    this.sendMessageToRoomFeature = null;
                    this.chatPanel.setMainRoomChatEnabled(false);
                } else if (feature.getPath().endsWith(CHAT_ACTIVE_FEATURE)) {
                    this.chatActiveFeature = null;
                } else if (feature.getPath().endsWith(FORBIDDEN_PARTICIPANTS_FEATURE)) {
                    if (this.forbiddenParticipantsFeature != null) {
                        this.forbiddenParticipantsFeature.removeListElementListener(this.forbiddenParticipantsListener);
                        this.forbiddenParticipantsFeature = null;
                    }
                } else if (feature.getPath().endsWith(SHOW_EMOTICONS_FEATURE)) {
                    this.showEmoticonsFeature = null;
                }
            }
        }
    }

    protected void deliverNotificationSwing(Notification notification) {
        Object area = notification.getHintValue(AREA);
        if (area != null && area.equals(MESSAGE_AREA)) {
            this.chatPanel.reset();
        }
    }

    private void updateFilterSet() {
        ArraySet names = new ArraySet();
        for (int i = 0; this.forbiddenParticipantsFeature != null && i < this.forbiddenParticipantsFeature.size(); ++i) {
            names.add(((CRParticipant)this.forbiddenParticipantsFeature.get(i)).getDisplayName());
        }
        names.addAll(this.departedParticipantNames);
        this.chatPanel.setForbiddenParticipantsFilter((Set<String>)names);
    }

    private void addOption(Feature feature) {
        CCheckBoxMenuItem c = null;
        BooleanFeatureAdapter a = null;
        if (feature instanceof ActionFeature) {
            ActionFeature af = (ActionFeature)feature;
            CMenuItem mi = new CMenuItem();
            ActionFeatureAdapter aa = this.actionAdapterProvider.get(LOCATION, af, (AbstractButton)mi, null);
            aa.setInteractiveSubstitution(this.i18n.getString((PropertiesEnum)StringsProperties.MENUHANDLER_INTERACTIVEITEM));
            aa.setHasText(true);
            c = mi;
            a = aa;
        } else if (feature instanceof BooleanFeature) {
            BooleanFeature bf = (BooleanFeature)feature;
            CCheckBoxMenuItem cbmi = new CCheckBoxMenuItem();
            BooleanFeatureAdapter ba = this.booleanAdapterProvider.get(LOCATION, bf, (AbstractButton)cbmi, null);
            ba.setHasText(true);
            c = cbmi;
            a = ba;
        }
        if (c != null) {
            this.adapters.put(feature, (FeatureAdapter)a);
            Object section = feature.getHintValue(MENU_SECTION);
            float order = ((Float)feature.getHintValue(ORDER, Float.class)).floatValue();
            this.menuSupport.add((JComponent)c, String.valueOf(section), order);
        }
    }

    private void removeOption(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.menuSupport.remove((JComponent)a.getComponent());
            a.dispose();
        }
    }

    private boolean isPrivateChateRestricted() {
        if (this.clientProvider == null) {
            return true;
        }
        this.clients = this.clientProvider.get().getClientList();
        if (this.clients == null) {
            return true;
        }
        return this.clients.getProperty(ChatServerProperties.PRIVATE_CHAT_RESTRICTED_PROPERTY, true);
    }

    class ForbiddenParticipantsListener
    extends SwingListElementChangeListener {
        ForbiddenParticipantsListener() {
        }

        public void swingElementAdded(ListElementChangeEvent event) {
            ChatLocationHandler.this.updateFilterSet();
        }

        public void swingElementRemoved(ListElementChangeEvent event) {
            ChatLocationHandler.this.updateFilterSet();
        }

        public void swingAllElementsCleared(ListElementChangeEvent event) {
            ChatLocationHandler.this.updateFilterSet();
        }

        public void swingElementsBatchUpdated(ListElementChangeEvent event) {
            ChatLocationHandler.this.updateFilterSet();
        }
    }

    private class IncomingMessageListener
    extends SwingListElementChangeListener {
        private IncomingMessageListener() {
        }

        public void swingElementAdded(ListElementChangeEvent event) {
            block19: {
                if (!(event.getElement() instanceof SimpleChatMessage)) {
                    LogSupport.error((Object)((Object)this), (String)"elementAdded", (String)"Unexpected element type - not a SimpleChatMessage.");
                    return;
                }
                SimpleChatMessage scm = (SimpleChatMessage)event.getElement();
                if (scm.getRecipients().isEmpty()) {
                    ChatLocationHandler.this.chatPanel.appendRoomMessage(scm.getSender(), scm.getTimestamp(), scm.getText());
                } else if (scm.isModeratorsMessage()) {
                    ClientList clientList = ChatLocationHandler.this.session.getConnection().getClientList();
                    try {
                        CRParticipant participant;
                        boolean sendToPrivate = false;
                        if (scm.getJinxAddress() != -32767 && !(participant = ChatLocationHandler.this.session.getParticipantById(scm.getJinxAddress())).hasPermission("ChatPermission") && !participant.hasPermission("ChairPermission")) {
                            sendToPrivate = true;
                        }
                        if (ChatLocationHandler.this.session.getMe().isChair() && (!sendToPrivate || ChatLocationHandler.this.isPrivateChateRestricted())) {
                            ChatLocationHandler.this.chatPanel.appendModeratorMessage(scm.getSender(), scm.getTimestamp(), scm.getText());
                            break block19;
                        }
                        ChatLocationHandler.this.chatPanel.appendRoomPrivateMessage(scm.getRecipients(), scm.getSender(), scm.getTimestamp(), scm.getText());
                        ChatLocationHandler.this.chatPanel.appendParticipantMessage(scm.getRecipients(), scm.getSender(), scm.getTimestamp(), scm.getText(), !ChatLocationHandler.this.session.getMe().isChair());
                    }
                    catch (NullPointerException npe) {
                        if (SwingDebug.CHAT.show()) {
                            if (ChatLocationHandler.this.chairProtocol == null) {
                                LogSupport.error((Object)((Object)this), (String)"swingElementAdded", (String)"chairProtocol is unexpectedly null!");
                            } else if (clientList == null) {
                                LogSupport.error((Object)((Object)this), (String)"swingElementAdded", (String)"clientList is unexpectedly null!");
                            } else if (scm.getSender() == null) {
                                LogSupport.error((Object)((Object)this), (String)"swingElementAdded", (String)"scm.getSender() is unexpectedly null!");
                            } else {
                                LogSupport.error((Object)((Object)this), (String)"swingElementAdded", (String)("something is unexpectedly null! " + npe));
                            }
                            break block19;
                        }
                        LogSupport.exception((Object)((Object)this), (String)"swingElementAdded:Internal Exception encountered", (Throwable)npe, (boolean)true);
                    }
                } else {
                    String ourDisplayName = ChatLocationHandler.this.session.getMe().getDisplayName();
                    if (scm.getSender().equals(ourDisplayName) || scm.getRecipients().contains(ourDisplayName)) {
                        ChatLocationHandler.this.chatPanel.appendParticipantMessage(scm.getRecipients(), scm.getSender(), scm.getTimestamp(), scm.getText());
                        if (!scm.getSender().equals(ourDisplayName) && scm.getRecipients().contains(ourDisplayName)) {
                            ChatLocationHandler.this.chatPanel.appendRoomPrivateMessage(scm.getRecipients(), scm.getSender(), scm.getTimestamp(), scm.getText());
                        }
                    } else {
                        ChatLocationHandler.this.chatPanel.appendSupervisedMessage(scm.getRecipients(), scm.getSender(), scm.getTimestamp(), scm.getText());
                    }
                }
            }
        }

        public void swingElementRemoved(ListElementChangeEvent event) {
            LogSupport.error((Object)((Object)this), (String)"elementRemoved", (String)"unexpected invocation - messages should not be removed?");
        }

        public void swingAllElementsCleared(ListElementChangeEvent event) {
            LogSupport.error((Object)((Object)this), (String)"allElementsCleared", (String)"unexpected invocation - messages should not be cleared?");
        }

        public void swingElementsBatchUpdated(ListElementChangeEvent event) {
        }
    }

    private class OutgoingMessageListener
    implements ChatPanel.SendOutgoingMessageListener {
        private OutgoingMessageListener() {
        }

        @Override
        public void sendMessageToRecipients(String[] recipients, String message) {
            ArrayList<CRParticipant> pl = new ArrayList<CRParticipant>(recipients.length);
            ClientList clients = ChatLocationHandler.this.session.getConnection().getClientList();
            CRSession session = ChatLocationHandler.this.session;
            for (String dn : recipients) {
                ClientInfo ci = clients.getVisible(dn);
                if (ci == null) continue;
                pl.add(session.getParticipantById(ci.getAddress()));
            }
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            params.put("recipients", pl);
            params.put("body", message);
            ChatLocationHandler.this.sendMessageToParticipantsFeature.fireActionFeatureListeners(params);
        }

        @Override
        public void sendMessageToRoom(String message) {
            TreeMap<String, String> params = new TreeMap<String, String>();
            params.put("body", message);
            params.put("toRoom", "this_room");
            ChatLocationHandler.this.sendMessageToRoomFeature.fireActionFeatureListeners(params);
        }

        @Override
        public void sendMessageToModerators(String message) {
            TreeMap<String, String> params = new TreeMap<String, String>();
            params.put("body", message);
            ChatLocationHandler.this.sendMessageToModeratorsFeature.fireActionFeatureListeners(params);
        }
    }
}

