/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.swing.caption.CaptionBGToolPanel;
import com.elluminate.classroom.swing.caption.CaptionFGToolPanel;
import com.elluminate.classroom.swing.caption.CaptionPanel;
import com.elluminate.classroom.swing.caption.CaptionPanelControls;
import com.elluminate.classroom.swing.caption.CaptionSourcePanel;
import com.elluminate.classroom.swing.caption.CaptionWindow;
import com.elluminate.classroom.swing.caption.CaptionWindowModel;
import com.elluminate.classroom.swing.location.StringsProperties;
import com.elluminate.classroom.swing.location.WindowInfo;
import com.elluminate.framework.feature.AbstractFeature;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.ListElementChangeEvent;
import com.elluminate.framework.feature.ListElementChangeListener;
import com.elluminate.framework.feature.ListFeature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.hints.HintEnum;
import com.elluminate.framework.location.AbstractSwingLocationHandler;
import com.elluminate.framework.location.ActionFeatureAdapter;
import com.elluminate.framework.location.ActionFeatureAdapterProvider;
import com.elluminate.framework.location.BooleanFeatureAdapter;
import com.elluminate.framework.location.BooleanFeatureAdapterProvider;
import com.elluminate.framework.location.EnumFeatureAdapter;
import com.elluminate.framework.location.EnumFeatureAdapterProvider;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.gui.FontUtils;
import com.elluminate.gui.swing.CCheckBoxMenuItem;
import com.elluminate.gui.swing.CMenuItem;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.UIManager;

public class CaptionWindowLocationHandler
extends AbstractSwingLocationHandler {
    private static final byte BACKSPACE = 8;
    public static final String CAPTION_INPUT_FEATURE = "/caption/input";
    public static final String CLOSE_FOR_HINT = "window.closeFor";
    public static final String LOCATION = "window.caption";
    public static final String WINDOW_AREA = "window.area";
    public static final String AREA_TOOLBAR = "toolbar";
    public static final String AREA_OPTIONS_MENU = "optionsMenu";
    public static final String AREA_CONTENT = "content";
    public static final String AREA_INVISIBLE = "invisible";
    public static final String SECTION = "section";
    private static final String ORDER = "order";
    private static final Set<String> EMPTY_CLOSE_FOR = new HashSet<String>();
    private static I18n i18n = I18n.create(CaptionWindowLocationHandler.class);
    private ActionFeatureAdapterProvider actionAdapterProvider;
    private BooleanFeatureAdapterProvider booleanAdapterProvider;
    private EnumFeatureAdapterProvider enumAdapterProvider;
    private Map<Feature, FeatureAdapter> adapters = new HashMap<Feature, FeatureAdapter>();
    private ActionFeature captionInputFeature;
    private ListFeature<String> captionMessageFeature;
    private CaptionPanel.OutboundCaptionMessageListener outboundCaptionMessageListener;
    private ListElementChangeListener captionMessageListener;
    private Preferences prefs;
    private String prefPrefix = CaptionWindowLocationHandler.class.getName();
    private String fontSizePref = this.prefPrefix + ".fontsize";
    private String fontFamilyPref = this.prefPrefix + ".fontfamily";
    private String bgColorPref = this.prefPrefix + ".bgcolor";
    private String fgColorPref = this.prefPrefix + ".fgcolor";
    private CaptionWindowModel windowModel;
    private Set<Feature> closeFeatures;
    private CaptionWindow captionWindow;
    private CaptionBGToolPanel bgToolPanel;
    private CaptionFGToolPanel fgToolPanel;
    private CaptionPanel captionPanel;
    private CaptionSourcePanel sourcePanel;
    private CaptionPanelControls panelControls;

    @Inject
    public CaptionWindowLocationHandler(CaptionWindowModel cwm) {
        this.windowModel = cwm;
    }

    @Inject
    public void initChildWindow(CaptionWindow cw) {
        this.captionWindow = cw;
    }

    @Inject
    public void initPreferences(Preferences p) {
        this.prefs = p;
    }

    @Inject
    public void initAdapterProviders(ActionFeatureAdapterProvider actionAdapterProvider, BooleanFeatureAdapterProvider booleanAdapterProvider, EnumFeatureAdapterProvider enumAdapterProvider) {
        this.actionAdapterProvider = actionAdapterProvider;
        this.booleanAdapterProvider = booleanAdapterProvider;
        this.enumAdapterProvider = enumAdapterProvider;
    }

    @Inject
    public void initPanels(CaptionPanel cp, CaptionBGToolPanel cbg, CaptionFGToolPanel cfg, CaptionSourcePanel csp, CaptionPanelControls cpc) {
        this.bgToolPanel = cbg;
        this.fgToolPanel = cfg;
        this.captionPanel = cp;
        this.sourcePanel = csp;
        this.panelControls = cpc;
    }

    public void initializeLocationHandler() {
        this.setupOutboundMessageListener();
        this.setupCaptionMessageListener();
        this.setupChildWindow();
    }

    private void setupCaptionMessageListener() {
        this.captionMessageListener = new ListElementChangeListener(){

            public void elementsBatchUpdated(ListElementChangeEvent event) {
            }

            public void elementRemoved(ListElementChangeEvent event) {
            }

            public void allElementsCleared(ListElementChangeEvent event) {
            }

            public void elementAdded(ListElementChangeEvent event) {
                String text = (String)event.getElement();
                if (text.contains("\b")) {
                    CaptionWindowLocationHandler.this.handleTextWithBackspaces(text);
                } else {
                    CaptionWindowLocationHandler.this.captionPanel.insertText(text);
                }
            }
        };
    }

    protected void handleTextWithBackspaces(String text) {
        byte[] breakdown;
        if (text == null || text.equals("")) {
            return;
        }
        byte[] toSend = new byte[]{};
        for (byte b : breakdown = text.getBytes()) {
            if (b == 8) {
                if (toSend.length > 0) {
                    try {
                        String sendText = new String(toSend, "UTF8");
                        toSend = new byte[]{};
                        this.captionPanel.insertText(sendText);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                this.captionPanel.deleteCharacter();
                continue;
            }
            byte[] temp = new byte[toSend.length + 1];
            System.arraycopy(toSend, 0, temp, 0, toSend.length);
            toSend = temp;
            toSend[toSend.length - 1] = b;
        }
        if (toSend.length > 0) {
            try {
                String sendText = new String(toSend, "UTF8");
                toSend = new byte[]{};
                this.captionPanel.insertText(sendText);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    private void setupOutboundMessageListener() {
        this.outboundCaptionMessageListener = new CaptionPanel.OutboundCaptionMessageListener(){

            @Override
            public void sendMessage(byte[] msg) {
                CaptionWindowLocationHandler.this.fireMessageThroughFeature(msg);
            }
        };
    }

    private void setupChildWindow() {
        this.bgToolPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.captionWindow.addToToolbar(this.bgToolPanel, "West");
        this.fgToolPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.captionWindow.addToToolbar(this.fgToolPanel, "Center");
        this.sourcePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.captionWindow.addToToolbar(this.sourcePanel, "East");
        this.captionPanel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("ShadeWindow.background")));
        this.captionPanel.setOpaque(true);
        this.captionWindow.setContentArea(this.captionPanel);
        this.captionWindow.setTitle(i18n.getString((PropertiesEnum)StringsProperties.CAPTIONWINDOW_TITLE));
        this.captionWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                CaptionWindowLocationHandler.this.closeFeatures();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                CaptionWindowLocationHandler.this.closeFeatures();
            }
        });
        this.setupSaveOption();
        this.setupInvertOption();
        this.loadPreferences();
    }

    private void setupSaveOption() {
        JMenuItem mi = this.panelControls.createSaveControl();
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaptionWindowLocationHandler.this.captionPanel.saveBtn_actionPerformed(null);
            }
        });
        this.captionWindow.addToOptionsMenu(mi, String.valueOf("file"), 1.0f);
    }

    private void setupInvertOption() {
        JMenuItem mi = this.panelControls.createInvertControl();
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaptionWindowLocationHandler.this.invertCaptionColors();
            }
        });
        this.captionWindow.addToOptionsMenu(mi, String.valueOf("panel"), 2.0f);
    }

    private void invertCaptionColors() {
        Color bg = this.windowModel.getBgColor();
        Color fg = this.windowModel.getFgColor();
        this.windowModel.setBgColor(fg);
        this.windowModel.setFgColor(bg);
    }

    private void loadPreferences() {
        this.registerPrefListeners();
        this.windowModel.setBgColor(this.prefs.getColorSetting(this.bgColorPref, Color.WHITE));
        this.windowModel.setFgColor(this.prefs.getColorSetting(this.fgColorPref, Color.BLACK));
        this.windowModel.setFontFamily(this.prefs.getSetting(this.fontFamilyPref, FontUtils.getFontNames()[0]));
        this.windowModel.setFontSize(this.prefs.getIntegerSetting(this.fontSizePref, 24));
    }

    protected void addFeatureSwing(Feature f) {
        HintEnum enumArea = (HintEnum)f.getHintValue(WINDOW_AREA, HintEnum.class);
        if (enumArea == null) {
            this.handleCloseFor(f);
        } else {
            this.handleWindowAreaPlacement(f, enumArea.getName());
        }
    }

    private void handleCloseFor(Feature f) {
        Set targets = (Set)f.getHintValue(CLOSE_FOR_HINT, EMPTY_CLOSE_FOR);
        if (targets != null) {
            this.addCloseFeature(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCloseFeature(Feature f) {
        if (this.closeFeatures == null) {
            this.closeFeatures = new HashSet<Feature>();
        }
        Set<Feature> set = this.closeFeatures;
        synchronized (set) {
            this.closeFeatures.add(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCloseFeature(Feature f) {
        if (this.closeFeatures != null) {
            Set<Feature> set = this.closeFeatures;
            synchronized (set) {
                this.closeFeatures.remove(f);
            }
        }
    }

    private void closeFeatures() {
        if (this.closeFeatures == null || this.closeFeatures.isEmpty()) {
            return;
        }
        for (Feature closeFeature : this.closeFeatures) {
            if (closeFeature instanceof ActionFeature) {
                ActionFeature action = (ActionFeature)closeFeature;
                action.fireActionFeatureListeners();
                continue;
            }
            if (!(closeFeature instanceof BooleanFeature)) continue;
            BooleanFeature toggle = (BooleanFeature)closeFeature;
            toggle.setValue((Object)false);
        }
    }

    private void handleWindowAreaPlacement(Feature f, String area) {
        if (area != null && area.equalsIgnoreCase(AREA_INVISIBLE)) {
            this.addToInvisibleArea((AbstractFeature)f);
        } else if (area != null && area.equalsIgnoreCase(AREA_CONTENT)) {
            this.setContentArea((AbstractFeature)f);
        } else if (area != null && area.equalsIgnoreCase(AREA_OPTIONS_MENU)) {
            this.addOption(f, this.getSection(f), LOCATION);
        } else if (area != null && area.equalsIgnoreCase(AREA_TOOLBAR) && f instanceof EnumeratedFeature) {
            this.addToToolbar((EnumeratedFeature)f);
        }
    }

    private void addToToolbar(EnumeratedFeature f) {
        if (f.getPath().contains("captionSource")) {
            JComboBox<String> cbo = new JComboBox<String>();
            cbo.setPrototypeDisplayValue("XXXXXXXXXXXXXXX");
            EnumFeatureAdapter ea = this.enumAdapterProvider.get(LOCATION, f, cbo, null);
            ea.setHasIcon(false);
            ea.setHasText(true);
            for (Object val : f.getEnumerationSet()) {
                ea.addItem(val);
            }
            this.adapters.put((Feature)f, (FeatureAdapter)ea);
            this.sourcePanel.setSourceComponent(cbo);
        }
    }

    private void setContentArea(AbstractFeature f) {
        if (f instanceof ActionFeature) {
            if (((ActionFeature)f).getPath().contains(CAPTION_INPUT_FEATURE)) {
                this.captionInputFeature = (ActionFeature)f;
                if (this.captionMessageFeature != null) {
                    this.captionMessageFeature.removeListElementListener(this.captionMessageListener);
                }
                this.captionPanel.backupDocument();
                this.captionPanel.clearDocument();
                this.captionPanel.insertText(i18n.getString((PropertiesEnum)StringsProperties.CAPTIONINPUT_ENTER_TEXT) + "\n");
                this.captionPanel.registerOutboundCaptionMessageListener(this.outboundCaptionMessageListener);
                this.captionPanel.setEditable(true);
                this.captionPanel.requestFocus();
            }
        } else if (f instanceof ListFeature) {
            this.captionMessageFeature = (ListFeature)f;
            this.captionMessageFeature.addListElementListener(this.captionMessageListener);
            this.captionPanel.deregisterOutboundCaptionMessageListener(this.outboundCaptionMessageListener);
            this.captionPanel.clearDocument();
            this.captionPanel.restoreDocument();
            this.captionPanel.setEditable(false);
            this.captionPanel.requestFocus();
        }
    }

    private void addToInvisibleArea(AbstractFeature f) {
        this.setPrefs((Feature)f);
        f.addMetaDataListener("Feature.enabled", new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                Object newVal = ev.getNewValue();
                if (newVal != null && newVal instanceof Boolean) {
                    CaptionWindowLocationHandler.this.captionWindow.setEnabled((Boolean)newVal);
                    CaptionWindowLocationHandler.this.backupContents((Boolean)newVal);
                }
            }
        });
        this.captionWindow.setEnabled(f.isEnabled());
    }

    protected void backupContents(Boolean newVal) {
        if (this.captionPanel != null) {
            if (newVal.booleanValue()) {
                this.captionPanel.restoreDocument();
            } else {
                this.captionPanel.backupDocument();
                this.captionPanel.clearDocument();
            }
        }
    }

    private void addOption(Feature feature, String section, String location) {
        CCheckBoxMenuItem c = null;
        BooleanFeatureAdapter a = null;
        if (feature instanceof ActionFeature) {
            ActionFeature af = (ActionFeature)feature;
            CMenuItem mi = new CMenuItem();
            ActionFeatureAdapter aa = this.actionAdapterProvider.get(location, af, (AbstractButton)mi, null);
            aa.setInteractiveSubstitution(i18n.getString((PropertiesEnum)StringsProperties.MENUHANDLER_INTERACTIVEITEM));
            aa.setHasText(true);
            c = mi;
            a = aa;
        } else if (feature instanceof BooleanFeature) {
            BooleanFeature bf = (BooleanFeature)feature;
            CCheckBoxMenuItem cbmi = new CCheckBoxMenuItem();
            BooleanFeatureAdapter ba = this.booleanAdapterProvider.get(location, bf, (AbstractButton)cbmi, null);
            ba.setHasText(true);
            c = cbmi;
            a = ba;
        }
        if (c != null) {
            this.adapters.put(feature, (FeatureAdapter)a);
            float order = ((Float)feature.getHintValue(ORDER, Float.class)).floatValue();
            this.captionWindow.addToOptionsMenu((JComponent)c, String.valueOf(section), order);
        }
    }

    private void removeOption(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.captionWindow.removeOption((JComponent)a.getComponent());
            a.dispose();
        }
    }

    private void removeContent(Feature feature) {
        if (feature != null && feature instanceof ActionFeature) {
            ActionFeature af = (ActionFeature)feature;
            if (af.getPath().contains(CAPTION_INPUT_FEATURE)) {
                this.captionPanel.deregisterOutboundCaptionMessageListener(this.outboundCaptionMessageListener);
                this.captionPanel.setEditable(false);
            }
        } else if (feature != null && feature instanceof ListFeature) {
            ((ListFeature)feature).removeListElementListener(this.captionMessageListener);
        }
    }

    private String getSection(Feature f) {
        Object sect = f.getHintValue(SECTION);
        if (sect != null) {
            return String.valueOf(sect);
        }
        return null;
    }

    protected void removeFeatureSwing(Feature f) {
        HintEnum enumArea = (HintEnum)f.getHintValue(WINDOW_AREA, HintEnum.class);
        if (enumArea != null) {
            String area = enumArea.getName();
            if (area.equals(AREA_CONTENT)) {
                this.removeContent(f);
            } else if (area.equals(AREA_TOOLBAR)) {
                this.removeFromToolbar(f);
            } else if (area.equals(AREA_OPTIONS_MENU)) {
                this.removeOption(f);
            } else if (area.equals(AREA_INVISIBLE)) {
                this.closeFeatures();
            }
        } else {
            this.removeCloseFeature(f);
        }
    }

    private void removeFromToolbar(Feature feature) {
        if (feature.getPath().contains("captionSource") && this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.sourcePanel.removeSourceComponent();
            a.dispose();
        }
    }

    private void setPrefs(Feature f) {
        String path = f.getPath();
        WindowInfo.Persistence save = WindowInfo.Persistence.fromHint(f);
        boolean posn = false;
        boolean size = false;
        switch (save) {
            case BOUNDS: {
                size = true;
                posn = true;
                break;
            }
            case POSITION: {
                posn = true;
                break;
            }
            case SIZE: {
                size = true;
                break;
            }
        }
        if (path == null) {
            throw new IllegalStateException("path must be set using \"setPath(String)\"");
        }
        if (posn) {
            this.captionWindow.setPositionPreference("window" + path.replace('/', '.') + ".posn");
        } else {
            this.captionWindow.setPositionPreference(null);
        }
        if (size) {
            this.captionWindow.setSizePreference("window" + path.replace('/', '.') + ".size");
        } else {
            this.captionWindow.setSizePreference(null);
        }
    }

    private void registerPrefListeners() {
        this.windowModel.addPropertyChangeListener("Caption.bgcolor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null && evt.getNewValue() instanceof Color) {
                    CaptionWindowLocationHandler.this.prefs.setSetting(CaptionWindowLocationHandler.this.bgColorPref, (Color)evt.getNewValue());
                }
            }
        });
        this.windowModel.addPropertyChangeListener("Caption.fgcolor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null && evt.getNewValue() instanceof Color) {
                    CaptionWindowLocationHandler.this.prefs.setSetting(CaptionWindowLocationHandler.this.fgColorPref, (Color)evt.getNewValue());
                }
            }
        });
        this.windowModel.addPropertyChangeListener("Caption.fontsize", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null && evt.getNewValue() instanceof Integer) {
                    CaptionWindowLocationHandler.this.prefs.setSetting(CaptionWindowLocationHandler.this.fontSizePref, ((Integer)evt.getNewValue()).intValue());
                }
            }
        });
        this.windowModel.addPropertyChangeListener("Caption.fontfamily", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null && evt.getNewValue() instanceof String) {
                    CaptionWindowLocationHandler.this.prefs.setSetting(CaptionWindowLocationHandler.this.fontFamilyPref, (String)evt.getNewValue());
                }
            }
        });
    }

    private void fireMessageThroughFeature(byte[] msg) {
        if (msg != null && msg.length > 0) {
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                params.put("text", new String(msg, "UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            this.captionInputFeature.fireActionFeatureListeners(params);
        }
    }
}

