/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components.skin.shade;

import com.elluminate.classroom.swing.components.STextField;
import com.elluminate.classroom.swing.components.skin.delegate.DelegateTextUI;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class ShadeTextFieldUI
extends DelegateTextUI {
    private STextField tf;
    private PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("placeholderText")) {
                ShadeTextFieldUI.this.tf.repaint();
            }
        }
    };
    private FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            ShadeTextFieldUI.this.focused = true;
            ShadeTextFieldUI.this.tf.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            ShadeTextFieldUI.this.focused = false;
            ShadeTextFieldUI.this.filled = ShadeTextFieldUI.this.tf.getText().length() != 0;
            ShadeTextFieldUI.this.tf.repaint();
        }
    };
    private boolean focused = false;
    private boolean filled = false;

    public static ComponentUI createUI(JComponent c) {
        return new ShadeTextFieldUI();
    }

    public ShadeTextFieldUI() {
        super("TextFieldUI");
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.tf = (STextField)c;
        this.tf.addPropertyChangeListener("placeholderText", this.propertyListener);
        this.tf.addFocusListener(this.focusListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.tf.removePropertyChangeListener("placeholderText", this.propertyListener);
        this.tf.removeFocusListener(this.focusListener);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        if (!this.focused && !this.filled) {
            g.setFont(this.tf.getFont());
            g.setColor(Color.GRAY);
            Insets ins = this.tf.getInsets();
            FontMetrics fm = g.getFontMetrics();
            g.drawString(this.tf.getPlaceholderText(), ins.left, (this.tf.getHeight() - fm.getAscent() - fm.getDescent()) / 2 + fm.getAscent());
        }
    }
}

