/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components.skin.shade;

import com.elluminate.classroom.swing.components.SPalette;
import com.elluminate.classroom.swing.components.skin.SPaletteUI;
import com.elluminate.classroom.swing.components.skin.shade.Shade;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class ShadePaletteUI
extends SPaletteUI {
    private static final Image VERTICAL_HEADER = Shade.getImage("annotationtools_ver_top.png");
    private static final Image VERTICAL_BODY = Shade.getImage("annotationtools_ver_mid.png");
    private static final Image VERTICAL_FOOTER = Shade.getImage("annotationtools_ver_bot.png");
    private static final Image HORIZONTAL_HEADER = Shade.getImage("annotationtools_horz_lft.png");
    private static final Image HORIZONTAL_BODY = Shade.getImage("annotationtools_horz_mid.png");
    private static final Image HORIZONTAL_FOOTER = Shade.getImage("annotationtools_horz_rt.png");
    private SPalette p;
    private PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("orientation")) {
                ShadePaletteUI.this.p.repaint();
            }
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new ShadePaletteUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.p = (SPalette)c;
        this.p.setOpaque(false);
        if (this.p.getOrientation() == 0) {
            this.p.setPaletteWidth(HORIZONTAL_HEADER.getHeight(this.p));
            this.p.setBorder(BorderFactory.createEmptyBorder(3, HORIZONTAL_HEADER.getWidth(this.p), 9, HORIZONTAL_HEADER.getWidth(this.p)));
        } else {
            this.p.setPaletteWidth(VERTICAL_HEADER.getWidth(this.p));
            this.p.setBorder(BorderFactory.createEmptyBorder(VERTICAL_HEADER.getHeight(this.p), 3, VERTICAL_FOOTER.getHeight(this.p), 8));
        }
        this.p.addPropertyChangeListener("orientation", this.propertyListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.p.removePropertyChangeListener("orientation", this.propertyListener);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension s = this.p.getSize();
        if (this.p.getOrientation() == 0) {
            int x;
            g.drawImage(HORIZONTAL_HEADER, 0, 0, this.p);
            int w = s.width - HORIZONTAL_HEADER.getWidth(this.p) - HORIZONTAL_FOOTER.getWidth(this.p);
            int x2 = x + w;
            Shape oldClip = g.getClip();
            g.clipRect(x, 0, w, s.height);
            for (x = HORIZONTAL_HEADER.getWidth(this.p); x < x2; x += HORIZONTAL_BODY.getWidth(this.p)) {
                g.drawImage(HORIZONTAL_BODY, x, 0, this.p);
            }
            g.setClip(oldClip);
            g.drawImage(HORIZONTAL_FOOTER, s.width - HORIZONTAL_FOOTER.getWidth(this.p), 0, this.p);
        } else {
            int y;
            g.drawImage(VERTICAL_HEADER, 0, 0, this.p);
            int h = s.height - VERTICAL_HEADER.getHeight(this.p) - VERTICAL_FOOTER.getHeight(this.p);
            int y2 = y + h;
            Shape oldClip = g.getClip();
            g.clipRect(0, y, s.width, h);
            for (y = VERTICAL_HEADER.getHeight(this.p); y < y2; y += VERTICAL_BODY.getHeight(this.p)) {
                g.drawImage(VERTICAL_BODY, 0, y, this.p);
            }
            g.setClip(oldClip);
            g.drawImage(VERTICAL_FOOTER, 0, s.height - VERTICAL_FOOTER.getHeight(this.p), this.p);
        }
    }
}

