/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components.skin.delegate;

import com.elluminate.classroom.swing.components.skin.delegate.DelegateConstants;
import java.awt.Dimension;
import java.awt.Graphics;
import java.lang.reflect.Method;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class DelegateButtonUI
extends BasicButtonUI
implements DelegateConstants {
    private String delegateUIClassID;
    private ComponentUI delegate;

    protected DelegateButtonUI(String delegateUIClassID) {
        this.delegateUIClassID = delegateUIClassID;
    }

    @Override
    public void installUI(JComponent c) {
        c.putClientProperty("Delegate.bypassGetUIClassID", true);
        this.delegate = DelegateButtonUI.loadDelegate(c, this.delegateUIClassID);
        if (this.delegate == null) {
            throw new IllegalStateException("null delegate for " + this.delegateUIClassID);
        }
        this.delegate.installUI(c);
        c.putClientProperty("Delegate.bypassGetUIClassID", null);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.putClientProperty("Delegate.bypassGetUIClassID", true);
        this.delegate.uninstallUI(c);
        c.putClientProperty("Delegate.bypassGetUIClassID", null);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.delegate.paint(g, c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        c.putClientProperty("Delegate.bypassGetUIClassID", true);
        this.delegate.update(g, c);
        c.putClientProperty("Delegate.bypassGetUIClassID", null);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.delegate.getPreferredSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.delegate.getMinimumSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.delegate.getMaximumSize(c);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return this.delegate.contains(c, x, y);
    }

    @Override
    public int getAccessibleChildrenCount(JComponent c) {
        return this.delegate.getAccessibleChildrenCount(c);
    }

    @Override
    public Accessible getAccessibleChild(JComponent c, int i) {
        return this.delegate.getAccessibleChild(c, i);
    }

    private static ComponentUI loadDelegate(JComponent c, String delegateUIClassID) {
        UIDefaults def = UIManager.getDefaults();
        ClassLoader cl = (ClassLoader)def.get("ClassLoader");
        if (cl == null) {
            cl = c.getClass().getClassLoader();
        }
        Class<? extends ComponentUI> clss = def.getUIClass(delegateUIClassID, cl);
        try {
            ComponentUI cUI;
            Method m = (Method)def.get(clss);
            if (m == null) {
                m = clss.getMethod("createUI", JComponent.class);
                def.put(clss, m);
            }
            if ((cUI = (ComponentUI)m.invoke(null, c)) == null) {
                throw new IllegalStateException(m + " returned null when passed " + c);
            }
            return cUI;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not load ComponentUI using " + c.getClass().getName() + " and  delegateUIClassID: " + delegateUIClassID, ex);
        }
    }
}

