/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components;

import com.elluminate.classroom.swing.components.MenuButtonFocusDisplayer;
import com.elluminate.classroom.swing.components.SMenuButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class SWindow
extends JComponent
implements Accessible {
    private static final String uiClassID = "SWindowUI";
    private String title;
    protected JPanel toolbar;
    protected JPanel tools;
    protected SMenuButton optionsButton;
    private JPanel contentPane;
    private ComponentListener optionListener;
    private Font optionsFont;

    public SWindow() {
        this.setLayout(new BorderLayout());
        this.toolbar = new JPanel(new BorderLayout(4, 0));
        this.toolbar.setOpaque(false);
        this.toolbar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("ShadeWindow.background")), BorderFactory.createEmptyBorder(0, 8, 0, 4)));
        this.toolbar.setOpaque(true);
        this.add((Component)this.toolbar, "North");
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setOpaque(true);
        this.contentPane.setVisible(true);
        this.contentPane.setBorder(BorderFactory.createEmptyBorder(10, 5, 20, 5));
        this.add((Component)this.contentPane, "Center");
        this.tools = new JPanel(new BorderLayout(4, 0));
        this.tools.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tools.setOpaque(true);
        this.toolbar.add((Component)this.tools, "Center");
        this.optionsButton = new SMenuButton();
        this.optionsButton.setVisible(false);
        this.optionsButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optionsButton.setIcon(UIManager.getIcon("ActionBar.optionsIcon"));
        this.optionsButton.setSelectedIcon(UIManager.getIcon("ActionBar.optionsPressedIcon"));
        this.optionsButton.setPressedIcon(UIManager.getIcon("ActionBar.optionsPressedIcon"));
        this.optionsButton.setRolloverIcon(UIManager.getIcon("ActionBar.optionsRolloverIcon"));
        this.optionsButton.setRolloverSelectedIcon(UIManager.getIcon("ActionBar.optionsPressedIcon"));
        this.optionsButton.setContentAreaFilled(false);
        this.optionsButton.setArrowPainted(false);
        MenuButtonFocusDisplayer fd = new MenuButtonFocusDisplayer();
        this.optionsButton.addFocusListener(fd);
        this.optionsButton.getMenu().addPopupMenuListener(fd);
        this.optionsButton.getMenu().addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component c = e.getChild();
                c.setFont(SWindow.this.optionsFont);
                c.addComponentListener(SWindow.this.optionListener);
                if (c.isVisible()) {
                    SWindow.this.optionsButton.setVisible(true);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component c = e.getChild();
                c.removeComponentListener(SWindow.this.optionListener);
                if (!SWindow.this.hasVisibleOptions()) {
                    SWindow.this.optionsButton.setVisible(false);
                }
            }
        });
        this.toolbar.add((Component)this.optionsButton, "East");
        this.optionListener = new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SWindow.this.optionsButton.setVisible(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                if (!SWindow.this.hasVisibleOptions()) {
                    SWindow.this.optionsButton.setVisible(false);
                }
            }
        };
        this.setupOptionsMenuKeyBinding();
        Font f = UIManager.getFont("PopupMenu.font");
        this.optionsFont = f.deriveFont((float)(f.getSize() * 11 / 12));
        this.updateUI();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public JPopupMenu getOptionsMenu() {
        return this.optionsButton.getMenu();
    }

    public JPanel getToolbar() {
        return this.tools;
    }

    private void setupOptionsMenuKeyBinding() {
        KeyStroke optionsKeystroke = this.getOptionsKeystroke();
        String actionName = "open.options.menu." + this.hashCode();
        this.getInputMap(1).put(optionsKeystroke, actionName);
        this.getActionMap().put(actionName, new AbstractAction(actionName){

            @Override
            public void actionPerformed(ActionEvent e) {
                SWindow.this.optionsButton.doClick();
            }
        });
    }

    private KeyStroke getOptionsKeystroke() {
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        return KeyStroke.getKeyStroke(79, mask | 0x40);
    }

    private boolean hasVisibleOptions() {
        for (Component c : this.optionsButton.getMenu().getComponents()) {
            if (!c.isVisible()) continue;
            return true;
        }
        return false;
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSWindow();
        }
        return this.accessibleContext;
    }

    protected class AccessibleSWindow
    extends JComponent.AccessibleJComponent {
        protected AccessibleSWindow() {
            super(SWindow.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

