/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components;

import com.elluminate.classroom.swing.components.SMenuButton;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ButtonModel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class MenuButtonFocusDisplayer
implements FocusListener,
PopupMenuListener {
    private boolean overridingRollover;
    private boolean hidingPopup;
    private boolean showingPopup;

    @Override
    public void focusGained(FocusEvent e) {
        SMenuButton b = (SMenuButton)e.getComponent();
        ButtonModel m = b.getModel();
        if (!m.isArmed() && !this.hidingPopup) {
            m.setRollover(true);
            this.overridingRollover = true;
        }
        this.hidingPopup = false;
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.overridingRollover && !this.showingPopup) {
            SMenuButton b = (SMenuButton)e.getComponent();
            b.getModel().setRollover(false);
            this.overridingRollover = false;
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.showingPopup = true;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.showingPopup = false;
        this.hidingPopup = true;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }
}

