/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components;

import com.elluminate.classroom.swing.components.WeightLayout;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

class DockingAdapter
implements MouseListener,
MouseMotionListener {
    public static final String DOCKED_PROPERTY = "docked";
    public static final String FOCUSABLE_WINDOW_STATE_BYPASS = "DockingAdapter.bypassFocusableWindowState";
    private static final int DOCKING_BORDER = 30;
    private Component component;
    private Class<? extends RootPaneContainer> windowClass;
    private WindowListener closeListener;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private Container originalContainer;
    private Object originalConstraints;
    private JPanel placeholder;
    private int originalIndex;
    private int newIndex;
    private boolean docked = true;
    private boolean enabled = true;
    private Point handle;
    private Frame originalWindow;
    private Point undockedLocation;
    private Dimension undockedSize;
    private boolean resizeOnUndock;
    private Insets insets;

    public DockingAdapter(Component component) {
        this(component, JWindow.class);
    }

    public DockingAdapter(Component component, Class<? extends RootPaneContainer> windowClass) {
        this.component = component;
        this.windowClass = windowClass;
        this.closeListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DockingAdapter.this.dock(false);
            }
        };
    }

    public void setWindowClass(Class<? extends RootPaneContainer> windowClass) {
        this.windowClass = windowClass;
    }

    public void setUndockedLocation(Point undockedLocation) {
        this.undockedLocation = undockedLocation;
    }

    public void setUndockedSize(Dimension undockedSize) {
        this.undockedSize = undockedSize;
    }

    public void setResizeOnUndock(boolean resizeOnUndock) {
        this.resizeOnUndock = resizeOnUndock;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isDocked() {
        return this.docked;
    }

    public void setDocked(boolean docked) {
        if (this.docked == docked) {
            return;
        }
        if (docked) {
            this.dock(false);
        } else {
            this.undock();
        }
    }

    private void updateDocked(boolean docked) {
        boolean old = this.docked;
        this.docked = docked;
        this.propertySupport.firePropertyChange(DOCKED_PROPERTY, old, docked);
    }

    private void dock(boolean dragging) {
        Window undockedWindow = SwingUtilities.getWindowAncestor(this.component);
        final Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (!dragging) {
            this.undockedLocation = undockedWindow.getLocation();
            if (this.undockedSize != null) {
                this.undockedSize = undockedWindow.getSize();
            }
        }
        int index = this.originalIndex;
        index = this.newIndex != -1 ? this.newIndex : Math.min(index, this.originalContainer.getComponentCount());
        this.originalContainer.add(this.component, this.originalConstraints, index);
        if (this.placeholder != null && this.placeholder.getParent() == this.originalContainer) {
            this.originalContainer.remove(this.placeholder);
        }
        this.component.invalidate();
        this.originalContainer.validate();
        this.originalContainer.repaint();
        undockedWindow.removeWindowListener(this.closeListener);
        undockedWindow.setVisible(false);
        undockedWindow.dispose();
        this.updateDocked(true);
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (focused != null) {
                    focused.requestFocus();
                }
            }
        });
    }

    private void dock(MouseEvent e) {
    }

    private void undock() {
        if (!this.enabled) {
            return;
        }
        Point pt = this.undockedLocation;
        if (pt == null) {
            pt = new Point(50, 50);
        }
        this.undock(pt, false);
        this.originalWindow = null;
    }

    private void undock(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        Point pt = e.getPoint();
        SwingUtilities.convertPointToScreen(pt, e.getComponent());
        this.undock(pt, true);
    }

    private void undock(Point mouseLocationOnScreen, boolean dragging) {
        Window w;
        if (!this.enabled) {
            return;
        }
        this.originalContainer = this.component.getParent();
        this.originalConstraints = this.saveOriginalConstraints(this.originalContainer);
        this.originalIndex = this.originalContainer.getComponentZOrder(this.component);
        this.newIndex = -1;
        this.originalWindow = (Frame)SwingUtilities.getWindowAncestor(this.component);
        try {
            Constructor<? extends RootPaneContainer> init = this.windowClass.getConstructor(Frame.class);
            w = (Window)((Object)init.newInstance(this.originalWindow));
        }
        catch (Exception ex) {
            try {
                Constructor<? extends RootPaneContainer> init = this.windowClass.getConstructor(new Class[0]);
                w = (Window)((Object)init.newInstance(new Object[0]));
            }
            catch (Exception ex2) {
                return;
            }
        }
        if (w instanceof JDialog) {
            ((JDialog)w).setDefaultCloseOperation(0);
        }
        if (w instanceof JFrame) {
            ((JFrame)w).setDefaultCloseOperation(0);
        }
        w.addWindowListener(this.closeListener);
        w.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                DockingAdapter.this.maybePredock(MouseInfo.getPointerInfo().getLocation());
            }
        });
        this.prepareUndockedWindow(w);
        w.addNotify();
        this.insets = w.getInsets();
        Dimension s = null;
        if (!dragging || this.resizeOnUndock) {
            s = this.undockedSize;
        }
        if (s == null) {
            s = new Dimension(this.component.getSize());
            s.width += this.insets.left + this.insets.right;
            s.height += this.insets.top + this.insets.bottom;
        }
        Point pos = new Point(mouseLocationOnScreen);
        if (this.handle != null) {
            pos.x -= this.handle.x + this.insets.left;
            pos.y -= this.handle.y + this.insets.top;
        }
        w.setBounds(pos.x, pos.y, s.width, s.height);
        JPanel c = (JPanel)((RootPaneContainer)((Object)w)).getContentPane();
        c.setLayout(new BorderLayout());
        c.add(this.component, "Center");
        if (this.originalWindow.isShowing()) {
            this.finishUndock(w, mouseLocationOnScreen);
        } else {
            final Window w2 = w;
            final Point mouseLocationOnScreen2 = mouseLocationOnScreen;
            this.originalWindow.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    e.getWindow().removeWindowListener(this);
                    DockingAdapter.this.finishUndock(w2, mouseLocationOnScreen2);
                }
            });
        }
    }

    private void finishUndock(Window w, Point mouseLocationOnScreen) {
        Method setWindowOpacityMethod = DockingAdapter.getSetWindowOpacityMethod();
        try {
            if (setWindowOpacityMethod != null) {
                setWindowOpacityMethod.invoke(null, w, Float.valueOf(0.0f));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        boolean preventFocusGrab = false;
        Component focused = null;
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (c != null && !(c instanceof JRootPane) && !SwingUtilities.isDescendingFrom(c, this.component)) {
            preventFocusGrab = true;
            ((RootPaneContainer)((Object)w)).getRootPane().putClientProperty(FOCUSABLE_WINDOW_STATE_BYPASS, false);
        } else if (!(c instanceof JRootPane)) {
            focused = c;
        }
        w.setVisible(true);
        this.updateDocked(false);
        final Method method = setWindowOpacityMethod;
        final Window window = w;
        final boolean preventFocusGrab2 = preventFocusGrab;
        final Component focused2 = focused;
        final Point mouseLocationOnScreen2 = mouseLocationOnScreen;
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (method != null) {
                        method.invoke(null, window, Float.valueOf(1.0f));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DockingAdapter.this.maybePredock(mouseLocationOnScreen2);
                DockingAdapter.this.originalContainer.validate();
                DockingAdapter.this.originalContainer.repaint();
                if (preventFocusGrab2) {
                    ((RootPaneContainer)((Object)window)).getRootPane().putClientProperty(DockingAdapter.FOCUSABLE_WINDOW_STATE_BYPASS, null);
                } else if (focused2 != null) {
                    focused2.requestFocus();
                }
            }
        });
    }

    protected void prepareUndockedWindow(Window window) {
    }

    private void maybePredock(Point mouseLocationOnScreen) {
        Point pt = mouseLocationOnScreen;
        SwingUtilities.convertPointFromScreen(pt, this.originalContainer);
        if (this.originalContainer.contains(pt)) {
            if (this.placeholder == null) {
                this.placeholder = new JPanel();
                this.placeholder.setOpaque(false);
            }
            this.placeholder.setMinimumSize(this.component.getSize());
            this.placeholder.setPreferredSize(this.component.getSize());
            this.placeholder.setMaximumSize(this.component.getSize());
            this.predock(this.originalContainer, this.placeholder, pt);
        } else if (this.placeholder != null && this.placeholder.getParent() == this.originalContainer) {
            this.originalContainer.remove(this.placeholder);
            this.originalContainer.validate();
            this.originalContainer.repaint();
        }
    }

    protected void predock(Container container, Component placeholder, Point location) {
        int index = this.originalIndex;
        Component c = container.getComponentAt(location);
        if (c == placeholder) {
            return;
        }
        if (c != null && c != container) {
            Point pt = SwingUtilities.convertPoint(container, location, c);
            int idx = container.getComponentZOrder(c);
            index = pt.y < c.getHeight() / 2 ? idx : idx + 1;
        }
        if (index >= container.getComponentCount()) {
            index = -1;
        }
        container.add(placeholder, this.originalConstraints, index);
        placeholder.invalidate();
        container.validate();
        container.repaint();
        this.newIndex = index != this.originalIndex ? index : -1;
    }

    private void maybeDock() {
        if (this.placeholder != null && this.placeholder.getParent() == this.originalContainer) {
            this.originalContainer.remove(this.placeholder);
            this.dock(true);
        }
    }

    private void track(MouseEvent e) {
        Window w = SwingUtilities.getWindowAncestor(this.component);
        Point pt = e.getPoint();
        SwingUtilities.convertPointToScreen(pt, e.getComponent());
        if (this.originalWindow != null) {
            SwingUtilities.convertPointToScreen(pt, this.originalWindow);
        }
        Rectangle bounds = new Rectangle(new Point(pt.x - this.handle.x - this.insets.left, pt.y - this.handle.y - this.insets.top), w.getSize());
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle b = gc.getBounds();
            Insets ins = Toolkit.getDefaultToolkit().getScreenInsets(gc);
            b.x += ins.left;
            b.y += ins.top;
            b.width -= ins.left + ins.right;
            b.height -= ins.top + ins.bottom;
            if (!b.intersects(bounds)) continue;
            bounds.y = Math.max(b.y, bounds.y);
        }
        w.setLocation(bounds.getLocation());
    }

    protected Object saveOriginalConstraints(Container container) {
        LayoutManager l = container.getLayout();
        if (l instanceof BorderLayout) {
            return ((BorderLayout)l).getConstraints(this.component);
        }
        if (l instanceof GridBagLayout) {
            return ((GridBagLayout)l).getConstraints(this.component);
        }
        if (l instanceof WeightLayout) {
            return ((WeightLayout)l).getConstraints(this.component);
        }
        return null;
    }

    private static Method getSetWindowOpacityMethod() {
        try {
            Class<?> cls = Class.forName("com.sun.awt.AWTUtilities");
            return cls.getMethod("setWindowOpacity", Window.class, Float.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(property, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(property, l);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Component c = e.getComponent();
        if (e.getX() < c.getWidth() - 5 && e.getY() >= 5 && e.getY() < 30) {
            this.handle = e.getPoint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.handle != null) {
            this.handle = null;
            if (!this.docked) {
                this.maybeDock();
            }
        }
        this.originalWindow = null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.handle != null) {
            if (this.docked) {
                this.undock(e);
            } else {
                this.track(e);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

