/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.swing.location.PreferencesLocationHandler;
import com.elluminate.framework.feature.BrokerAdapter;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.LocationHandler;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.groupware.imps.PreferencesDialogAPI;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.PreferencesDialog;
import com.elluminate.util.SwingRunner;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.StringTokenizer;

@Singleton
public class PreferencesUIClerk
implements PreferencesDialogAPI {
    private static final String LOCATION = "location";
    private static final String PREFERENCE = "preference";
    private PreferencesDialog prefsDialog;
    private FeatureBroker broker;
    private SwingRunner swingRunner;

    @Inject
    public PreferencesUIClerk(PreferencesDialog dialog) {
        this.prefsDialog = dialog;
    }

    @Inject
    protected void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    protected void initImps(Imps imps) {
        if (imps != null) {
            imps.provideAPI(PreferencesDialogAPI.class, (ImpsAPI)this);
        }
    }

    @Inject
    public void initPreferencesLocationHandler(BrokerAdapter brokerAdapter, PreferencesLocationHandler locationHandler) {
        brokerAdapter.addLocationHandler(PREFERENCE, (LocationHandler)locationHandler);
    }

    @Inject
    public void initSwingRunner(SwingRunner swingRunner) {
        this.swingRunner = swingRunner;
    }

    public void setPreferencesDialogVisible(final boolean visible) {
        this.swingRunner.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                PreferencesUIClerk.this.prefsDialog.setVisible(visible);
            }
        });
    }

    public void manualAdd(AbstractPreferencesPanel panel) {
        this.prefsDialog.addPanel(panel);
    }

    public void manualRemove(AbstractPreferencesPanel panel) {
        this.prefsDialog.removePanel(panel);
    }

    public String getProvider() {
        return "PreferencesUIClerk";
    }

    public byte getTier() {
        return 32;
    }

    public void showFeaturePreferencesPanelByPath(String featurePath) {
        Object obj;
        if (this.broker == null) {
            return;
        }
        Feature f = this.broker.getFeature(featurePath);
        boolean showPreferencePanel = false;
        if (f != null && (obj = f.getHintValue(LOCATION)) != null) {
            String str = String.valueOf(obj);
            if (str.startsWith("[")) {
                str = str.substring(1);
            }
            if (str.endsWith("]")) {
                str = str.substring(0, str.length() - 1);
            }
            StringTokenizer st = new StringTokenizer(str, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!token.equals(PREFERENCE)) continue;
                showPreferencePanel = true;
                break;
            }
        }
        if (!showPreferencePanel) {
            throw new IllegalArgumentException("Path is not defined for Preferences " + featurePath);
        }
        this.prefsDialog.showPanel(this.getPanel(f));
        this.prefsDialog.setVisible(true);
    }

    private AbstractPreferencesPanel getPanel(Feature f) {
        ComponentFeature cf = (ComponentFeature)f;
        return (AbstractPreferencesPanel)cf.getComponent();
    }
}

