/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.swing.components.SPlayerBar;
import com.elluminate.classroom.swing.location.PlayerLocationHandler;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class PlayerBar
extends SPlayerBar {
    private JPanel displayPanel;
    private JPanel navigationPanel;
    private JPanel controlPanel;

    public PlayerBar() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(UIManager.getColor("PlayerBar.BorderColor"), 2));
        this.setBackground(UIManager.getColor("PlayerBar.background"));
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.displayPanel = new JPanel();
        this.displayPanel.setOpaque(false);
        this.navigationPanel = new JPanel();
        this.navigationPanel.setOpaque(false);
        this.controlPanel = new JPanel();
        this.controlPanel.setOpaque(false);
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.navigationPanel, c);
        c.fill = 2;
        c.weightx = 0.0;
        c.gridx = 1;
        c.gridy = 0;
        this.add((Component)this.controlPanel, c);
        c.weightx = 1.0;
        c.gridx = 2;
        c.gridy = 0;
        this.add((Component)this.displayPanel, c);
    }

    @Inject
    public void initLocationHandler(PlayerLocationHandler locationHandler) {
        locationHandler.setPlayerBar(this);
    }

    public void addDisplayComponent(Component component) {
        GridBagConstraints gbc = new GridBagConstraints();
        this.displayPanel.add(component, gbc);
        this.displayPanel.revalidate();
        this.displayPanel.repaint();
        this.setPreferredSize(new Dimension(0, 40));
    }

    public void addSelectorComponent(JComboBox cb) {
        cb.setPreferredSize(new Dimension(250, 25));
        GridBagConstraints gbc = new GridBagConstraints();
        this.navigationPanel.add((Component)cb, gbc);
        this.navigationPanel.revalidate();
        this.navigationPanel.repaint();
        this.setPreferredSize(new Dimension(0, 40));
    }

    public void addAction(AbstractButton button) {
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setContentAreaFilled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        this.controlPanel.add((Component)button, gbc);
        this.controlPanel.revalidate();
        this.controlPanel.repaint();
        this.setPreferredSize(new Dimension(0, 40));
    }

    public void removeAction(Component c) {
        this.controlPanel.remove(c);
        this.controlPanel.revalidate();
        this.controlPanel.repaint();
    }

    public void removeDisplay(Component c) {
        this.displayPanel.remove(c);
        this.displayPanel.revalidate();
        this.displayPanel.repaint();
    }

    public void removeNavigation(JComponent c) {
        this.navigationPanel.remove(c);
        this.navigationPanel.revalidate();
        this.navigationPanel.repaint();
    }
}

