/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.swing.TopFocusReceiver;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;

public class PanelNavigation {
    private final Object lock = new Object();
    final String transferFocusNextAction = "transfer-panel-focus-next";
    final KeyStroke transferFocusNextKeyStroke = KeyStroke.getKeyStroke(117, 0);
    final String transferFocusPreviousAction = "transfer-panel-focus-previous";
    final KeyStroke transferFocusPreviousKeyStroke = KeyStroke.getKeyStroke(117, 64);
    private ArrayList<TopFocusReceiver> navigationPanels = new ArrayList();
    private AWTEventListener windowEventListener = null;
    private JComponent parent = null;

    public PanelNavigation() {
        this.setupWindowEventListener();
    }

    public void setParent(JComponent p) {
        this.parent = p;
    }

    private void setupWindowEventListener() {
        this.windowEventListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                PanelNavigation.this.handleWindowEvent((WindowEvent)event);
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.windowEventListener, 64L);
    }

    private void handleWindowEvent(WindowEvent event) {
        if (event.getID() == 200) {
            this.installWindowNavigation(event.getWindow());
        } else if (event.getID() == 202) {
            this.uninstallWindowNavigation(event.getWindow());
        }
        this.reorganizeTopFocusReceivers();
    }

    private void installWindowNavigation(Window w) {
        if (w instanceof RootPaneContainer) {
            this.registerKeyboardNavigation(((RootPaneContainer)((Object)w)).getRootPane());
        }
    }

    private void uninstallWindowNavigation(Window w) {
        if (w instanceof JWindow) {
            this.deregisterKeyboardNavigation(((RootPaneContainer)((Object)w)).getRootPane());
        }
    }

    public void setupNavigationOrder(Component comp) {
        this.reorganizeTopFocusReceivers(comp);
    }

    private void reorganizeTopFocusReceivers() {
        this.reorganizeTopFocusReceivers(this.parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reorganizeTopFocusReceivers(Component comp) {
        List<TopFocusReceiver> orderedReceivers = this.getOrderedReceivers(comp);
        Object object = this.lock;
        synchronized (object) {
            if (!orderedReceivers.containsAll(this.navigationPanels)) {
                for (TopFocusReceiver receiver : this.navigationPanels) {
                    if (orderedReceivers.contains(receiver)) continue;
                    orderedReceivers.add(receiver);
                }
            }
            this.navigationPanels = new ArrayList<TopFocusReceiver>(orderedReceivers);
        }
    }

    public void registerKeyboardNavigation(JComponent comp) {
        comp.getInputMap(1).put(this.transferFocusNextKeyStroke, "transfer-panel-focus-next");
        comp.getActionMap().put("transfer-panel-focus-next", new AbstractAction("transfer-panel-focus-next"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelNavigation.this.transferPanelNextFocus();
            }
        });
        comp.getInputMap(1).put(this.transferFocusPreviousKeyStroke, "transfer-panel-focus-previous");
        comp.getActionMap().put("transfer-panel-focus-previous", new AbstractAction("transfer-panel-focus-previous"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelNavigation.this.transferPanelPreviousFocus();
            }
        });
    }

    public void deregisterKeyboardNavigation(JComponent comp) {
        comp.getInputMap(1).put(this.transferFocusNextKeyStroke, null);
        comp.getActionMap().put("transfer-panel-focus-next", null);
        comp.getInputMap(1).put(this.transferFocusPreviousKeyStroke, null);
        comp.getActionMap().put("transfer-panel-focus-previous", null);
    }

    private void transferPanelNextFocus() {
        TopFocusReceiver receiver = this.getCurrentTopFocusReceiver();
        if (this.navigationPanels != null && !this.navigationPanels.isEmpty()) {
            int idx = this.navigationPanels.indexOf(receiver);
            idx = idx < 0 || idx == this.navigationPanels.size() - 1 ? 0 : ++idx;
            this.cycleTopFocusRequests(idx, DIRECTION.FORWARD);
        }
    }

    private void transferPanelPreviousFocus() {
        TopFocusReceiver receiver = this.getCurrentTopFocusReceiver();
        if (this.navigationPanels != null && !this.navigationPanels.isEmpty()) {
            int idx = this.navigationPanels.indexOf(receiver);
            idx = idx <= 0 ? this.navigationPanels.size() - 1 : --idx;
            this.cycleTopFocusRequests(idx, DIRECTION.REVERSE);
        }
    }

    private void cycleTopFocusRequests(int initialIndex, DIRECTION dir) {
        int position = initialIndex;
        if (dir == DIRECTION.FORWARD) {
            do {
                TopFocusReceiver navigateTo;
                if ((navigateTo = this.navigationPanels.get(position)).requestTopFocus()) {
                    return;
                }
                if (++position < this.navigationPanels.size()) continue;
                position = 0;
            } while (position != initialIndex);
            return;
        }
        do {
            TopFocusReceiver navigateTo;
            if ((navigateTo = this.navigationPanels.get(position)).requestTopFocus()) {
                return;
            }
            if (--position >= 0) continue;
            position = this.navigationPanels.size() - 1;
        } while (position != initialIndex);
    }

    private List<TopFocusReceiver> getOrderedReceivers(Component comp) {
        ArrayList<TopFocusReceiver> orderedReceivers = new ArrayList<TopFocusReceiver>();
        try {
            Component placeholder;
            Component focusedComponent = null;
            focusedComponent = comp == null ? KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() : comp;
            Component root = placeholder = focusedComponent;
            while (placeholder != null) {
                root = placeholder;
                placeholder = placeholder.getParent();
            }
            orderedReceivers.addAll(this.findReceiversForComponent(root));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orderedReceivers;
    }

    private List<TopFocusReceiver> findReceiversForComponent(Component comp) {
        ArrayList<TopFocusReceiver> receivers = new ArrayList<TopFocusReceiver>();
        if (comp != null) {
            if (comp instanceof TopFocusReceiver) {
                receivers.add((TopFocusReceiver)((Object)comp));
            } else if (comp instanceof Container) {
                Component[] components;
                for (Component c : components = ((Container)comp).getComponents()) {
                    receivers.addAll(this.findReceiversForComponent(c));
                }
            }
        }
        return receivers;
    }

    private TopFocusReceiver getCurrentTopFocusReceiver() {
        Container container;
        Component focusedComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusedComponent == null) {
            return null;
        }
        Container container2 = container = focusedComponent instanceof Container ? (Container)focusedComponent : focusedComponent.getParent();
        while (container != null) {
            if (container instanceof TopFocusReceiver) {
                return (TopFocusReceiver)((Object)container);
            }
            container = container.getParent();
        }
        return null;
    }

    public void getNextFocus() {
        this.transferPanelNextFocus();
    }

    private static enum DIRECTION {
        FORWARD,
        REVERSE;

    }
}

