/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.swing.location.ModeControllerLocationHandler;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAvailableListener;
import com.elluminate.groupware.imps.ModeSwitchingEnabledEvent;
import com.elluminate.groupware.imps.ModeSwitchingEnabledListener;
import com.elluminate.groupware.imps.view.ViewAPI;
import com.elluminate.groupware.imps.view.ViewMode;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EnumMap;
import java.util.Map;

@Singleton
public class ModeController {
    private static final String MODE_PROPERTY = "mode";
    private static final String MODE_ENABLED_PROPERTY = "modeEnabled";
    private ViewMode mode = ViewMode.WHITEBOARD;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private Map<ViewMode, ModeData> modes = new EnumMap<ViewMode, ModeData>(ViewMode.class);
    protected ViewAPI viewAPI;

    public ModeController() {
        ModeData d = new ModeData(ViewMode.WHITEBOARD);
        this.modes.put(ViewMode.WHITEBOARD, d);
        d = new ModeData(ViewMode.APPSHARE);
        this.modes.put(ViewMode.APPSHARE, d);
        d = new ModeData(ViewMode.WEBTOUR);
        this.modes.put(ViewMode.WEBTOUR, d);
    }

    @Inject
    public void initLocationHandler(ModeControllerLocationHandler locationHandler) {
        locationHandler.setModeController(this);
    }

    public ViewMode getMode() {
        return this.mode;
    }

    public void setMode(ViewMode mode) {
        ViewMode old = this.mode;
        this.mode = mode;
        this.propertySupport.firePropertyChange(MODE_PROPERTY, old, mode);
    }

    public boolean isModeEnabled(ViewMode mode) {
        ModeData d = this.modes.get(mode);
        if (d != null) {
            return d.isEnabled();
        }
        return false;
    }

    public void setModeEnabled(ViewMode mode, boolean enabled) {
        ModeData d = this.modes.get(mode);
        if (d != null) {
            d.setEnabled(enabled);
        }
    }

    public void addModeChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(MODE_PROPERTY, l);
    }

    public void removeModeChangeListener(PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(MODE_PROPERTY, l);
    }

    public void addModeEnabledListener(PropertyChangeListener l) {
        for (ModeData d : this.modes.values()) {
            d.addPropertyChangeListener(MODE_ENABLED_PROPERTY, l);
        }
    }

    public void removeModeEnabledListener(PropertyChangeListener l) {
        for (ModeData d : this.modes.values()) {
            d.removePropertyChangeListener(MODE_ENABLED_PROPERTY, l);
        }
    }

    @Inject
    public void initImps(Imps imps) {
        ImpsAvailableListener<ViewAPI> listener = new ImpsAvailableListener<ViewAPI>(){

            public void available(ViewAPI api) {
                ModeController.this.viewAPI = api;
                api.addModeSwitchingEnabledListener(ModeController.this.createModeSwitchEnabledListener());
            }

            public void removed(ViewAPI api) {
                ModeController.this.viewAPI = null;
            }
        };
        imps.addImpsAvailableListener((ImpsAvailableListener)listener, ViewAPI.class);
    }

    private ModeSwitchingEnabledListener createModeSwitchEnabledListener() {
        return new ModeSwitchingEnabledListener(){

            public void modeSwitchingEnabled(ModeSwitchingEnabledEvent event) {
                ModeController.this.setModeEnabled(event.getMode(), event.getNext());
            }
        };
    }

    private static class ModeData {
        private boolean enabled;
        private PropertyChangeSupport propertySupport;

        public ModeData(ViewMode mode) {
            this.propertySupport = new PropertyChangeSupport(mode);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            boolean old = this.enabled;
            this.enabled = enabled;
            this.propertySupport.firePropertyChange(ModeController.MODE_ENABLED_PROPERTY, old, enabled);
        }

        public void addPropertyChangeListener(String property, PropertyChangeListener l) {
            this.propertySupport.addPropertyChangeListener(property, l);
        }

        public void removePropertyChangeListener(String property, PropertyChangeListener l) {
            this.propertySupport.removePropertyChangeListener(property, l);
        }
    }
}

