/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.gui.component.EasyDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ItemSelectionDialog
extends EasyDialog {
    private DefaultListModel model;
    private JList list;

    public ItemSelectionDialog(Component owner, String title, String buttonText) {
        super(owner, title);
        JPanel c = new JPanel(new BorderLayout());
        this.setContent(c);
        this.model = new DefaultListModel();
        this.model.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                if (ItemSelectionDialog.this.list.getSelectedIndex() == -1) {
                    ItemSelectionDialog.this.list.setSelectedIndex(0);
                }
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        });
        this.list = new JList(this.model);
        this.list.setVisibleRowCount(4);
        JScrollPane sp = new JScrollPane(this.list, 21, 30);
        this.setContent(sp);
        this.addActionButton(this.makeButton(buttonText), true);
        this.addCancelButton(this.makeButton(0));
    }

    public void setItemRenderer(ListCellRenderer itemRenderer) {
        this.list.setCellRenderer(itemRenderer);
    }

    public void addItem(Object item) {
        this.model.addElement(item);
    }

    public Object getSelectedItem() {
        return this.list.getSelectedValue();
    }
}

