/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.swing.StringsProperties;
import com.elluminate.classroom.swing.TopFocusReceiver;
import com.elluminate.classroom.swing.components.ButtonFocusDisplayer;
import com.elluminate.classroom.swing.components.SButton;
import com.elluminate.classroom.swing.components.SLevelIndicator;
import com.elluminate.classroom.swing.components.SSideBarPanel;
import com.elluminate.classroom.swing.location.AudioVideoLocationHandler;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.UIManager;

public class AudioVideoPanel
extends SSideBarPanel
implements TopFocusReceiver {
    private static final int TOP_BOTTOM_BORDER = 2;
    private JPanel videoPanel;
    private JPanel videoDisplayPanel;
    private JPanel levelPanel;
    private JLabel speakerLabel;
    private JLabel microphoneLabel;
    private JPanel togglePanel;
    private VideoControl videoControl;
    private SButton videoToggle;
    private AbstractButton previewToggle;
    private Icon[] toggleResources;
    private Icon[] toggleSelectedResources;
    private Icon[] toggleRolloverResources;
    private JPanel telephonyPanel;
    private Font telephonyFont;
    private I18n i18n;
    private FeatureBroker featureBroker;
    private ActionFeature dockFeature;
    private boolean videoComponentAdded = false;
    private boolean expansionSetting;

    public AudioVideoPanel() {
        this.addPropertyChangeListener("docked", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                boolean docked = (Boolean)e.getNewValue();
                if (docked) {
                    AudioVideoPanel.this.dockFeature.setName(AudioVideoPanel.this.i18n.getString((PropertiesEnum)StringsProperties.SIDEBARPANEL_DETACH_PANEL));
                } else {
                    AudioVideoPanel.this.dockFeature.setName(AudioVideoPanel.this.i18n.getString((PropertiesEnum)StringsProperties.SIDEBARPANEL_ATTACH_PANEL));
                }
            }
        });
        JPanel c = (JPanel)this.getContentPane();
        c.setLayout(new BorderLayout());
        this.videoPanel = new JPanel(new BorderLayout());
        this.videoPanel.setOpaque(false);
        this.videoPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.videoPanel.setMinimumSize(new Dimension(32, 72));
        c.add((Component)this.videoPanel, "Center");
        this.videoDisplayPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(this.getBackground());
                g.fillRoundRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, 4, 4);
            }
        };
        this.videoDisplayPanel.setOpaque(false);
        this.videoDisplayPanel.setBackground(Color.BLACK);
        this.videoDisplayPanel.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("SideBar.contentBorder"), BorderFactory.createEmptyBorder(-1, -1, -1, -1)));
        JPanel south = new JPanel(new BorderLayout());
        south.setOpaque(false);
        c.add((Component)south, "South");
        this.levelPanel = new JPanel(new GridBagLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(this.getBackground());
                g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 6, 6);
            }
        };
        this.levelPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 8));
        this.levelPanel.setOpaque(false);
        this.levelPanel.setBackground(UIManager.getColor("SideBar.contentBackground"));
        south.add((Component)this.levelPanel, "North");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        this.microphoneLabel = new JLabel(UIManager.getIcon("Audio.microphoneLevelIcon"));
        this.levelPanel.add((Component)this.microphoneLabel, gbc);
        gbc.gridx += 2;
        gbc.weightx = 0.0;
        gbc.insets.left = 8;
        this.speakerLabel = new JLabel(UIManager.getIcon("Audio.speakerLevelIcon"));
        this.levelPanel.add((Component)this.speakerLabel, gbc);
        this.togglePanel = new JPanel(new GridLayout(1, 0, 6, 0));
        this.togglePanel.setOpaque(false);
        this.togglePanel.setVisible(false);
        this.togglePanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        south.add((Component)this.togglePanel, "Center");
        this.videoControl = new VideoControl();
        this.toggleResources = new Icon[]{UIManager.getIcon("AudioVideoButton.leftIcon"), UIManager.getIcon("AudioVideoButton.centerIcon"), UIManager.getIcon("AudioVideoButton.rightIcon")};
        this.toggleSelectedResources = new Icon[]{UIManager.getIcon("AudioVideoButton.leftSelectedIcon"), UIManager.getIcon("AudioVideoButton.centerSelectedIcon"), UIManager.getIcon("AudioVideoButton.rightSelectedIcon")};
        this.toggleRolloverResources = new Icon[]{UIManager.getIcon("AudioVideoButton.leftRolloverIcon"), UIManager.getIcon("AudioVideoButton.centerRolloverIcon"), UIManager.getIcon("AudioVideoButton.rightRolloverIcon")};
        this.telephonyPanel = new JPanel(new GridBagLayout());
        this.telephonyPanel.setOpaque(false);
        this.telephonyPanel.setVisible(false);
        south.add((Component)this.telephonyPanel, "South");
        Font f = UIManager.getFont("Label.font");
        this.telephonyFont = f.deriveFont((float)(f.getSize() * 11 / 12));
    }

    @Inject
    public void initLocationHandler(AudioVideoLocationHandler locationHandler) {
        locationHandler.setAudioVideoPanel(this);
    }

    @Inject
    public void initI18n(I18nProvider provider) {
        this.i18n = provider.get((Object)this);
    }

    @Inject
    public void initFeatureBroker(FeatureBroker featureBroker) {
        this.featureBroker = featureBroker;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.dockFeature == null) {
            this.dockFeature = this.featureBroker.createActionFeature((Object)this, "/ui/audioVideo/dock", this.i18n.getString((PropertiesEnum)StringsProperties.SIDEBARPANEL_DETACH_PANEL), null);
            this.dockFeature.addActionFeatureListener(new ActionFeatureListener(){

                public void actionPerformed(ActionFeatureEvent e) {
                    AudioVideoPanel.this.setDocked(!AudioVideoPanel.this.isDocked());
                }
            });
            this.featureBroker.addFeature((Feature)this.dockFeature);
            this.featureBroker.setFeaturePublished((Feature)this.dockFeature, true);
        }
    }

    @Override
    protected void setContentVisible(boolean contentVisible) {
        this.videoPanel.setVisible(contentVisible);
    }

    @Override
    public boolean requestTopFocus() {
        for (Component child : this.togglePanel.getComponents()) {
            if (!(child instanceof AbstractButton) || !child.isFocusable() || !child.isEnabled()) continue;
            child.requestFocus();
            return true;
        }
        return false;
    }

    private void handleLayout(boolean videoAddedJustNow, boolean audioAddedJustNow) {
        if (this.videoComponentAdded) {
            return;
        }
        this.expansionSetting |= super.isExpanded();
        if (videoAddedJustNow) {
            this.setTitle(this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOVIDEOPANEL_NAME));
            this.videoComponentAdded = true;
            this.addExpandButton();
            super.setExpanded(this.expansionSetting);
        }
        if (audioAddedJustNow && !this.videoComponentAdded) {
            this.setTitle(this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOPANEL_NAME));
            super.setExpanded(false);
            this.removeExpandButton();
        }
    }

    public void addVideoDisplay(Component component) {
        this.videoPanel.add((Component)this.videoDisplayPanel, "Center");
        this.setVisible(true);
        this.videoDisplayPanel.add(component, "Center");
        boolean addedVideo = true;
        boolean addedAudio = false;
        this.handleLayout(addedVideo, addedAudio);
        this.videoDisplayPanel.revalidate();
    }

    public void removeVideoDisplay(Component component) {
        this.videoDisplayPanel.remove(component);
        this.videoDisplayPanel.revalidate();
    }

    public void addSpeakerIndicator(SLevelIndicator indicator) {
        this.addSpeakerComponent(indicator, -1);
    }

    public void removeSpeakerIndicator(SLevelIndicator indicator) {
        this.removeSpeakerComponent(indicator);
    }

    public void addSpeakerSlider(JSlider slider) {
        slider.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOVIDEOPANEL_SPEAKERSLIDERNAME));
        slider.setPaintTrack(false);
        slider.setPaintLabels(false);
        slider.setPaintTicks(false);
        slider.setOpaque(false);
        if (Platform.getLAF() == 502) {
            slider.putClientProperty("JComponent.sizeVariant", "small");
        }
        int v = Math.min(this.speakerLabel.getPreferredSize().height + 4 - slider.getPreferredSize().height, 0) / 2;
        slider.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(v, 0, v, 0), slider.getBorder()));
        this.addSpeakerComponent(slider, 0);
    }

    public void removeSpeakerSlider(JSlider slider) {
        this.removeSpeakerComponent(slider);
    }

    private void addSpeakerComponent(JComponent component, int index) {
        component.setMinimumSize(new Dimension(32, component.getMinimumSize().height));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 3;
        gbc.weightx = 1.0;
        gbc.insets.left = 2;
        this.levelPanel.add(component, gbc, index);
        this.levelPanel.revalidate();
        boolean addedVideo = false;
        boolean addedAudio = true;
        this.handleLayout(addedVideo, addedAudio);
    }

    private void removeSpeakerComponent(JComponent component) {
        this.levelPanel.remove(component);
        this.levelPanel.revalidate();
    }

    public void addMicrophoneIndicator(SLevelIndicator indicator) {
        this.addMicrophoneComponent(indicator, -1);
    }

    public void removeMicrophoneIndicator(SLevelIndicator indicator) {
        this.removeMicrophoneComponent(indicator);
    }

    public void addMicrophoneSlider(JSlider slider) {
        slider.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOVIDEOPANEL_MICSLIDERNAME));
        slider.setPaintTrack(false);
        slider.setPaintLabels(false);
        slider.setPaintTicks(false);
        slider.setOpaque(false);
        if (Platform.getLAF() == 502) {
            slider.putClientProperty("JComponent.sizeVariant", "small");
        }
        int v = Math.min(this.microphoneLabel.getPreferredSize().height + 4 - slider.getPreferredSize().height, 0) / 2;
        slider.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(v, 0, v, 0), slider.getBorder()));
        this.addMicrophoneComponent(slider, 0);
    }

    public void removeMicrophoneSlider(JSlider slider) {
        this.removeMicrophoneComponent(slider);
    }

    private void addMicrophoneComponent(JComponent component, int index) {
        component.setMinimumSize(new Dimension(32, component.getMinimumSize().height));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets.left = 2;
        this.levelPanel.add(component, gbc, index);
        this.levelPanel.revalidate();
        boolean addedVideo = false;
        boolean addedAudio = true;
        this.handleLayout(addedVideo, addedAudio);
    }

    private void removeMicrophoneComponent(JComponent component) {
        this.levelPanel.remove(component);
        this.levelPanel.revalidate();
    }

    public void addAudioToggle(SButton button) {
        this.setVisible(true);
        button.setHorizontalTextPosition(10);
        button.setIconTextGap(8);
        button.addFocusListener(new ButtonFocusDisplayer());
        button.setResources(this.toggleResources);
        button.setSelectedResources(this.toggleSelectedResources);
        button.setRolloverResources(this.toggleRolloverResources);
        this.togglePanel.add((Component)button, 0);
        this.togglePanel.setVisible(true);
        this.togglePanel.revalidate();
        boolean addedVideo = false;
        boolean addedAudio = true;
        this.handleLayout(addedVideo, addedAudio);
    }

    public void removeAudioToggle(SButton button) {
        this.togglePanel.remove(button);
        this.togglePanel.setVisible(this.togglePanel.getComponentCount() != 0);
        this.togglePanel.revalidate();
    }

    public void addVideoToggle(SButton button) {
        this.setVisible(true);
        if (this.videoToggle == null) {
            this.videoToggle = button;
        }
        button.setHorizontalTextPosition(10);
        button.setIconTextGap(8);
        button.addFocusListener(new ButtonFocusDisplayer());
        this.updateVideoToggleResources();
        this.videoControl.addTransmitToggle(button);
        if (!this.togglePanel.isAncestorOf(this.videoControl)) {
            this.togglePanel.add(this.videoControl);
            this.togglePanel.setVisible(true);
            this.togglePanel.revalidate();
        }
        boolean addedVideo = true;
        boolean addedAudio = false;
        this.handleLayout(addedVideo, addedAudio);
    }

    public void removeVideoToggle(SButton button) {
        if (this.videoToggle == button) {
            this.videoToggle = null;
        }
        this.videoControl.removeTransmitToggle(button);
        if (this.videoControl.getComponentCount() == 0) {
            this.togglePanel.remove(this.videoControl);
            this.togglePanel.setVisible(this.togglePanel.getComponentCount() != 0);
            this.togglePanel.revalidate();
        }
    }

    public void addPreviewToggle(SButton button) {
        if (this.previewToggle == null) {
            this.previewToggle = button;
        }
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setContentAreaFilled(false);
        button.addFocusListener(new ButtonFocusDisplayer());
        this.updateVideoToggleResources();
        this.videoControl.addPreviewToggle(button);
        if (!this.togglePanel.isAncestorOf(this.videoControl)) {
            this.togglePanel.add(this.videoControl);
            this.togglePanel.setVisible(true);
            this.togglePanel.revalidate();
        }
        boolean addedVideo = true;
        boolean addedAudio = false;
        this.handleLayout(addedVideo, addedAudio);
    }

    public void removePreviewToggle(SButton button) {
        if (this.previewToggle == button) {
            this.previewToggle = null;
        }
        this.updateVideoToggleResources();
        this.videoControl.removePreviewToggle(button);
        if (this.videoControl.getComponentCount() == 0) {
            this.togglePanel.remove(this.videoControl);
            this.togglePanel.setVisible(this.togglePanel.getComponentCount() != 0);
            this.togglePanel.revalidate();
        }
    }

    private void updateVideoToggleResources() {
        if (this.videoToggle != null) {
            Icon[] rsrcs = this.toggleResources;
            Icon[] sRsrcs = this.toggleSelectedResources;
            Icon[] rRsrcs = this.toggleRolloverResources;
            if (this.previewToggle != null) {
                rsrcs = new Icon[]{this.toggleResources[0], this.toggleResources[1], null};
                sRsrcs = new Icon[]{this.toggleSelectedResources[0], this.toggleSelectedResources[1], null};
                rRsrcs = new Icon[]{this.toggleRolloverResources[0], this.toggleRolloverResources[1], null};
            }
            this.videoToggle.setResources(rsrcs);
            this.videoToggle.setSelectedResources(sRsrcs);
            this.videoToggle.setRolloverResources(rRsrcs);
        }
    }

    public void addTelephonyComponent(JComponent component) {
        component.setFont(this.telephonyFont);
        GridBagConstraints gbc = new GridBagConstraints();
        this.telephonyPanel.add((Component)component, gbc);
        this.telephonyPanel.setVisible(true);
        this.telephonyPanel.revalidate();
    }

    public void removeTelephonyComponent(JComponent component) {
        this.telephonyPanel.remove(component);
        if (this.telephonyPanel.getComponentCount() == 0) {
            this.telephonyPanel.setVisible(false);
        }
        this.telephonyPanel.revalidate();
    }

    private static class VideoControl
    extends JComponent
    implements Accessible {
        public VideoControl() {
            this.setLayout(new BorderLayout());
        }

        public void addTransmitToggle(AbstractButton transmitToggle) {
            this.add((Component)transmitToggle, "Center");
            this.revalidate();
        }

        public void removeTransmitToggle(AbstractButton transmitToggle) {
            this.remove(transmitToggle);
            this.revalidate();
        }

        public void addPreviewToggle(AbstractButton previewToggle) {
            this.add((Component)previewToggle, "East");
            this.revalidate();
        }

        public void removePreviewToggle(AbstractButton previewToggle) {
            this.remove(previewToggle);
            this.revalidate();
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleVideoControl();
            }
            return this.accessibleContext;
        }

        class AccessibleVideoControl
        extends JComponent.AccessibleJComponent {
            AccessibleVideoControl() {
                super(VideoControl.this);
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PANEL;
            }
        }
    }
}

