/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.groupware.imps.EditMenuInterface;
import com.elluminate.groupware.imps.EditMenuSelectionListener;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;

abstract class AbstractEditMenuItem
extends JMenuItem
implements PropertyChangeListener,
CaretListener,
ListSelectionListener,
TreeSelectionListener,
EditMenuSelectionListener {
    protected static KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
    protected static Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    protected Component focusOwner;
    private LightweightTimer adjustEnabledTimer = new LightweightTimer(new Runnable(){

        @Override
        public void run() {
            AbstractEditMenuItem.this.adjustEnabled();
        }
    });

    public AbstractEditMenuItem() {
        focusManager.addPropertyChangeListener("permanentFocusOwner", this);
    }

    protected boolean focusOwnerHasSelection() {
        if (this.focusOwner instanceof JTextComponent) {
            String sel = ((JTextComponent)this.focusOwner).getSelectedText();
            return sel != null && sel.length() != 0;
        }
        if (this.focusOwner instanceof JList) {
            return ((JList)this.focusOwner).getSelectedIndex() != -1;
        }
        if (this.focusOwner instanceof JTable) {
            return ((JTable)this.focusOwner).getSelectedRow() != -1;
        }
        if (this.focusOwner instanceof JTree) {
            return ((JTree)this.focusOwner).getSelectionCount() != 0;
        }
        return false;
    }

    private void requestAdjustEnabled() {
        this.adjustEnabledTimer.scheduleIn(500L);
    }

    protected void setEnabledLater(final boolean enabled) {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractEditMenuItem.this.setEnabled(enabled);
            }
        });
    }

    protected abstract void adjustEnabled();

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.focusOwner instanceof JTextComponent) {
            ((JTextComponent)this.focusOwner).removeCaretListener(this);
        } else if (this.focusOwner instanceof JList) {
            ((JList)this.focusOwner).removeListSelectionListener(this);
        } else if (this.focusOwner instanceof JTable) {
            ((JTable)this.focusOwner).getSelectionModel().removeListSelectionListener(this);
        } else if (this.focusOwner instanceof JTree) {
            ((JTree)this.focusOwner).removeTreeSelectionListener(this);
        } else if (this.focusOwner instanceof EditMenuInterface) {
            ((EditMenuInterface)this.focusOwner).removeEditMenuSelectionListener((EditMenuSelectionListener)this);
        }
        this.focusOwner = focusManager.getPermanentFocusOwner();
        if (this.focusOwner instanceof JTextComponent) {
            ((JTextComponent)this.focusOwner).addCaretListener(this);
        } else if (this.focusOwner instanceof JList) {
            ((JList)this.focusOwner).addListSelectionListener(this);
        } else if (this.focusOwner instanceof JTable) {
            ((JTable)this.focusOwner).getSelectionModel().addListSelectionListener(this);
        } else if (this.focusOwner instanceof JTree) {
            ((JTree)this.focusOwner).addTreeSelectionListener(this);
        } else if (this.focusOwner instanceof EditMenuInterface) {
            ((EditMenuInterface)this.focusOwner).addEditMenuSelectionListener((EditMenuSelectionListener)this);
        }
        this.requestAdjustEnabled();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.requestAdjustEnabled();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.requestAdjustEnabled();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.requestAdjustEnabled();
    }

    public void selectionUpdated() {
        this.requestAdjustEnabled();
    }
}

