/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.timer;

import com.elluminate.groupware.timer.TimerInfo;
import com.elluminate.jinx.Bytes;
import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.util.DebugFlag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

public class TimerProtocol
extends JinxProtocolAdapter {
    public static final DebugFlag DEBUG = DebugFlag.get((String)"timer");
    public static final String CHANNEL = "timer";
    public static final byte PRIORITY = 2;
    public static final byte START_TIMER = 66;
    public static final byte STOP_TIMER = 69;
    public static final byte PAUSE_TIMER = 80;
    public static final byte RESUME_TIMER = 82;
    public static final byte JOIN_PAUSED_TIMER = 74;
    public static final byte TIMER_TYPE = 89;
    public static final byte TIMER_VISIBILITY = 87;
    public static final byte TIMER_VISUAL_ALERT = 86;
    public static final byte TIMER_AUDIBLE_ALERT = 65;
    public static final byte TIMER_TIME = 84;
    public static final byte TIME_CONFIGURABLE_TEXT = 67;
    public static final String PROPERTY = "timer.state";
    public static final byte STATE_PROPERTY_RUNNING = 83;
    public static final byte STATE_PROPERTY_TIMED_OUT = 84;
    public static final byte STATE_PROPERTY_FORCE_CLOSED = 70;
    public static final byte STATE_PROPERTY_PAUSED = 80;

    public TimerProtocol() {
        this.defineChannel(CHANNEL, (byte)2);
        this.defineProperty(PROPERTY, (byte)1, Bytes.get((byte)70));
    }

    public String commandToString(byte cmd) {
        switch (cmd) {
            case 66: {
                return "StartTimer";
            }
            case 69: {
                return "StopTimer";
            }
            case 80: {
                return "PauseTimer";
            }
            case 82: {
                return "ResumeTimer";
            }
            case 74: {
                return "JoinPausedTimer";
            }
        }
        return "[ Invalid timer protocol code - " + cmd + " ]";
    }

    public static void encode(byte cmd, DataOutputStream out, TimerInfo wrapper) throws IOException {
        switch (cmd) {
            case 66: 
            case 74: {
                out.writeByte(89);
                out.writeShort(wrapper.getTimerType());
                out.writeByte(87);
                out.writeShort(wrapper.getTimerVisibility());
                out.writeByte(86);
                out.writeBoolean(wrapper.isVisibleAlert());
                out.writeByte(65);
                out.writeBoolean(wrapper.isAudibleAlert());
                out.writeByte(84);
                out.writeLong(wrapper.getTime());
                if (wrapper.getConfigurableString() == null) break;
                out.writeByte(67);
                out.writeUTF(wrapper.getConfigurableString());
                break;
            }
            case 80: 
            case 82: {
                out.writeByte(84);
                out.writeLong(wrapper.getTime());
            }
        }
    }

    public static TimerInfo decode(DataInputStream in) throws IOException {
        TimerInfo wrapper = new TimerInfo();
        try {
            byte partIndicator = in.readByte();
            while (partIndicator > -1) {
                if (partIndicator == 89) {
                    wrapper.setTimerType(in.readShort());
                } else if (partIndicator == 87) {
                    wrapper.setTimerVisibility(in.readShort());
                } else if (partIndicator == 86) {
                    wrapper.setIsVisibleAlert(in.readBoolean());
                } else if (partIndicator == 65) {
                    wrapper.setIsAudibleAlert(in.readBoolean());
                } else if (partIndicator == 84) {
                    wrapper.setTime(in.readLong());
                } else if (partIndicator == 67) {
                    wrapper.setConfigurableString(in.readUTF());
                }
                partIndicator = in.readByte();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return wrapper;
    }
}

