/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia.module;

import com.elluminate.groupware.multimedia.MultimediaProtocol;
import com.elluminate.groupware.multimedia.module.Progress;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.table.DefaultTableCellRenderer;

class ProgressCellRenderer
extends DefaultTableCellRenderer {
    Progress p;

    ProgressCellRenderer() {
    }

    @Override
    public void setValue(Object o) {
        try {
            this.p = (Progress)o;
        }
        catch (Throwable t) {
            this.p = null;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.p != null) {
            this.p.compute();
            int w = this.getWidth() - 4;
            int h = this.getHeight() - 4;
            int t = this.p.getTotal();
            int x = 2;
            if (t == 0) {
                g.setColor(Color.lightGray);
                g.fillRect(x, 2, w, h);
            } else {
                int n = 0;
                for (int i = MultimediaProtocol.STATUS_PCT.length - 1; i >= 0; --i) {
                    int nx = 2 + (n += this.p.getCount(i)) * w / t;
                    if (nx == x) continue;
                    g.setColor(this.p.getColor(i));
                    g.fillRect(x, 2, nx - x, h);
                    x = nx;
                }
            }
            this.paintTicks(g);
            g.setColor(Color.gray);
            g.drawRect(2, 2, w, h);
        }
    }

    private void paintTicks(Graphics g) {
        int w = this.getWidth() - 4;
        int h = this.getHeight() - 4;
        int y1 = 2 + 6 * h / 8;
        int y5 = 2 + 4 * h / 8;
        int y25 = 2 + 3 * h / 8;
        int y100 = 2 + 2 * h / 8;
        int n = this.p.getTotal();
        int inc = 1;
        inc = n * 4 < w ? 1 : (n * 4 / 5 < w ? 5 : (n * 4 / 25 < w ? 25 : 100));
        for (int i = inc; i < n; i += inc) {
            int y = i % 100 == 0 ? y100 : (i % 25 == 0 ? y25 : (i % 5 == 0 ? y5 : y1));
            int x = w * i / n + 1;
            g.setColor(Color.white);
            g.drawLine(x + 1, y, x + 1, 1 + h);
            g.setColor(Color.gray);
            g.drawLine(x, y, x, 1 + h);
        }
    }
}

