/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia.module;

import com.elluminate.groupware.multimedia.MediaLibraryEntry;
import com.elluminate.groupware.multimedia.MultimediaProtocol;
import java.awt.Color;

class Progress {
    static Color red = new Color(255, 40, 0);
    static Color orange = Color.orange;
    static Color yellow = new Color(255, 205, 0);
    static Color cyan = Color.cyan;
    static Color green = new Color(40, 169, 64);
    MediaLibraryEntry entry;
    short total = 0;
    short[] counts = new short[MultimediaProtocol.STATUS_PCT.length];
    Color[] colors = new Color[]{red, orange, yellow, cyan, green};

    public Progress(MediaLibraryEntry ent) {
        this.entry = ent;
    }

    public void compute() {
        this.total = 0;
        for (int i = 0; i < this.counts.length; ++i) {
            this.counts[i] = this.entry.getStatusCount(i);
            this.total = (short)(this.total + this.counts[i]);
        }
        if (this.entry.getAuthCode() != null) {
            long posn = this.entry.getPosition();
            long len = this.entry.getLength();
            byte pct = 0;
            if (len > 0L) {
                pct = (byte)(posn * 100L / len);
            }
            for (int i = 0; i < this.counts.length; ++i) {
                if (pct > MultimediaProtocol.STATUS_PCT[i]) continue;
                int n = i;
                this.counts[n] = (short)(this.counts[n] + 1);
                break;
            }
            this.total = (short)(this.total + 1);
        }
    }

    public byte getServerStatus() {
        if (this.entry.isIncomplete()) {
            return -this.entry.getServerPercent();
        }
        return this.entry.getServerPercent();
    }

    public short getCount(int i) {
        return this.counts[i];
    }

    public Color getColor(int i) {
        return this.colors[i];
    }

    public int getTotal() {
        return this.total;
    }

    public long getLength() {
        return this.entry.getLength();
    }

    public String toString() {
        this.compute();
        StringBuffer buf = new StringBuffer();
        buf.append(this.counts[0]);
        for (int i = 1; i < this.counts.length; ++i) {
            buf.append("/");
            buf.append(this.counts[i]);
        }
        return buf.toString();
    }
}

