/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.LoadMultimediaCommand;
import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.imps.module.PresentationModeAPI;
import com.elluminate.groupware.multimedia.module.MultimediaBean;
import com.elluminate.groupware.multimedia.module.MultimediaModule;
import com.elluminate.groupware.multimedia.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

public class LoadMultimediaCmd
extends AbstractCommand
implements LoadMultimediaCommand {
    private String fileURL = null;
    @Inject
    private I18n i18n;
    @Inject
    private MultimediaModule module;
    @Inject
    private Imps imps;

    public void setFile(String fileURL) {
        this.fileURL = fileURL;
    }

    protected void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        if (this.fileURL == null || this.fileURL.length() < 1) {
            throw new CommandParameterException("File parameter must be set", this.i18n.getString((PropertiesEnum)StringsProperties.LOADMULTIMEDIACMD_BADPARAMFILENOTSET));
        }
        try {
            URL u = new URL(this.fileURL);
            String proto = u.getProtocol().toLowerCase(Locale.ENGLISH);
            if (!(proto.equals("agenda") || proto.equals("http") || proto.equals("https"))) {
                throw new CommandParameterException("Disallowed URL: " + this.fileURL, this.i18n.getString((PropertiesEnum)StringsProperties.LOADMULTIMEDIACMD_BADPARAMURLNOTSUPPORTED, new Object[]{this.fileURL}));
            }
            MultimediaBean bean = this.module.getMultimediaBean();
            PresentationModeAPI presentationAPI = (PresentationModeAPI)this.imps.findBest(PresentationModeAPI.class);
            if (presentationAPI != null && presentationAPI.isPresenting()) {
                throw new CommandContextException("Cannot load multimedia when in presentation mode", this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIACMD_BADCONTEXTPRESENTATIONUNDERWAY));
            }
            bean.addURL(this.fileURL);
        }
        catch (MalformedURLException ex) {
            throw new CommandParameterException("Invalid URL: " + this.fileURL, this.i18n.getString((PropertiesEnum)StringsProperties.LOADMULTIMEDIACMD_BADPARAMINVALIDURL, new Object[]{this.fileURL}));
        }
    }
}

