/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia.module;

import com.elluminate.groupware.multimedia.module.MediaIDEvent;
import com.elluminate.groupware.multimedia.module.MediaIDListener;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.util.crypto.DiffieHellman;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;

public class IDClient
implements ChannelDataListener {
    private Channel chnl = null;
    private HashSet listeners = new HashSet();
    private Object listenerLock = new Object();
    private Object requestLock = new Object();
    private int nextReq = 1;
    private HashMap requests = new HashMap();

    public IDClient(Channel chnl) {
        this.chnl = chnl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChannelData(ChannelDataEvent e) {
        if (e.getCommand() != 50) {
            LogSupport.error((Object)this, (String)"onChannelData", (String)("Unexpected message received by multimedia ID processor - " + e.getCommand()));
            return;
        }
        try {
            DataInputStream istr = e.read();
            int req = istr.readInt();
            int id = istr.readInt();
            String rsp = istr.readUTF();
            Integer key = new Integer(req);
            BigInteger secret = null;
            Object object = this.requestLock;
            synchronized (object) {
                DiffieHellman dh = (DiffieHellman)this.requests.remove(key);
                if (dh != null) {
                    dh.setResponse(rsp);
                    secret = dh.getSecret();
                }
            }
            if (secret != null) {
                this.fireIDAssigned(req, id, secret);
            }
            istr.close();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"onChannelData", (Throwable)ex, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestMediaID() {
        DiffieHellman dh;
        int req;
        Object object = this.requestLock;
        synchronized (object) {
            req = this.nextReq++;
            dh = new DiffieHellman();
            this.requests.put(new Integer(req), dh);
        }
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)49);
        try {
            DataOutputStream ostr = e.write();
            ostr.writeInt(req);
            ostr.writeUTF(dh.getChallenge());
            ostr.close();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"requestMediaID", (Throwable)ex, (boolean)true);
            e.dispose();
            return -1;
        }
        this.chnl.onChannelData(e);
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaIDListener(MediaIDListener lst) {
        Object object = this.listenerLock;
        synchronized (object) {
            HashSet nl = (HashSet)this.listeners.clone();
            nl.add(lst);
            this.listeners = nl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMediaIDListener(MediaIDListener lst) {
        Object object = this.listenerLock;
        synchronized (object) {
            HashSet nl = (HashSet)this.listeners.clone();
            nl.remove(lst);
            this.listeners = nl;
        }
    }

    private void fireIDAssigned(int req, int id, BigInteger auth) {
        MediaIDEvent e = new MediaIDEvent(this, req, id, auth);
        for (MediaIDListener lst : this.listeners) {
            try {
                lst.mediaIDAssigned(e);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireIDAssigned", (Throwable)t, (boolean)true);
            }
        }
    }
}

