/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml;

import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import java.io.IOException;
import java.io.OutputStream;

public class XmlWriter
extends DocWriter
implements DocListener {
    public static final byte NEWLINE = 10;
    public static final byte TAB = 9;
    public static final byte START = 60;
    public static final byte END = 62;
    public static final byte ENDTAG = 47;
    public static final byte[] BEGINCOMMENT = "<!--".getBytes();
    public static final byte[] ENDCOMMENT = "-->".getBytes();
    public static final byte[] XML = "XML".getBytes();
    public static final byte[] HEAD = "HEAD".getBytes();
    public static final byte[] BODY = "BODY".getBytes();
    public static final byte[] META = "META".getBytes();
    public static final String CONTENT = "CONTENT";
    public static final String TYPE = "TYPE";
    private int indent = 0;

    protected XmlWriter(Document document, OutputStream outputStream) {
        super(document, outputStream);
        System.err.println("Warning: class XmlWriter is not finished yet! The output will not be genuine XML!");
        this.document.addDocListener(this);
        try {
            this.writeBeginTag(XML);
            this.writeBeginTag(HEAD);
            this.document.addProducer();
            this.document.addCreationDate();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static XmlWriter getInstance(Document document, OutputStream outputStream) {
        return new XmlWriter(document, outputStream);
    }

    public boolean add(Element element) throws DocumentException {
        try {
            this.os.write(element.toString().getBytes());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void open() {
        super.open();
        try {
            this.writeEndTag(HEAD);
            this.writeBeginTag(BODY);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.writeEndTag(BODY);
            this.writeEndTag(XML);
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeBeginTag(byte[] byArray) throws IOException {
        this.tab();
        this.os.write(60);
        this.os.write(byArray);
        this.os.write(62);
        ++this.indent;
        this.newLine();
    }

    private void writeEndTag(byte[] byArray) throws IOException {
        --this.indent;
        this.tab();
        this.os.write(60);
        this.os.write(47);
        this.os.write(byArray);
        this.os.write(62);
        this.newLine();
    }

    private void newLine() throws IOException {
        this.os.write(10);
    }

    private void tab() throws IOException {
        int n = 0;
        while (n < this.indent) {
            this.os.write(9);
            ++n;
        }
    }
}

