/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class TrueType
extends BaseFont {
    protected HashMap tables;
    protected RandomAccessFile rf;
    protected String fileName;
    protected FontHeader head = new FontHeader();
    protected HorizontalHeader hhea = new HorizontalHeader();
    protected WindowsMetrics os_2 = new WindowsMetrics();
    protected int[] GlyphWidths;
    protected HashMap cmap10;
    protected HashMap cmap31;
    protected HashMap kerning;
    protected String fontName;
    protected double italicAngle;
    protected boolean isFixedPitch = false;

    protected TrueType() {
    }

    public TrueType(String string, String string2, boolean bl) throws DocumentException, IOException {
        this.normalizeEncoding(string2);
        this.embedded = bl;
        this.fileName = string;
        if (!this.fileName.toLowerCase().endsWith(".ttf")) {
            throw new DocumentException(this.fileName + " is not a TTF font file.");
        }
        this.process(this.fileName);
        try {
            this.createEncoding();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DocumentException(unsupportedEncodingException.getMessage());
        }
    }

    void fillTables() throws DocumentException, IOException {
        int[] nArray = (int[])this.tables.get("head");
        if (nArray == null) {
            throw new DocumentException("Table 'head' does not exist in " + this.fileName);
        }
        this.rf.seek(nArray[0] + 16);
        this.head.flags = this.rf.readUnsignedShort();
        this.head.unitsPerEm = this.rf.readUnsignedShort();
        this.rf.skipBytes(16);
        this.head.xMin = this.rf.readShort();
        this.head.yMin = this.rf.readShort();
        this.head.xMax = this.rf.readShort();
        this.head.yMax = this.rf.readShort();
        this.head.macStyle = this.rf.readUnsignedShort();
        nArray = (int[])this.tables.get("hhea");
        if (nArray == null) {
            throw new DocumentException("Table 'hhea' does not exist " + this.fileName);
        }
        this.rf.seek(nArray[0] + 4);
        this.hhea.Ascender = this.rf.readShort();
        this.hhea.Descender = this.rf.readShort();
        this.hhea.LineGap = this.rf.readShort();
        this.hhea.advanceWidthMax = this.rf.readUnsignedShort();
        this.hhea.minLeftSideBearing = this.rf.readShort();
        this.hhea.minRightSideBearing = this.rf.readShort();
        this.hhea.xMaxExtent = this.rf.readShort();
        this.hhea.caretSlopeRise = this.rf.readShort();
        this.hhea.caretSlopeRun = this.rf.readShort();
        this.rf.skipBytes(12);
        this.hhea.numberOfHMetrics = this.rf.readUnsignedShort();
        nArray = (int[])this.tables.get("OS/2");
        if (nArray == null) {
            throw new DocumentException("Table 'OS/2' does not exist in " + this.fileName);
        }
        this.rf.seek(nArray[0] + 2);
        this.os_2.xAvgCharWidth = this.rf.readShort();
        this.os_2.usWeightClass = this.rf.readUnsignedShort();
        this.os_2.usWidthClass = this.rf.readUnsignedShort();
        this.os_2.fsType = this.rf.readShort();
        this.os_2.ySubscriptXSize = this.rf.readShort();
        this.os_2.ySubscriptYSize = this.rf.readShort();
        this.os_2.ySubscriptXOffset = this.rf.readShort();
        this.os_2.ySubscriptYOffset = this.rf.readShort();
        this.os_2.ySuperscriptXSize = this.rf.readShort();
        this.os_2.ySuperscriptYSize = this.rf.readShort();
        this.os_2.ySuperscriptXOffset = this.rf.readShort();
        this.os_2.ySuperscriptYOffset = this.rf.readShort();
        this.os_2.yStrikeoutSize = this.rf.readShort();
        this.os_2.yStrikeoutPosition = this.rf.readShort();
        this.os_2.sFamilyClass = this.rf.readShort();
        this.rf.readFully(this.os_2.panose);
        this.rf.skipBytes(16);
        this.rf.readFully(this.os_2.achVendID);
        this.os_2.fsSelection = this.rf.readUnsignedShort();
        this.os_2.usFirstCharIndex = this.rf.readUnsignedShort();
        this.os_2.usLastCharIndex = this.rf.readUnsignedShort();
        this.os_2.sTypoAscender = this.rf.readShort();
        this.os_2.sTypoDescender = this.rf.readShort();
        this.os_2.sTypoLineGap = this.rf.readShort();
        this.os_2.usWinAscent = this.rf.readUnsignedShort();
        this.os_2.usWinDescent = this.rf.readUnsignedShort();
        nArray = (int[])this.tables.get("post");
        if (nArray == null) {
            this.italicAngle = -Math.atan2(this.hhea.caretSlopeRun, this.hhea.caretSlopeRise) * 180.0 / Math.PI;
            return;
        }
        this.rf.seek(nArray[0] + 4);
        short s = this.rf.readShort();
        int n = this.rf.readUnsignedShort();
        this.italicAngle = (double)s + (double)n / 16384.0;
        this.rf.skipBytes(4);
        this.isFixedPitch = this.rf.readInt() != 0;
    }

    String getBaseFont() throws DocumentException, IOException {
        int[] nArray = (int[])this.tables.get("name");
        if (nArray == null) {
            throw new DocumentException("Table 'name' does not exist in " + this.fileName);
        }
        this.rf.seek(nArray[0] + 2);
        int n = this.rf.readUnsignedShort();
        int n2 = this.rf.readUnsignedShort();
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.rf.readUnsignedShort();
            int n5 = this.rf.readUnsignedShort();
            int n6 = this.rf.readUnsignedShort();
            int n7 = this.rf.readUnsignedShort();
            int n8 = this.rf.readUnsignedShort();
            int n9 = this.rf.readUnsignedShort();
            if (n7 == 6) {
                this.rf.seek(nArray[0] + n2 + n9);
                if (n4 == 0 || n4 == 3) {
                    return this.readUnicodeString(n8);
                }
                return this.readStandardString(n8);
            }
            ++n3;
        }
        File file = new File(this.fileName);
        return file.getName().replace(' ', '-');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void process(String string) throws DocumentException, IOException {
        this.tables = new HashMap();
        try {
            this.fileName = string;
            this.rf = new RandomAccessFile(this.fileName, "r");
            this.rf.seek(4L);
            int n = this.rf.readUnsignedShort();
            this.rf.seek(12L);
            int n2 = 0;
            while (n2 < n) {
                String string2 = this.readStandardString(4);
                this.rf.skipBytes(4);
                int[] nArray = new int[]{this.rf.readInt(), this.rf.readInt()};
                this.tables.put(string2, nArray);
                ++n2;
            }
            this.fontName = this.getBaseFont();
            this.fillTables();
            this.readGlyphWidths();
            this.readCMaps();
            this.readKerning();
            Object var7_6 = null;
            if (this.rf == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (this.rf == null) throw throwable;
            this.rf.close();
            throw throwable;
        }
        this.rf.close();
    }

    String readStandardString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.rf.readFully(byArray);
        return new String(byArray);
    }

    String readUnicodeString(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        n /= 2;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.rf.readChar());
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void readGlyphWidths() throws DocumentException, IOException {
        int[] nArray = (int[])this.tables.get("hmtx");
        if (nArray == null) {
            throw new DocumentException("Table 'hmtx' does not exist in " + this.fileName);
        }
        this.rf.seek(nArray[0]);
        this.GlyphWidths = new int[this.hhea.numberOfHMetrics];
        int n = 0;
        while (n < this.hhea.numberOfHMetrics) {
            this.GlyphWidths[n] = this.rf.readUnsignedShort() * 1000 / this.head.unitsPerEm;
            this.rf.readUnsignedShort();
            ++n;
        }
    }

    public int getGlyphWidth(int n) {
        if (n >= this.GlyphWidths.length) {
            n = this.GlyphWidths.length - 1;
        }
        return this.GlyphWidths[n];
    }

    void readCMaps() throws DocumentException, IOException {
        int n;
        int[] nArray = (int[])this.tables.get("cmap");
        if (nArray == null) {
            throw new DocumentException("Table 'cmap' does not exist in " + this.fileName);
        }
        this.rf.seek(nArray[0]);
        this.rf.skipBytes(2);
        int n2 = this.rf.readUnsignedShort();
        this.fontSpecific = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            n = this.rf.readUnsignedShort();
            int n6 = this.rf.readUnsignedShort();
            int n7 = this.rf.readInt();
            if (n == 3 && n6 == 0) {
                this.fontSpecific = true;
            } else if (n == 3 && n6 == 1) {
                n4 = n7;
            }
            if (n == 1 && n6 == 0) {
                n3 = n7;
            }
            ++n5;
        }
        if (n3 > 0) {
            this.rf.seek(nArray[0] + n3);
            n = this.rf.readUnsignedShort();
            switch (n) {
                case 0: {
                    this.cmap10 = this.readFormat0();
                    break;
                }
                case 4: {
                    this.cmap10 = this.readFormat4();
                    break;
                }
                case 6: {
                    this.cmap10 = this.readFormat6();
                }
            }
        }
        if (n4 > 0) {
            this.rf.seek(nArray[0] + n4);
            n = this.rf.readUnsignedShort();
            if (n == 4) {
                this.cmap31 = this.readFormat4();
            }
        }
    }

    HashMap readFormat0() throws IOException {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        this.rf.skipBytes(4);
        int n = 0;
        while (n < 256) {
            int[] nArray;
            nArray = new int[]{this.rf.readUnsignedByte(), this.getGlyphWidth(nArray[0])};
            hashMap.put(new Integer(n), nArray);
            ++n;
        }
        return hashMap;
    }

    HashMap readFormat4() throws IOException {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        int n = this.rf.readUnsignedShort();
        this.rf.skipBytes(2);
        int n2 = this.rf.readUnsignedShort() / 2;
        this.rf.skipBytes(6);
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = this.rf.readUnsignedShort();
            ++n3;
        }
        this.rf.skipBytes(2);
        int[] nArray2 = new int[n2];
        int n4 = 0;
        while (n4 < n2) {
            nArray2[n4] = this.rf.readUnsignedShort();
            ++n4;
        }
        int[] nArray3 = new int[n2];
        int n5 = 0;
        while (n5 < n2) {
            nArray3[n5] = this.rf.readUnsignedShort();
            ++n5;
        }
        int[] nArray4 = new int[n2];
        int n6 = 0;
        while (n6 < n2) {
            nArray4[n6] = this.rf.readUnsignedShort();
            ++n6;
        }
        int[] nArray5 = new int[n / 2 - 8 - n2 * 4];
        int n7 = 0;
        while (n7 < nArray5.length) {
            nArray5[n7] = this.rf.readUnsignedShort();
            ++n7;
        }
        int n8 = 0;
        while (n8 < n2) {
            int n9 = nArray2[n8];
            while (n9 <= nArray[n8] && n9 != 65535) {
                int[] nArray6;
                int n10;
                if (nArray4[n8] == 0) {
                    n10 = n9 + nArray3[n8] & 0xFFFF;
                } else {
                    int n11 = n8 + nArray4[n8] / 2 - n2 + n9 - nArray2[n8];
                    n10 = nArray5[n11] + nArray3[n8] & 0xFFFF;
                }
                nArray6 = new int[]{n10, this.getGlyphWidth(nArray6[0])};
                hashMap.put(new Integer(n9), nArray6);
                ++n9;
            }
            ++n8;
        }
        return hashMap;
    }

    HashMap readFormat6() throws IOException {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        this.rf.skipBytes(4);
        int n = this.rf.readUnsignedShort();
        int n2 = this.rf.readUnsignedShort();
        int n3 = 0;
        while (n3 < n2) {
            int[] nArray;
            nArray = new int[]{this.rf.readUnsignedShort(), this.getGlyphWidth(nArray[0])};
            hashMap.put(new Integer(n3 + n), nArray);
            ++n3;
        }
        return hashMap;
    }

    void readKerning() throws IOException {
        int[] nArray = (int[])this.tables.get("kern");
        if (nArray == null) {
            return;
        }
        this.rf.seek(nArray[0] + 2);
        int n = this.rf.readUnsignedShort();
        this.kerning = new HashMap();
        int n2 = nArray[0] + 4;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            this.rf.seek(n2 += n3);
            this.rf.skipBytes(2);
            n3 = this.rf.readUnsignedShort();
            int n5 = this.rf.readUnsignedShort();
            if ((n5 & 0xFFF7) == 1) {
                int n6 = this.rf.readUnsignedShort();
                this.rf.skipBytes(6);
                int n7 = 0;
                while (n7 < n6) {
                    Integer n8 = new Integer(this.rf.readInt());
                    Integer n9 = new Integer(this.rf.readShort() * 1000 / this.head.unitsPerEm);
                    this.kerning.put(n8, n9);
                    ++n7;
                }
            }
            ++n4;
        }
    }

    public int getKerning(char c, char c2) {
        Integer n = (Integer)this.kerning.get(new Integer((c << 16) + c2));
        if (n == null) {
            return 0;
        }
        return n;
    }

    protected int getRawWidth(int n, String string) {
        HashMap hashMap = null;
        hashMap = string == null ? this.cmap10 : this.cmap31;
        if (hashMap == null) {
            return 0;
        }
        int[] nArray = (int[])hashMap.get(new Integer(n));
        if (nArray == null) {
            return 0;
        }
        return nArray[1];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PdfStream getFontStream() throws DocumentException {
        if (!this.embedded) {
            return null;
        }
        InputStream inputStream = null;
        try {
            try {
                File file = new File(this.fileName);
                int n = (int)file.length();
                byte[] byArray = new byte[n];
                inputStream = new FileInputStream(file);
                int[] nArray = new int[]{n};
                int n2 = 0;
                int n3 = n;
                while (true) {
                    if (n3 == 0) break;
                    int n4 = inputStream.read(byArray, n2, n3);
                    if (n4 < 0) {
                        throw new DocumentException("Premature end in " + file.getName());
                    }
                    n2 += n4;
                    n3 -= n4;
                }
                BaseFont.StreamFont streamFont = new BaseFont.StreamFont(byArray, nArray);
                Object var10_11 = null;
                if (inputStream == null) return streamFont;
                try {
                    inputStream.close();
                    return streamFont;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return streamFont;
            }
            catch (Exception exception) {
                throw new DocumentException(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (inputStream == null) throw throwable;
            try {}
            catch (Exception exception) {
                throw throwable;
            }
            inputStream.close();
            throw throwable;
        }
    }

    private PdfDictionary getFontDescriptor(PdfIndirectReference pdfIndirectReference) throws DocumentException {
        PdfDictionary pdfDictionary = new PdfDictionary(new PdfName("FontDescriptor"));
        pdfDictionary.put(new PdfName("Ascent"), new PdfNumber(this.hhea.Ascender * 1000 / this.head.unitsPerEm));
        pdfDictionary.put(new PdfName("CapHeight"), new PdfNumber(800));
        pdfDictionary.put(new PdfName("Descent"), new PdfNumber(this.hhea.Descender * 1000 / this.head.unitsPerEm));
        pdfDictionary.put(new PdfName("FontBBox"), new PdfRectangle(this.head.xMin * 1000 / this.head.unitsPerEm, this.head.yMin * 1000 / this.head.unitsPerEm, this.head.xMax * 1000 / this.head.unitsPerEm, this.head.yMax * 1000 / this.head.unitsPerEm));
        pdfDictionary.put(new PdfName("FontName"), new PdfName(this.fontName));
        pdfDictionary.put(new PdfName("ItalicAngle"), new PdfNumber(this.italicAngle));
        pdfDictionary.put(new PdfName("StemV"), new PdfNumber(80));
        if (pdfIndirectReference != null) {
            pdfDictionary.put(new PdfName("FontFile2"), pdfIndirectReference);
        }
        int n = 0;
        if (this.isFixedPitch) {
            n |= 1;
        }
        n |= this.fontSpecific ? 4 : 32;
        if ((this.head.macStyle & 2) != 0) {
            n |= 0x40;
        }
        if ((this.head.macStyle & 1) != 0) {
            n |= 0x40000;
        }
        pdfDictionary.put(new PdfName("Flags"), new PdfNumber(n));
        return pdfDictionary;
    }

    private PdfDictionary getFontType(PdfIndirectReference pdfIndirectReference) throws DocumentException {
        PdfObject pdfObject;
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONT);
        pdfDictionary.put(PdfName.SUBTYPE, new PdfName("TrueType"));
        pdfDictionary.put(PdfName.BASEFONT, new PdfName(this.fontName));
        int n = 0;
        int n2 = 0;
        while (n2 < 256) {
            if (!this.differences[n2].equals(BaseFont.notdef)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (!this.fontSpecific) {
            if (this.encoding.equals("Cp1252") || this.encoding.equals("MacRoman")) {
                pdfDictionary.put(PdfName.ENCODING, this.encoding.equals("Cp1252") ? PdfName.WIN_ANSI_ENCODING : PdfName.MAC_ROMAN_ENCODING);
            } else {
                pdfObject = new PdfDictionary(new PdfName("Encoding"));
                PdfArray pdfArray = new PdfArray();
                pdfArray.add(new PdfNumber(n));
                int n3 = n;
                while (n3 < 256) {
                    pdfArray.add(new PdfName(this.differences[n3]));
                    ++n3;
                }
                ((PdfDictionary)pdfObject).put(new PdfName("Differences"), pdfArray);
                pdfDictionary.put(PdfName.ENCODING, pdfObject);
            }
        }
        pdfDictionary.put(new PdfName("FirstChar"), new PdfNumber(n));
        pdfDictionary.put(new PdfName("LastChar"), new PdfNumber(255));
        pdfObject = new PdfArray();
        int n4 = n;
        while (n4 < 256) {
            ((PdfArray)pdfObject).add(new PdfNumber(this.widths[n4]));
            ++n4;
        }
        pdfDictionary.put(new PdfName("Widths"), pdfObject);
        if (pdfIndirectReference != null) {
            pdfDictionary.put(new PdfName("FontDescriptor"), pdfIndirectReference);
        }
        return pdfDictionary;
    }

    PdfObject getFontInfo(PdfIndirectReference pdfIndirectReference, int n) throws DocumentException {
        switch (n) {
            case 0: {
                return this.getFontStream();
            }
            case 1: {
                return this.getFontDescriptor(pdfIndirectReference);
            }
            case 2: {
                return this.getFontType(pdfIndirectReference);
            }
        }
        return null;
    }

    protected class FontHeader {
        int flags;
        int unitsPerEm;
        short xMin;
        short yMin;
        short xMax;
        short yMax;
        int macStyle;

        protected FontHeader() {
        }
    }

    protected class HorizontalHeader {
        short Ascender;
        short Descender;
        short LineGap;
        int advanceWidthMax;
        short minLeftSideBearing;
        short minRightSideBearing;
        short xMaxExtent;
        short caretSlopeRise;
        short caretSlopeRun;
        int numberOfHMetrics;

        protected HorizontalHeader() {
        }
    }

    protected class WindowsMetrics {
        short xAvgCharWidth;
        int usWeightClass;
        int usWidthClass;
        short fsType;
        short ySubscriptXSize;
        short ySubscriptYSize;
        short ySubscriptXOffset;
        short ySubscriptYOffset;
        short ySuperscriptXSize;
        short ySuperscriptYSize;
        short ySuperscriptXOffset;
        short ySuperscriptYOffset;
        short yStrikeoutSize;
        short yStrikeoutPosition;
        short sFamilyClass;
        byte[] panose = new byte[10];
        byte[] achVendID = new byte[4];
        int fsSelection;
        int usFirstCharIndex;
        int usLastCharIndex;
        short sTypoAscender;
        short sTypoDescender;
        short sTypoLineGap;
        int usWinAscent;
        int usWinDescent;

        protected WindowsMetrics() {
        }
    }
}

