/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Cell;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfCell;
import java.util.ArrayList;
import java.util.Iterator;

class PdfTable
extends Rectangle {
    private ArrayList headercells;
    private ArrayList cells;
    private int cellpadding;

    PdfTable(Table table, int n, int n2, int n3) {
        super(n, n3, n2, n3);
        PdfCell pdfCell;
        int n4;
        this.setBorder(table.border());
        this.setBorderWidth(table.borderWidth());
        this.setBorderColor(table.borderColor());
        this.setBackgroundColor(table.backgroundColor());
        this.setGrayFill(table.grayFill());
        this.cellpadding = table.cellpadding();
        int[] nArray = table.getWidths(n, n2 - n);
        this.setLeft(nArray[0]);
        this.setRight(nArray[nArray.length - 1]);
        int n5 = 0;
        int n6 = table.firstDataRow();
        this.headercells = new ArrayList();
        this.cells = new ArrayList();
        int n7 = table.size() + 1;
        int[] nArray2 = new int[n7];
        int n8 = 0;
        while (n8 < n7) {
            nArray2[n8] = n3 - this.cellpadding;
            ++n8;
        }
        Iterator iterator = table.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            if (!row.isEmpty()) {
                n4 = 0;
                while (n4 < row.columns()) {
                    Cell cell = row.getCell(n4);
                    if (cell != null) {
                        block12: {
                            pdfCell = new PdfCell(cell, n5, nArray[n4], nArray[n4 + cell.colspan()], nArray2[n5], table.cellspacing(), this.cellpadding);
                            try {
                                if (nArray2[n5] - pdfCell.height() - this.cellpadding < nArray2[n5 + pdfCell.rowspan()]) {
                                    nArray2[n5 + pdfCell.rowspan()] = nArray2[n5] - pdfCell.height() - this.cellpadding;
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                if (nArray2[n5] - pdfCell.height() >= nArray2[nArray2.length - 1]) break block12;
                                nArray2[nArray2.length - 1] = nArray2[n5] - pdfCell.height();
                            }
                        }
                        if (n5 < n6) {
                            pdfCell.setHeader();
                            this.headercells.add(pdfCell);
                        }
                        this.cells.add(pdfCell);
                    }
                    ++n4;
                }
            }
            ++n5;
        }
        n4 = this.cells.size();
        int n9 = 0;
        while (n9 < n4) {
            pdfCell = (PdfCell)this.cells.get(n9);
            try {
                pdfCell.setBottom(nArray2[pdfCell.rownumber() + pdfCell.rowspan()]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                pdfCell.setBottom(nArray2[nArray2.length - 1]);
            }
            ++n9;
        }
        this.setBottom(nArray2[nArray2.length - 1] - this.cellpadding);
    }

    ArrayList getHeaderCells() {
        return this.headercells;
    }

    boolean hasHeader() {
        return this.headercells.size() > 0;
    }

    ArrayList getCells() {
        return this.cells;
    }

    int cellpadding() {
        return this.cellpadding;
    }
}

