/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;

class PdfRectangle
extends PdfArray {
    private float llx = 0.0f;
    private float lly = 0.0f;
    private float urx = 0.0f;
    private float ury = 0.0f;

    PdfRectangle(float f, float f2, float f3, float f4) {
        this.llx = f;
        this.lly = f2;
        this.urx = f3;
        this.ury = f4;
        super.add(new PdfNumber(f));
        super.add(new PdfNumber(f2));
        super.add(new PdfNumber(f3));
        super.add(new PdfNumber(f4));
    }

    PdfRectangle(float f, float f2) {
        this(0.0f, 0.0f, f, f2);
    }

    PdfRectangle(Rectangle rectangle) {
        this(rectangle.left(), rectangle.bottom(), rectangle.right(), rectangle.top());
    }

    final boolean add(PdfObject pdfObject) {
        return false;
    }

    final float left() {
        return this.llx;
    }

    final float right() {
        return this.urx;
    }

    final float top() {
        return this.ury;
    }

    final float bottom() {
        return this.lly;
    }

    final float left(int n) {
        return this.llx + (float)n;
    }

    final float right(int n) {
        return this.urx - (float)n;
    }

    final float top(int n) {
        return this.ury - (float)n;
    }

    final float bottom(int n) {
        return this.lly + (float)n;
    }

    final float width() {
        return this.urx - this.llx;
    }

    final float height() {
        return this.ury - this.lly;
    }

    final PdfRectangle rotate() {
        return new PdfRectangle(this.lly, this.llx, this.ury, this.urx);
    }
}

