/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.PdfObject;

public class PdfName
extends PdfObject
implements Comparable {
    public static final PdfName A = new PdfName("/A", 0);
    public static final PdfName AA = new PdfName("/AA", 0);
    public static final PdfName ACTION = new PdfName("/Action", 0);
    public static final PdfName ANNOT = new PdfName("/Annot", 0);
    public static final PdfName ANNOTS = new PdfName("/Annots", 0);
    public static final PdfName ASCII85DECODE = new PdfName("/ASCII85Decode", 0);
    public static final PdfName ASCIIHEXDECODE = new PdfName("/ASCIIHexDecode", 0);
    public static final PdfName AUTHOR = new PdfName("/Author", 0);
    public static final PdfName B = new PdfName("/B", 0);
    public static final PdfName BASEFONT = new PdfName("/BaseFont", 0);
    public static final PdfName BBOX = new PdfName("/BBox", 0);
    public static final PdfName BITSPERCOMPONENT = new PdfName("/BitsPerComponent", 0);
    public static final PdfName BORDER = new PdfName("/Border", 0);
    public static final PdfName BS = new PdfName("/BS", 0);
    public static final PdfName C = new PdfName("/C", 0);
    public static final PdfName CATALOG = new PdfName("/Catalog", 0);
    public static final PdfName CCITTFAXDECODE = new PdfName("/CCITTFaxDecode", 0);
    public static final PdfName COLORS = new PdfName("/Colors", 0);
    public static final PdfName COLORSPACE = new PdfName("/ColorSpace", 0);
    public static final PdfName COLUMNS = new PdfName("/Columns", 0);
    public static final PdfName CONTENT = new PdfName("/Content", 0);
    public static final PdfName CONTENTS = new PdfName("/Contents", 0);
    public static final PdfName COUNT = new PdfName("/Count", 0);
    public static final PdfName COURIER = new PdfName("/Courier", 0);
    public static final PdfName COURIER_BOLD = new PdfName("/Courier-Bold", 0);
    public static final PdfName COURIER_OBLIQUE = new PdfName("/Courier-Oblique", 0);
    public static final PdfName COURIER_BOLDOBLIQUE = new PdfName("/Courier-BoldOblique", 0);
    public static final PdfName CREATIONDATE = new PdfName("/CreationDate", 0);
    public static final PdfName CREATOR = new PdfName("/Creator", 0);
    public static final PdfName CROPBOX = new PdfName("/CropBox", 0);
    public static final PdfName DCTDECODE = new PdfName("/DCTDecode", 0);
    public static final PdfName DECODEPARMS = new PdfName("/DecodeParms", 0);
    public static final PdfName DEST = new PdfName("/Dest", 0);
    public static final PdfName DESTS = new PdfName("/Dests", 0);
    public static final PdfName DEVICEGRAY = new PdfName("/DeviceGray", 0);
    public static final PdfName DEVICERGB = new PdfName("/DeviceRGB", 0);
    public static final PdfName DEVICECMYK = new PdfName("/DeviceCMYK", 0);
    public static final PdfName DUR = new PdfName("/Dur", 0);
    public static final PdfName EARLYCHANGE = new PdfName("/EarlyChange", 0);
    public static final PdfName ENCODING = new PdfName("/Encoding", 0);
    public static final PdfName EXTGSTATE = new PdfName("/ExtGState", 0);
    public static final PdfName F = new PdfName("/F", 0);
    public static final PdfName FDECODEPARMS = new PdfName("/FDecodeParms", 0);
    public static final PdfName FFILTER = new PdfName("/FFilter", 0);
    public static final PdfName FILTER = new PdfName("/Filter", 0);
    public static final PdfName FIRST = new PdfName("/First", 0);
    public static final PdfName FIRSTCHAR = new PdfName("/FirstChar", 0);
    public static final PdfName FIT = new PdfName("/Fit", 0);
    public static final PdfName FITH = new PdfName("/FitH", 0);
    public static final PdfName FITV = new PdfName("/FitV", 0);
    public static final PdfName FITR = new PdfName("/FitR", 0);
    public static final PdfName FITB = new PdfName("/FitB", 0);
    public static final PdfName FITBH = new PdfName("/FitBH", 0);
    public static final PdfName FITBV = new PdfName("/FitBV", 0);
    public static final PdfName FLATEDECODE = new PdfName("/FlateDecode", 0);
    public static final PdfName FONT = new PdfName("/Font", 0);
    public static final PdfName FONTDESCRIPTOR = new PdfName("/FontDescriptor", 0);
    public static final PdfName FORM = new PdfName("/Form", 0);
    public static final PdfName FORMTYPE = new PdfName("/FormType", 0);
    public static final PdfName FULLSCREEN = new PdfName("/FullScreen", 0);
    public static final PdfName HEIGHT = new PdfName("/Height", 0);
    public static final PdfName HELVETICA = new PdfName("/Helvetica", 0);
    public static final PdfName HELVETICA_BOLD = new PdfName("/Helvetica-Bold", 0);
    public static final PdfName HELVETICA_OBLIQUE = new PdfName("/Helvetica-Oblique", 0);
    public static final PdfName HELVETICA_BOLDOBLIQUE = new PdfName("/Helvetica-BoldOblique", 0);
    public static final PdfName HID = new PdfName("/Hid", 0);
    public static final PdfName ID = new PdfName("/ID", 0);
    public static final PdfName IMAGE = new PdfName("/Image", 0);
    public static final PdfName IMAGEB = new PdfName("/ImageB", 0);
    public static final PdfName IMAGEC = new PdfName("/ImageC", 0);
    public static final PdfName IMAGEI = new PdfName("/ImageI", 0);
    public static final PdfName INDEXED = new PdfName("/Indexed", 0);
    public static final PdfName INFO = new PdfName("/Info", 0);
    public static final PdfName KEYWORDS = new PdfName("/Keywords", 0);
    public static final PdfName KIDS = new PdfName("/Kids", 0);
    public static final PdfName LAST = new PdfName("/Last", 0);
    public static final PdfName LASTCHAR = new PdfName("/LastChar", 0);
    public static final PdfName LENGTH = new PdfName("/Length", 0);
    public static final PdfName LINK = new PdfName("/Link", 0);
    public static final PdfName LZWDECODE = new PdfName("/LZWDecode", 0);
    public static final PdfName MATRIX = new PdfName("/Matrix", 0);
    public static final PdfName MAC_EXPERT_ENCODING = new PdfName("/MacExpertEncoding", 0);
    public static final PdfName MAC_ROMAN_ENCODING = new PdfName("/MacRomanEncoding", 0);
    public static final PdfName MEDIABOX = new PdfName("/MediaBox", 0);
    public static final PdfName MODDATE = new PdfName("/ModDate", 0);
    public static final PdfName NAME = new PdfName("/Name", 0);
    public static final PdfName NAMES = new PdfName("/Names", 0);
    public static final PdfName NEXT = new PdfName("/Next", 0);
    public static final PdfName OPENACTION = new PdfName("/OpenAction", 0);
    public static final PdfName OUTLINES = new PdfName("/Outlines", 0);
    public static final PdfName PAGE = new PdfName("/Page", 0);
    public static final PdfName PAGEMODE = new PdfName("/PageMode", 0);
    public static final PdfName PAGES = new PdfName("/Pages", 0);
    public static final PdfName PARENT = new PdfName("/Parent", 0);
    public static final PdfName PATTERN = new PdfName("/Pattern", 0);
    public static final PdfName PDF = new PdfName("/PDF", 0);
    public static final PdfName PREDICTOR = new PdfName("/Predictor", 0);
    public static final PdfName PREV = new PdfName("/Prev", 0);
    public static final PdfName PROCSET = new PdfName("/ProcSet", 0);
    public static final PdfName PRODUCER = new PdfName("/Producer", 0);
    public static final PdfName PROPERTIES = new PdfName("/Properties", 0);
    public static final PdfName RECT = new PdfName("/Rect", 0);
    public static final PdfName RESOURCES = new PdfName("/Resources", 0);
    public static final PdfName ROOT = new PdfName("/Root", 0);
    public static final PdfName ROTATE = new PdfName("/Rotate", 0);
    public static final PdfName RUNLENGTHDECODE = new PdfName("/RunLengthDecode", 0);
    public static final PdfName S = new PdfName("/S", 0);
    public static final PdfName SIZE = new PdfName("/Size", 0);
    public static final PdfName SUBJECT = new PdfName("/Subject", 0);
    public static final PdfName SUBTYPE = new PdfName("/Subtype", 0);
    public static final PdfName SYMBOL = new PdfName("/Symbol", 0);
    public static final PdfName T = new PdfName("/T", 0);
    public static final PdfName TEXT = new PdfName("/Text", 0);
    public static final PdfName THUMB = new PdfName("/Thumb", 0);
    public static final PdfName THREADS = new PdfName("/Threads", 0);
    public static final PdfName TIMES_ROMAN = new PdfName("/Times-Roman", 0);
    public static final PdfName TIMES_BOLD = new PdfName("/Times-Bold", 0);
    public static final PdfName TIMES_ITALIC = new PdfName("/Times-Italic", 0);
    public static final PdfName TIMES_BOLDITALIC = new PdfName("/Times-BoldItalic", 0);
    public static final PdfName TITLE = new PdfName("/Title", 0);
    public static final PdfName TRANS = new PdfName("/Trans", 0);
    public static final PdfName TYPE = new PdfName("/Type", 0);
    public static final PdfName TYPE1 = new PdfName("/Type1", 0);
    public static final PdfName U = new PdfName("/U", 0);
    public static final PdfName URI = new PdfName("/URI", 0);
    public static final PdfName USENONE = new PdfName("/UseNone", 0);
    public static final PdfName USEOUTLINES = new PdfName("/UseOutlines", 0);
    public static final PdfName USETHUMBS = new PdfName("/UseThumbs", 0);
    public static final PdfName VIEWERPREFERENCES = new PdfName("/VIEWERPREFERENCES", 0);
    public static final PdfName W = new PdfName("/W", 0);
    public static final PdfName WIDTH = new PdfName("/Width", 0);
    public static final PdfName WIDTHS = new PdfName("/Widths", 0);
    public static final PdfName WIN_ANSI_ENCODING = new PdfName("/WinAnsiEncoding", 0);
    public static final PdfName XOBJECT = new PdfName("/XObject", 0);
    public static final PdfName XYZ = new PdfName("/XYZ", 0);
    public static final PdfName ZAPFDINGBATS = new PdfName("/ZapfDingbats", 0);

    PdfName(String string) throws BadPdfFormatException {
        super(4, string);
        if (this.bytes.length < 1 || this.bytes.length > 127) {
            throw new BadPdfFormatException("The name is too long (" + this.bytes.length + " characters).");
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) < ' ' || string.charAt(n2) > '\u00ff') {
                throw new BadPdfFormatException("Illegal character on position " + n2 + ".");
            }
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer("/");
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            switch (c) {
                case ' ': 
                case '#': 
                case '%': 
                case '(': 
                case ')': 
                case '/': 
                case '<': 
                case '>': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    stringBuffer.append('#');
                    stringBuffer.append(Integer.toString(c, 16));
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n3;
        }
        this.setContent(stringBuffer.toString());
    }

    private PdfName(String string, int n) {
        super(4, string);
    }

    public final String toString() {
        return new String(this.bytes);
    }

    public final int compareTo(Object object) throws ClassCastException {
        PdfName pdfName = (PdfName)object;
        return this.toString().compareTo(pdfName.toString());
    }
}

