/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ListItem;
import com.lowagie.text.pdf.PdfChunk;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfLine {
    protected ArrayList line = new ArrayList();
    protected int left;
    protected int width;
    protected int alignment;
    protected float height;
    protected PdfChunk listSymbol = null;
    protected int symbolIndent;

    PdfLine(int n, int n2, int n3, float f) {
        this.left = n;
        this.width = n2 - n;
        this.alignment = n3;
        this.height = f;
    }

    final PdfChunk add(PdfChunk pdfChunk) {
        if (pdfChunk == null || pdfChunk.toString().equals("")) {
            return null;
        }
        PdfChunk pdfChunk2 = pdfChunk.split(this.width);
        if (pdfChunk.length() > 0) {
            this.width = (int)((double)this.width - pdfChunk.width());
            this.line.add(pdfChunk);
        } else if (this.line.size() < 1) {
            pdfChunk = pdfChunk2;
            pdfChunk2 = pdfChunk.truncate(this.width);
            this.width = (int)((double)this.width - pdfChunk.width());
            if (pdfChunk.length() > 0) {
                this.line.add(pdfChunk);
                return pdfChunk2;
            }
            this.line.add(pdfChunk2);
            return null;
        }
        return pdfChunk2;
    }

    public int size() {
        return this.line.size();
    }

    public Iterator iterator() {
        return ((AbstractList)this.line).iterator();
    }

    final float height() {
        return this.height;
    }

    final int indentLeft() {
        switch (this.alignment) {
            case 2: {
                return this.left + this.width;
            }
            case 1: {
                return this.left + this.width / 2;
            }
        }
        return this.left;
    }

    public boolean hasToBeJustified() {
        return this.alignment == 3 && this.width != 0;
    }

    public void resetAlignment() {
        if (this.alignment == 3) {
            this.alignment = 0;
        }
    }

    final int widthLeft() {
        return this.width;
    }

    final int numberOfSpaces() {
        String string = this.toString();
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (string.charAt(n3) == ' ') {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public void setListItem(ListItem listItem) {
        this.listSymbol = new PdfChunk(listItem.listSymbol());
        this.symbolIndent = listItem.indentationLeft();
    }

    public PdfChunk listSymbol() {
        return this.listSymbol;
    }

    public int listIndent() {
        return this.symbolIndent;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((AbstractList)this.line).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((PdfChunk)iterator.next()).toString());
        }
        return stringBuffer.toString();
    }
}

