/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.font.Courier;
import com.lowagie.text.pdf.font.CourierBold;
import com.lowagie.text.pdf.font.CourierBoldOblique;
import com.lowagie.text.pdf.font.CourierOblique;
import com.lowagie.text.pdf.font.Helvetica;
import com.lowagie.text.pdf.font.HelveticaBold;
import com.lowagie.text.pdf.font.HelveticaBoldOblique;
import com.lowagie.text.pdf.font.HelveticaOblique;
import com.lowagie.text.pdf.font.Symbol;
import com.lowagie.text.pdf.font.TimesBold;
import com.lowagie.text.pdf.font.TimesBoldItalic;
import com.lowagie.text.pdf.font.TimesItalic;
import com.lowagie.text.pdf.font.TimesRoman;
import com.lowagie.text.pdf.font.ZapfDingbats;

public abstract class PdfFontMetrics {
    public static final int COURIER = 0;
    public static final int COURIER_BOLD = 1;
    public static final int COURIER_OBLIQUE = 2;
    public static final int COURIER_BOLDOBLIQUE = 3;
    public static final int HELVETICA = 4;
    public static final int HELVETICA_BOLD = 5;
    public static final int HELVETICA_OBLIQUE = 6;
    public static final int HELVETICA_BOLDOBLIQUE = 7;
    public static final int SYMBOL = 8;
    public static final int TIMES_ROMAN = 9;
    public static final int TIMES_BOLD = 10;
    public static final int TIMES_ITALIC = 11;
    public static final int TIMES_BOLDITALIC = 12;
    public static final int ZAPFDINGBATS = 13;
    public static final int SIZE_8 = 8;
    public static final int SIZE_10 = 10;
    public static final int SIZE_12 = 12;
    public static final int SIZE_14 = 14;
    public static final int SIZE_18 = 18;
    public static final int SIZE_24 = 24;
    public static final int STANDARD = 0;
    public static final int MAC_ROMAN = 1;
    public static final int MAC_EXPERT = 2;
    public static final int WIN_ANSI = 3;
    private static PdfObject[] encodings = new PdfObject[4];
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLDITALIC = 3;
    public static final char SPACE = ' ';
    public static final char ZERO = '0';
    public static final char ELLIPSIS_STANDARD = '\u00bc';
    public static final char ELLIPSIS_MAC_ROMAN = '\u00c9';
    public static final char ELLIPSIS_WIN_ANSI = '\u0085';
    private int encoding;
    private int size;
    private int[] width;
    private int[][] kerning = null;

    protected PdfFontMetrics(int n, int n2) {
        this.encoding = PdfFontMetrics.checkEncoding(n);
        this.size = PdfFontMetrics.checkFontsize(n2);
    }

    static final PdfFontMetrics getFont(int n, int n2, int n3) {
        switch (n) {
            case 0: {
                return new Courier(n2, n3);
            }
            case 1: {
                return new CourierBold(n2, n3);
            }
            case 2: {
                return new CourierOblique(n2, n3);
            }
            case 3: {
                return new CourierBoldOblique(n2, n3);
            }
            case 4: {
                return new Helvetica(n2, n3);
            }
            case 5: {
                return new HelveticaBold(n2, n3);
            }
            case 6: {
                return new HelveticaOblique(n2, n3);
            }
            case 7: {
                return new HelveticaBoldOblique(n2, n3);
            }
            case 8: {
                return new Symbol(n2, n3);
            }
            case 9: {
                return new TimesRoman(n2, n3);
            }
            case 10: {
                return new TimesBold(n2, n3);
            }
            case 11: {
                return new TimesItalic(n2, n3);
            }
            case 12: {
                return new TimesBoldItalic(n2, n3);
            }
            case 13: {
                return new ZapfDingbats(n2, n3);
            }
        }
        return new Courier(n2, n3);
    }

    protected final void setWidth(int[] nArray) {
        this.width = nArray;
    }

    protected final void setKerning(int[][] nArray) {
        this.kerning = nArray;
    }

    public abstract PdfName name();

    final PdfObject encoding() {
        return encodings[this.encoding];
    }

    final int size() {
        return this.size;
    }

    private final int width(char c) {
        return this.width[c & 0xFF];
    }

    final double widthTextSpace(char c) {
        return 0.001 * ((double)this.width(c) * (double)this.size);
    }

    final double widthTextSpace() {
        return this.widthTextSpace(' ');
    }

    public int kerning(char c, char c2) {
        if (this.kerning == null) {
            return 0;
        }
        int n = c & 0xFF;
        int n2 = c2 & 0xFF;
        int[] nArray = this.kerning[n];
        if (nArray == null) {
            return 0;
        }
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] == n2) {
                return nArray[n3 + 1];
            }
            if (nArray[n3] > n2) {
                return 0;
            }
            n3 += 2;
        }
        return 0;
    }

    public abstract int getStyle(int var1);

    char ellipsis() {
        switch (this.encoding) {
            case 1: {
                return '\u00c9';
            }
            case 3: {
                return '\u0085';
            }
        }
        return '\u00bc';
    }

    static boolean isSplitCharacter(char c) {
        if (c <= ' ') {
            return true;
        }
        switch (c) {
            case '\t': 
            case ' ': 
            case '-': {
                return true;
            }
        }
        return false;
    }

    static String trim(String string) {
        while (string.endsWith(" ") || string.endsWith("\t")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    static final int checkFonttype(int n) {
        if (n < 0 || n > 13) {
            return 0;
        }
        return n;
    }

    static final int checkFontsize(int n) {
        if (n < 0 || n > 1000) {
            return 12;
        }
        return n;
    }

    static final int checkEncoding(int n) {
        if (n < 0 || n > 3) {
            return 3;
        }
        return n;
    }

    static final PdfObject getEncoding(int n) {
        return encodings[PdfFontMetrics.checkEncoding(n)];
    }

    static {
        PdfFontMetrics.encodings[0] = PdfNull.PDFNULL;
        PdfFontMetrics.encodings[1] = PdfName.MAC_ROMAN_ENCODING;
        PdfFontMetrics.encodings[2] = PdfName.MAC_EXPERT_ENCODING;
        PdfFontMetrics.encodings[3] = PdfName.WIN_ANSI_ENCODING;
    }
}

