/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfNumber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class PdfDashPattern
extends PdfArray {
    private int dash = -1;
    private int gap = -1;
    private int phase;

    PdfDashPattern() {
    }

    PdfDashPattern(int n) {
        super(new PdfNumber(n));
        this.dash = n;
    }

    PdfDashPattern(int n, int n2) {
        super(new PdfNumber(n));
        this.add(new PdfNumber(n2));
        this.dash = n;
        this.gap = n2;
    }

    PdfDashPattern(int n, int n2, int n3) {
        super(new PdfNumber(n));
        this.add(new PdfNumber(n2));
        this.dash = n;
        this.gap = n2;
        this.phase = n3;
    }

    final byte[] toPdf() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write("[".getBytes());
            if (this.dash >= 0) {
                byteArrayOutputStream.write(new PdfNumber(this.dash).toPdf());
                if (this.gap >= 0) {
                    byteArrayOutputStream.write(" ".getBytes());
                    byteArrayOutputStream.write(new PdfNumber(this.gap).toPdf());
                }
            }
            byteArrayOutputStream.write("]".getBytes());
            if (this.phase >= 0) {
                byteArrayOutputStream.write(" ".getBytes());
                byteArrayOutputStream.write(new PdfNumber(this.phase).toPdf());
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }
}

