/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import java.awt.Color;

public class PdfContent {
    protected StringBuffer content = new StringBuffer("");

    protected PdfContent() {
    }

    public String toString() {
        return this.content.toString();
    }

    String toPdf() {
        return this.toString();
    }

    public final void add(PdfContent pdfContent) {
        this.content.append(pdfContent.toString());
    }

    public final void setFlatness(int n) {
        if (n > -1 && n < 101) {
            this.content.append(n).append(" i\n");
        }
    }

    public final void setLineCap(int n) {
        if (n == 1 || n == 2 || n == 3) {
            this.content.append(n).append(" J\n");
        }
    }

    public final void setLineDash(int n) {
        PdfArray pdfArray = new PdfArray();
        this.content.append(pdfArray.toPdf()).append(" ").append(n).append(" d\n");
    }

    public final void setLineDash(int n, int n2) {
        PdfArray pdfArray = new PdfArray();
        pdfArray.add(new PdfNumber(n));
        this.content.append(pdfArray.toPdf()).append(" ").append(n2).append(" d\n");
    }

    public final void setLineDash(int n, int n2, int n3) {
        PdfArray pdfArray = new PdfArray();
        pdfArray.add(new PdfNumber(n));
        pdfArray.add(new PdfNumber(n2));
        this.content.append(pdfArray.toPdf()).append(" ").append(n3).append(" d\n");
    }

    public final void setLineJoin(int n) {
        if (n == 1 || n == 2 || n == 3) {
            this.content.append(n).append(" j\n");
        }
    }

    public final void setLineWidth(double d) {
        this.content.append(d).append(" w\n");
    }

    public final void setMiterLimit(double d) {
        if (d > 1.0) {
            this.content.append(d).append(" M\n");
        }
    }

    public final void setGrayFill(double d) {
        this.content.append(d);
        this.content.append(" g\n");
    }

    public final void resetGrayFill() {
        this.content.append("0 g\n");
    }

    public final void setGrayStroke(double d) {
        this.content.append(d);
        this.content.append(" G\n");
    }

    public final void resetGrayStroke() {
        this.content.append("0 G\n");
    }

    public final void setRGBColorFill(int n, int n2, int n3) {
        this.content.append((double)(n & 0xFF) / 255.0);
        this.content.append(' ');
        this.content.append((double)(n2 & 0xFF) / 255.0);
        this.content.append(' ');
        this.content.append((double)(n3 & 0xFF) / 255.0);
        this.content.append(" rg\n");
    }

    public final void resetRGBColorFill() {
        this.content.append("0 0 0 rg\n");
    }

    public final void setRGBColorStroke(int n, int n2, int n3) {
        this.content.append((double)(n & 0xFF) / 255.0);
        this.content.append(' ');
        this.content.append((double)(n2 & 0xFF) / 255.0);
        this.content.append(' ');
        this.content.append((double)(n3 & 0xFF) / 255.0);
        this.content.append(" RG\n");
    }

    public final void resetRGBColorStroke() {
        this.content.append("0 0 0 RG\n");
    }

    public final void setCMYKColorFill(int n, int n2, int n3, int n4) {
        this.content.append((double)(n & 0xFF) / 255.0);
        this.content.append(' ');
        this.content.append((double)(n2 & 0xFF) / 255.0);
        this.content.append(' ');
        this.content.append((double)(n3 & 0xFF) / 255.0);
        this.content.append(' ');
        this.content.append((double)(n4 & 0xFF) / 255.0);
        this.content.append(" k\n");
    }

    public final void resetCMYKColorFill() {
        this.content.append("0 0 0 1 k\n");
    }

    public final void setCMYKColorStroke(int n, int n2, int n3, int n4) {
        this.content.append((double)(n & 0xFF) / 255.0);
        this.content.append(' ');
        this.content.append((double)(n2 & 0xFF) / 255.0);
        this.content.append(' ');
        this.content.append((double)(n3 & 0xFF) / 255.0);
        this.content.append(' ');
        this.content.append((double)(n4 & 0xFF) / 255.0);
        this.content.append(" K\n");
    }

    public final void resetCMYKColorStroke() {
        this.content.append("0 0 0 1 K\n");
    }

    public final void moveTo(int n, int n2) {
        this.content.append(n).append(" ").append(n2).append(" m\n");
    }

    public final void lineTo(int n, int n2) {
        this.content.append(n).append(" ").append(n2).append(" l\n");
    }

    public final void moveTo(float f, float f2) {
        this.content.append(f).append(" ").append(f2).append(" m\n");
    }

    public final void lineTo(float f, float f2) {
        this.content.append(f).append(" ").append(f2).append(" l\n");
    }

    public final void curveTo(int n, int n2, int n3, int n4, int n5, int n6) {
        this.content.append(n).append(' ').append(n2).append(' ').append(n3).append(' ').append(n4).append(' ').append(n5).append(' ').append(n6).append(" c\n");
    }

    public final void curveTo(int n, int n2, int n3, int n4) {
        this.content.append(n).append(' ').append(n2).append(' ').append(n3).append(' ').append(n4).append(" v\n");
    }

    public final void curveFromTo(int n, int n2, int n3, int n4) {
        this.content.append(n).append(' ').append(n2).append(' ').append(n3).append(' ').append(n4).append(" y\n");
    }

    public final void rectangle(int n, int n2, int n3, int n4) {
        this.content.append(n).append(' ').append(n2).append(' ').append(n3).append(' ').append(n4).append(" re\n");
    }

    public final void rectangle(Rectangle rectangle) {
        Color color;
        int n = rectangle.left();
        int n2 = rectangle.top();
        int n3 = rectangle.right();
        int n4 = rectangle.bottom();
        Color color2 = rectangle.backgroundColor();
        if (color2 != null) {
            this.setRGBColorStroke(color2.getRed(), color2.getGreen(), color2.getBlue());
            this.setRGBColorFill(color2.getRed(), color2.getGreen(), color2.getBlue());
            this.rectangle(n, n2, n3 - n, n4 - n2);
            this.closePathFillStroke();
            this.resetRGBColorFill();
            this.resetRGBColorStroke();
        } else if (rectangle.grayFill() > 0.0) {
            this.setGrayStroke(rectangle.grayFill());
            this.setGrayFill(rectangle.grayFill());
            this.rectangle(n, n2, n3 - n, n4 - n2);
            this.closePathFillStroke();
            this.resetGrayFill();
            this.resetGrayStroke();
        }
        if (!rectangle.hasBorders()) {
            return;
        }
        if (rectangle.borderWidth() != -1.0) {
            this.setLineWidth(rectangle.borderWidth());
        }
        if ((color = rectangle.borderColor()) != null) {
            this.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
        }
        if (rectangle.hasBorder(15)) {
            this.rectangle(n, n2, n3 - n, n4 - n2);
        } else {
            if (rectangle.hasBorder(8)) {
                this.moveTo(n3, n2);
                this.lineTo(n3, n4);
            }
            if (rectangle.hasBorder(4)) {
                this.moveTo(n, n2);
                this.lineTo(n, n4);
            }
            if (rectangle.hasBorder(2)) {
                this.moveTo(n, n4);
                this.lineTo(n3, n4);
            }
            if (rectangle.hasBorder(1)) {
                this.moveTo(n, n2);
                this.lineTo(n3, n2);
            }
        }
        this.stroke();
        if (color != null) {
            this.resetRGBColorStroke();
        }
    }

    public final void closePath() {
        this.content.append("h\n");
    }

    public final void newPath() {
        this.content.append("n\n");
    }

    public final void stroke() {
        this.content.append("S\n");
    }

    public final void closePathStroke() {
        this.content.append("s\n");
    }

    public final void fill() {
        this.content.append("f\n");
    }

    public final void eoFill() {
        this.content.append("f*\n");
    }

    public final void fillStroke() {
        this.content.append("B\n");
    }

    public final void closePathFillStroke() {
        this.content.append("b\n");
    }

    public final void eoFillStroke() {
        this.content.append("B*\n");
    }

    public final void closePathEoFillStroke() {
        this.content.append("b*\n");
    }

    final void doImage(PdfName pdfName, double[] dArray, int n, int n2) {
        this.content.append("q ");
        this.content.append(this.format(dArray[0])).append(" ");
        this.content.append(this.format(dArray[1])).append(" ");
        this.content.append(this.format(dArray[2])).append(" ");
        this.content.append(this.format(dArray[3])).append(" ");
        this.content.append(this.format((double)n - dArray[4])).append(" ");
        this.content.append(this.format((double)n2 - dArray[5])).append(" cm ");
        this.content.append(pdfName.toString()).append(" Do Q\n");
    }

    private String format(double d) {
        d *= 10000.0;
        int n = (int)d;
        String string = String.valueOf(d = (double)n / 10000.0);
        if (string.endsWith(".0")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }
}

