/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfLine;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfCell
extends Rectangle {
    private ArrayList lines;
    private int leading;
    private int rownumber;
    private int rowspan;
    private int cellpadding;
    private int cellspacing;
    private boolean header = false;

    public PdfCell(Cell cell, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n4, n3, n4);
        this.setBorder(cell.border());
        this.setBorderWidth(cell.borderWidth());
        this.setBorderColor(cell.borderColor());
        this.setBackgroundColor(cell.backgroundColor());
        this.setGrayFill(cell.grayFill());
        this.lines = new ArrayList();
        this.leading = cell.leading();
        int n7 = cell.horizontalAlignment();
        n2 += n5 + n6;
        n3 -= n5 + n6;
        float f = this.leading + n5;
        float f2 = cell.rowspan();
        switch (cell.verticalAlignment()) {
            case 6: {
                f *= f2;
                break;
            }
            case 5: {
                f = (float)((double)f * ((double)f2 / 1.5));
                break;
            }
            default: {
                if (!(f2 < 2.0f)) break;
                f = (float)((double)f - (double)f / 2.5);
            }
        }
        PdfLine pdfLine = new PdfLine(n2, n3, n7, f);
        Iterator iterator = cell.getElements();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            switch (element.type()) {
                case 14: {
                    PdfChunk pdfChunk;
                    PdfChunk pdfChunk2;
                    Iterator iterator2;
                    if (pdfLine.size() > 0) {
                        pdfLine.resetAlignment();
                        this.lines.add(pdfLine);
                    }
                    Iterator iterator3 = ((AbstractList)((List)element).getItems()).iterator();
                    while (iterator3.hasNext()) {
                        ListItem listItem = (ListItem)iterator3.next();
                        pdfLine = new PdfLine(n2 + listItem.indentationLeft(), n3, n7, this.leading);
                        pdfLine.setListItem(listItem);
                        iterator2 = ((AbstractList)listItem.getChunks()).iterator();
                        while (iterator2.hasNext()) {
                            pdfChunk2 = new PdfChunk((Chunk)iterator2.next());
                            while ((pdfChunk = pdfLine.add(pdfChunk2)) != null) {
                                this.lines.add(pdfLine);
                                pdfLine = new PdfLine(n2 + listItem.indentationLeft(), n3, n7, this.leading);
                                pdfChunk2 = pdfChunk;
                            }
                            pdfLine.resetAlignment();
                            this.lines.add(pdfLine);
                            pdfLine = new PdfLine(n2 + listItem.indentationLeft(), n3, n7, this.leading);
                        }
                    }
                    pdfLine = new PdfLine(n2, n3, n7, this.leading);
                    break;
                }
                default: {
                    PdfChunk pdfChunk;
                    PdfChunk pdfChunk2;
                    Iterator iterator2 = ((AbstractList)element.getChunks()).iterator();
                    while (iterator2.hasNext()) {
                        pdfChunk2 = new PdfChunk((Chunk)iterator2.next());
                        while ((pdfChunk = pdfLine.add(pdfChunk2)) != null) {
                            this.lines.add(pdfLine);
                            pdfLine = new PdfLine(n2, n3, n7, this.leading);
                            pdfChunk2 = pdfChunk;
                        }
                    }
                    switch (element.type()) {
                        case 12: 
                        case 13: 
                        case 16: {
                            pdfLine.resetAlignment();
                            this.lines.add(pdfLine);
                            pdfLine = new PdfLine(n2, n3, n7, this.leading);
                        }
                    }
                }
            }
        }
        if (pdfLine.size() > 0) {
            this.lines.add(pdfLine);
        }
        if (this.lines.size() > 0) {
            ((PdfLine)this.lines.get(this.lines.size() - 1)).resetAlignment();
        }
        this.setBottom(n4 - this.leading * this.lines.size() - 5 * n5 / 2);
        this.cellpadding = n6;
        this.cellspacing = n5;
        this.rowspan = cell.rowspan();
        this.rownumber = n;
    }

    public int left() {
        return super.left(this.cellpadding);
    }

    public int right() {
        return super.right(this.cellpadding);
    }

    public int top() {
        return super.top(this.cellpadding);
    }

    public int bottom() {
        return super.bottom(this.cellpadding);
    }

    public ArrayList getLines(int n, int n2) {
        if (this.top() < n2) {
            return null;
        }
        float f = Math.min(this.top(), n);
        ArrayList<PdfLine> arrayList = new ArrayList<PdfLine>();
        int n3 = this.lines.size();
        int n4 = 0;
        while (n4 < n3) {
            PdfLine pdfLine = (PdfLine)this.lines.get(n4);
            float f2 = pdfLine.height();
            if ((f -= f2) > (float)n2) {
                arrayList.add(pdfLine);
                if (!this.header) {
                    this.lines.set(n4, new PdfLine(this.left(-this.cellpadding - this.cellspacing), this.right(-this.cellpadding - this.cellspacing), 0, this.leading));
                }
            }
            ++n4;
        }
        if (!this.header && n2 <= this.bottom()) {
            this.lines = new ArrayList();
        }
        return arrayList;
    }

    final void setHeader() {
        this.header = true;
    }

    final boolean mayBeRemoved() {
        return this.header || this.lines.size() < 1;
    }

    public int size() {
        return this.lines.size();
    }

    public int leading() {
        return this.leading;
    }

    public int rownumber() {
        return this.rownumber;
    }

    public int rowspan() {
        return this.rowspan;
    }

    public int cellspacing() {
        return this.cellspacing;
    }

    public int cellpadding() {
        return this.cellpadding;
    }
}

