/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

class PdfArray
extends PdfObject {
    protected ArrayList arrayList;

    PdfArray() {
        super(5);
        this.arrayList = new ArrayList();
    }

    PdfArray(PdfObject pdfObject) {
        super(5);
        this.arrayList = new ArrayList();
        this.arrayList.add(pdfObject);
    }

    PdfArray(PdfArray pdfArray) {
        super(5);
        this.arrayList = new ArrayList(pdfArray.getArrayList());
    }

    byte[] toPdf() {
        try {
            PdfObject pdfObject;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write("[".getBytes());
            Iterator iterator = ((AbstractList)this.arrayList).iterator();
            if (iterator.hasNext()) {
                pdfObject = (PdfObject)iterator.next();
                byteArrayOutputStream.write(pdfObject.toPdf());
            }
            while (iterator.hasNext()) {
                pdfObject = (PdfObject)iterator.next();
                byteArrayOutputStream.write(" ".getBytes());
                byteArrayOutputStream.write(pdfObject.toPdf());
            }
            byteArrayOutputStream.write("]".getBytes());
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    private final ArrayList getArrayList() {
        return this.arrayList;
    }

    public final int size() {
        return this.arrayList.size();
    }

    boolean add(PdfObject pdfObject) {
        return this.arrayList.add(pdfObject);
    }

    void addFirst(PdfObject pdfObject) {
        this.arrayList.add(0, pdfObject);
    }

    final boolean contains(PdfObject pdfObject) {
        return this.arrayList.contains(pdfObject);
    }

    final Object[] toArray() {
        return this.arrayList.toArray();
    }
}

