/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html;

import com.lowagie.text.Anchor;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Header;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Row;
import com.lowagie.text.Section;
import com.lowagie.text.Table;
import com.lowagie.text.html.HtmlAttributes;
import com.lowagie.text.html.HtmlEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.TreeMap;

public class HtmlWriter
extends DocWriter
implements DocListener {
    public static final byte NEWLINE = 10;
    public static final byte TAB = 9;
    public static final byte START = 60;
    public static final byte END = 62;
    public static final byte ENDTAG = 47;
    public static final byte[] BEGINCOMMENT = "<!--".getBytes();
    public static final byte[] ENDCOMMENT = "-->".getBytes();
    public static final byte[] A = "A".getBytes();
    public static final byte[] B = "B".getBytes();
    public static final byte[] BR = "BR".getBytes();
    public static final byte[] BODY = "BODY".getBytes();
    public static final byte[] FONT = "FONT".getBytes();
    public static final byte[] HEAD = "HEAD".getBytes();
    public static final byte[] HTML = "HTML".getBytes();
    public static final byte[] I = "I".getBytes();
    public static final byte[] IMG = "IMG".getBytes();
    public static final byte[] LI = "LI".getBytes();
    public static final byte[] LINK = "LINK".getBytes();
    public static final byte[] META = "META".getBytes();
    public static final byte[] NBSP = "&nbsp;".getBytes();
    public static final byte[] OL = "OL".getBytes();
    public static final byte[] PARAGRAPH = "P".getBytes();
    public static final byte[] S = "S".getBytes();
    public static final byte[] TABLE = "TABLE".getBytes();
    public static final byte[] TD = "TD".getBytes();
    public static final byte[] TH = "TH".getBytes();
    public static final byte[] TITLE = "TITLE".getBytes();
    public static final byte[] TR = "TR".getBytes();
    public static final byte[] U = "U".getBytes();
    public static final byte[] UL = "UL".getBytes();
    public static final String[] FONTS = new String[5];
    public static final String ALIGN = "ALIGN";
    public static final String ALT = "ALT";
    public static final String BGCOLOR = "BGCOLOR";
    public static final String BOTTOMMARGIN = "BOTTOMMARGIN";
    public static final String BORDER = "BORDER";
    public static final String BORDERCOLOR = "BORDERCOLOR";
    public static final String CELLPADDING = "CELLPADDING";
    public static final String CELLSPACING = "CELLSPACING";
    public static final String COLSPAN = "COLSPAN";
    public static final String CONTENT = "CONTENT";
    public static final String COLOR = "COLOR";
    public static final String CSS = "text/css";
    public static final String FACE = "FACE";
    public static final String HEIGHT = "HEIGHT";
    public static final String HREF = "HREF";
    public static final String LEFTMARGIN = "LEFTMARGIN";
    public static final String NAME = "NAME";
    public static final String NOWRAP = "NOWRAP";
    public static final String POINTSIZE = "POINT-SIZE";
    public static final String REL = "rel";
    public static final String RIGHTMARGIN = "RIGHTMARGIN";
    public static final String ROWSPAN = "ROWSPAN";
    public static final String SRC = "SRC";
    public static final String STYLESHEET = "STYLESHEET";
    public static final String TEXT = "TEXT";
    public static final String TOPMARGIN = "TOPMARGIN";
    public static final String TYPE = "TYPE";
    public static final String VALIGN = "VALIGN";
    public static final String WIDTH = "WIDTH";
    private int indent = 0;
    private Font font = new Font();
    private Font standardFont = new Font();
    private String imagepath = null;
    private static int pageN;
    private HeaderFooter header = null;
    private HeaderFooter footer = null;

    protected HtmlWriter(Document document, OutputStream outputStream) {
        super(document, outputStream);
        this.document.addDocListener(this);
        pageN = this.document.getPageNumber();
        try {
            this.writeBeginTag(HTML);
            this.writeBeginTag(HEAD);
            this.document.addProducer();
            this.document.addCreationDate();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static HtmlWriter getInstance(Document document, OutputStream outputStream) {
        return new HtmlWriter(document, outputStream);
    }

    public boolean newPage() throws DocumentException {
        if (this.pause || !this.open) {
            return false;
        }
        try {
            this.os.write("<HR>\n".getBytes());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean add(Element element) throws DocumentException {
        Object object;
        if (this.pause) {
            return false;
        }
        Font font = null;
        if (element.type() == 10 && ((Chunk)(object = (Chunk)element)).font() != null && ((Chunk)object).font().compareTo(this.standardFont) != 0) {
            font = ((Chunk)object).font().difference(this.font);
            try {
                this.setFont(font);
            }
            catch (IOException iOException) {
                throw new DocumentException(iOException.getMessage());
            }
        }
        object = new HtmlAttributes();
        try {
            switch (element.type()) {
                case 0: {
                    Header header = (Header)element;
                    if (!STYLESHEET.equals(header.name())) {
                        this.writeHeader(header);
                        break;
                    }
                    this.writeLink(header);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    Meta meta = (Meta)element;
                    this.writeHeader(meta);
                    break;
                }
                case 1: {
                    this.writeBeginTag(TITLE);
                    this.tab();
                    this.write(((Meta)element).content());
                    this.newLine();
                    this.writeEndTag(TITLE);
                    break;
                }
                case 5: {
                    this.writeComment("Producer: " + ((Meta)element).content());
                    break;
                }
                case 6: {
                    this.writeComment("Creationdate: " + ((Meta)element).content());
                    break;
                }
                case 13: 
                case 16: {
                    Section section = (Section)element;
                    if (section.title() != null) {
                        section.title().process(this);
                        this.newLine();
                        this.writeBreak();
                        this.writeBreak();
                    }
                    section.process(this);
                    this.writeBreak();
                    break;
                }
                case 10: {
                    this.tab();
                    this.write(HtmlEncoder.encode(((Chunk)element).content()));
                    this.newLine();
                    break;
                }
                case 11: {
                    element.process(this);
                    break;
                }
                case 15: {
                    this.writeBeginTag(LI);
                    element.process(this);
                    this.writeEndTag(LI);
                    break;
                }
                case 14: {
                    List list = (List)element;
                    if (list.isNumbered()) {
                        this.writeBeginTag(OL);
                    } else {
                        this.writeBeginTag(UL);
                    }
                    element.process(this);
                    if (list.isNumbered()) {
                        this.writeEndTag(OL);
                        break;
                    }
                    this.writeEndTag(UL);
                    break;
                }
                case 12: {
                    ((TreeMap)object).put(ALIGN, HtmlEncoder.getAlignment(((Paragraph)element).alignment()));
                    this.writeBeginTag(PARAGRAPH, (HtmlAttributes)object);
                    element.process(this);
                    this.writeEndTag(PARAGRAPH);
                    break;
                }
                case 17: {
                    Anchor anchor = (Anchor)element;
                    if (anchor.reference() != null) {
                        ((TreeMap)object).put(HREF, anchor.reference());
                    }
                    if (anchor.name() != null) {
                        ((TreeMap)object).put(NAME, anchor.name());
                    }
                    this.writeBeginTag(A, (HtmlAttributes)object);
                    element.process(this);
                    this.writeEndTag(A);
                    break;
                }
                case 31: 
                case 32: 
                case 33: {
                    Image image = (Image)element;
                    String string = image.url().toString();
                    if (this.imagepath != null) {
                        string = string.indexOf("/") > 0 ? this.imagepath + string.substring(string.lastIndexOf("/") + 1) : this.imagepath + string;
                    }
                    ((TreeMap)object).put(SRC, string);
                    if ((image.alignment() & 3) == 3) {
                        ((TreeMap)object).put(ALIGN, "Middle");
                    } else if ((image.alignment() & 2) == 2) {
                        ((TreeMap)object).put(ALIGN, "Left");
                    } else if ((image.alignment() & 3) == 3) {
                        ((TreeMap)object).put(ALIGN, "Right");
                    }
                    if (image.alt() != null) {
                        ((TreeMap)object).put(ALT, image.alt());
                    }
                    if (!image.hasBorders()) {
                        ((TreeMap)object).put(BORDER, "0");
                    }
                    if (image.scaledWidth() != 0) {
                        ((TreeMap)object).put(WIDTH, String.valueOf(image.scaledWidth()));
                    }
                    if (image.scaledHeight() != 0) {
                        ((TreeMap)object).put(HEIGHT, String.valueOf(image.scaledHeight()));
                    }
                    this.writeBeginTag(IMG, (HtmlAttributes)object);
                    break;
                }
                case 22: {
                    Table table = (Table)element;
                    ((TreeMap)object).put(ALIGN, HtmlEncoder.getAlignment(table.alignment()));
                    if (table.cellpadding() > 0) {
                        ((TreeMap)object).put(CELLPADDING, String.valueOf(table.cellpadding()));
                    }
                    if (table.widthPercentage() > 0) {
                        ((TreeMap)object).put(WIDTH, String.valueOf(table.widthPercentage()) + "%");
                    }
                    if (table.cellspacing() > 0) {
                        ((TreeMap)object).put(CELLSPACING, String.valueOf(table.cellspacing()));
                    }
                    if (table.borderWidth() > 0.0) {
                        ((TreeMap)object).put(BORDER, String.valueOf((int)table.borderWidth()));
                    }
                    if (table.backgroundColor() != null) {
                        ((TreeMap)object).put(BGCOLOR, HtmlEncoder.encode(table.backgroundColor()));
                    }
                    if (table.borderColor() != null) {
                        ((TreeMap)object).put(BORDERCOLOR, HtmlEncoder.encode(table.borderColor()));
                    }
                    this.writeBeginTag(TABLE, (HtmlAttributes)object);
                    Iterator iterator = table.iterator();
                    while (iterator.hasNext()) {
                        ((Row)iterator.next()).process(this);
                    }
                    this.writeEndTag(TABLE);
                    break;
                }
                case 21: {
                    Row row = (Row)element;
                    if (row.isEmpty()) break;
                    ((TreeMap)object).put(ALIGN, HtmlEncoder.getAlignment(row.horizontalAlignment()));
                    ((TreeMap)object).put(VALIGN, HtmlEncoder.getAlignment(row.verticalAlignment()));
                    this.writeBeginTag(TR, (HtmlAttributes)object);
                    int n = 0;
                    while (n < row.columns()) {
                        if (row.getCell(n) != null) {
                            row.getCell(n).process(this);
                        }
                        ++n;
                    }
                    this.writeEndTag(TR);
                    break;
                }
                case 20: {
                    Cell cell = (Cell)element;
                    ((TreeMap)object).put(ALIGN, HtmlEncoder.getAlignment(cell.horizontalAlignment()));
                    ((TreeMap)object).put(VALIGN, HtmlEncoder.getAlignment(cell.verticalAlignment()));
                    if (cell.backgroundColor() != null) {
                        ((TreeMap)object).put(BGCOLOR, HtmlEncoder.encode(cell.backgroundColor()));
                    }
                    if (cell.borderColor() != null) {
                        ((TreeMap)object).put(BORDERCOLOR, HtmlEncoder.encode(cell.borderColor()));
                    }
                    if (cell.rowspan() > 1) {
                        ((TreeMap)object).put(ROWSPAN, String.valueOf(cell.rowspan()));
                    }
                    if (cell.colspan() > 1) {
                        ((TreeMap)object).put(COLSPAN, String.valueOf(cell.colspan()));
                    }
                    if (cell.noWrap()) {
                        ((TreeMap)object).put(NOWRAP, null);
                    }
                    if (cell.header()) {
                        this.writeBeginTag(TH, (HtmlAttributes)object);
                    } else {
                        this.writeBeginTag(TD, (HtmlAttributes)object);
                    }
                    if (cell.isEmpty()) {
                        this.os.write(NBSP);
                    } else {
                        Iterator iterator = cell.getElements();
                        while (iterator.hasNext()) {
                            Element element2 = (Element)iterator.next();
                            if (element2.type() == 12) {
                                HtmlAttributes htmlAttributes = new HtmlAttributes();
                                htmlAttributes.put(ALIGN, HtmlEncoder.getAlignment(cell.horizontalAlignment()));
                                this.writeBeginTag(PARAGRAPH, htmlAttributes);
                                element2.process(this);
                                this.writeEndTag(PARAGRAPH);
                                continue;
                            }
                            element2.process(this);
                        }
                    }
                    if (cell.header()) {
                        this.writeEndTag(TH);
                        break;
                    }
                    this.writeEndTag(TD);
                    break;
                }
                default: {
                    return false;
                }
            }
            if (font != null) {
                this.resetFont(font);
            }
            return true;
        }
        catch (IOException iOException) {
            throw new DocumentException(iOException.getMessage());
        }
    }

    public void open() {
        super.open();
        try {
            this.writeEndTag(HEAD);
            HtmlAttributes htmlAttributes = new HtmlAttributes();
            if (this.font != null && this.font.color() != null) {
                htmlAttributes.put(TEXT, HtmlEncoder.encode(this.font.color()));
            }
            if (this.document.leftMargin() > 0) {
                htmlAttributes.put(LEFTMARGIN, String.valueOf(this.document.leftMargin()));
            }
            if (this.document.rightMargin() > 0) {
                htmlAttributes.put(RIGHTMARGIN, String.valueOf(this.document.rightMargin()));
            }
            if (this.document.topMargin() > 0) {
                htmlAttributes.put(TOPMARGIN, String.valueOf(this.document.topMargin()));
            }
            if (this.document.bottomMargin() > 0) {
                htmlAttributes.put(BOTTOMMARGIN, String.valueOf(this.document.bottomMargin()));
            }
            if (this.pageSize.backgroundColor() != null) {
                htmlAttributes.put(BGCOLOR, HtmlEncoder.encode(this.pageSize.backgroundColor()));
            }
            this.writeBeginTag(BODY, htmlAttributes);
            this.initHeader();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.initFooter();
            this.writeEndTag(BODY);
            this.writeEndTag(HTML);
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initHeader() {
        if (this.header != null) {
            try {
                this.add(this.header.paragraph());
                this.newLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initFooter() {
        if (this.footer != null) {
            try {
                this.footer.setPageNumber(pageN + 1);
                this.add(this.footer.paragraph());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void newLine() throws IOException {
        this.os.write(10);
    }

    private void tab() throws IOException {
        int n = 0;
        while (n < this.indent) {
            this.os.write(9);
            ++n;
        }
    }

    private void writeBreak() throws IOException {
        this.tab();
        this.os.write(60);
        this.os.write(BR);
        this.os.write(62);
        this.newLine();
    }

    private void writeBeginTag(byte[] byArray) throws IOException {
        this.tab();
        this.os.write(60);
        this.os.write(byArray);
        this.os.write(62);
        ++this.indent;
        this.newLine();
    }

    private void writeBeginTag(byte[] byArray, HtmlAttributes htmlAttributes) throws IOException {
        this.tab();
        this.os.write(60);
        this.os.write(byArray);
        this.write(htmlAttributes.toString());
        this.os.write(62);
        ++this.indent;
        this.newLine();
    }

    private void writeEndTag(byte[] byArray) throws IOException {
        --this.indent;
        this.tab();
        this.os.write(60);
        this.os.write(47);
        this.os.write(byArray);
        this.os.write(62);
        this.newLine();
    }

    private void writeHeader(Meta meta) throws IOException {
        HtmlAttributes htmlAttributes = new HtmlAttributes();
        htmlAttributes.put(CONTENT, meta.content());
        switch (meta.type()) {
            case 0: {
                htmlAttributes.put(NAME, ((Header)meta).name());
                break;
            }
            case 2: {
                htmlAttributes.put(NAME, "subject");
                break;
            }
            case 3: {
                htmlAttributes.put(NAME, "keywords");
                break;
            }
            case 4: {
                htmlAttributes.put(NAME, "author");
            }
        }
        this.writeBeginTag(META, htmlAttributes);
        --this.indent;
    }

    private void writeLink(Header header) throws IOException {
        HtmlAttributes htmlAttributes = new HtmlAttributes();
        htmlAttributes.put(REL, header.name());
        htmlAttributes.put(TYPE, CSS);
        htmlAttributes.put(HREF, header.content());
        this.writeBeginTag(LINK, htmlAttributes);
        --this.indent;
    }

    private void writeComment(String string) throws IOException {
        this.tab();
        this.os.write(BEGINCOMMENT);
        this.write(string);
        this.os.write(ENDCOMMENT);
        this.newLine();
    }

    private void setFont(Font font) throws IOException {
        if (!font.isStandardFont()) {
            HtmlAttributes htmlAttributes = new HtmlAttributes();
            if (font.family() != -1) {
                htmlAttributes.put(FACE, FONTS[font.family()]);
            }
            if (font.size() != -1) {
                htmlAttributes.put(POINTSIZE, String.valueOf(font.size()));
            }
            if (font.color() != null) {
                htmlAttributes.put(COLOR, HtmlEncoder.encode(font.color()));
            }
            this.writeBeginTag(FONT, htmlAttributes);
        }
        if (!this.font.isBold() && font.isBold()) {
            this.writeBeginTag(B);
        }
        if (!this.font.isItalic() && font.isItalic()) {
            this.writeBeginTag(I);
        }
        if (!this.font.isStrikethru() && font.isStrikethru()) {
            this.writeBeginTag(S);
        }
        if (!this.font.isUnderlined() && font.isUnderlined()) {
            this.writeBeginTag(U);
        }
    }

    private void resetFont(Font font) throws IOException {
        if (font.isItalic()) {
            this.writeEndTag(I);
        }
        if (font.isBold()) {
            this.writeEndTag(B);
        }
        if (font.isUnderlined()) {
            this.writeEndTag(U);
        }
        if (font.isStrikethru()) {
            this.writeEndTag(S);
        }
        if (!font.isStandardFont()) {
            this.writeEndTag(FONT);
        }
    }

    public void setStandardFont(Font font) {
        this.standardFont = font;
    }

    public void setImagepath(String string) {
        this.imagepath = string;
    }

    public void resetImagepath() {
        this.imagepath = null;
    }

    public void setHeader(HeaderFooter headerFooter) {
        this.header = headerFooter;
    }

    public void setFooter(HeaderFooter headerFooter) {
        this.footer = headerFooter;
    }

    static {
        HtmlWriter.FONTS[0] = "Courier";
        HtmlWriter.FONTS[1] = "Helvetica, Arial";
        HtmlWriter.FONTS[2] = "'Times New Roman, Times";
        HtmlWriter.FONTS[3] = "Symbol";
        HtmlWriter.FONTS[4] = "ZapfDingbats, WingDings";
        pageN = 0;
    }
}

