/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import java.awt.Color;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class Table
extends Rectangle
implements Element {
    private int columns;
    private int currentRow;
    private ArrayList rows = new ArrayList();
    private Cell defaultLayout = new Cell();
    private int lastHeaderRow = -1;
    private int alignment = 1;
    private int cellpadding;
    private int cellspacing;
    private int widthPercentage = 80;
    private int[] widths;

    public Table(int n) throws BadElementException {
        this(n, 1);
    }

    public Table(int n, int n2) throws BadElementException {
        super(0, 0, 0, 0);
        this.setBorder(15);
        this.setBorderWidth(1.0);
        if (n <= 0) {
            throw new BadElementException("A table should have at least 1 column.");
        }
        this.columns = n;
        int n3 = 0;
        while (n3 < n2) {
            this.rows.add(new Row(n));
            ++n3;
        }
        this.currentRow = 0;
        this.widths = new int[n];
        int n4 = 100 / n;
        int n5 = 0;
        while (n5 < n) {
            this.widths[n5] = n4;
            ++n5;
        }
    }

    public final boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public final int type() {
        return 22;
    }

    public final ArrayList getChunks() {
        return new ArrayList();
    }

    public final void addCell(Cell cell) {
        int n;
        Row row = (Row)this.rows.get(this.currentRow);
        while ((n = row.addCell(cell)) < 0) {
            ++this.currentRow;
            if (this.currentRow >= this.rows.size()) {
                row = new Row(row.columns());
                this.rows.add(row);
            }
            row = (Row)this.rows.get(this.currentRow);
        }
        int n2 = 1;
        while (n2 < cell.colspan()) {
            row.reserve(n + n2);
            ++n2;
        }
        int n3 = 1;
        while (n3 < cell.rowspan()) {
            int n4 = 0;
            while (n4 < cell.colspan()) {
                if (this.currentRow + n3 >= this.rows.size()) {
                    this.rows.add(new Row(row.columns()));
                }
                row = (Row)this.rows.get(this.currentRow + n3);
                row.reserve(n + n4);
                ++n4;
            }
            ++n3;
        }
    }

    public final void addCell(Phrase phrase) throws BadElementException {
        Cell cell = new Cell(phrase);
        cell.setBorder(this.defaultLayout.border());
        cell.setBorderWidth(this.defaultLayout.borderWidth());
        cell.setBorderColor(this.defaultLayout.borderColor());
        cell.setBackgroundColor(this.defaultLayout.backgroundColor());
        cell.setGrayFill(this.defaultLayout.grayFill());
        cell.setHorizontalAlignment(this.defaultLayout.horizontalAlignment());
        cell.setVerticalAlignment(this.defaultLayout.verticalAlignment());
        cell.setColspan(this.defaultLayout.colspan());
        cell.setRowspan(this.defaultLayout.rowspan());
        this.addCell(cell);
    }

    public final void addCell(String string) throws BadElementException {
        this.addCell(new Paragraph(string));
    }

    public final void setDefaultCellBorder(int n) {
        this.defaultLayout.setBorder(n);
    }

    public final void setDefaultCellBorderWidth(int n) {
        this.defaultLayout.setBorderWidth(n);
    }

    public final void setDefaultCellBorderColor(Color color) {
        this.defaultLayout.setBorderColor(color);
    }

    public final void setDefaultCellBackgroundColor(Color color) {
        this.defaultLayout.setBackgroundColor(color);
    }

    public final void setDefaultCellGrayFill(double d) {
        if (d >= 0.0 && d <= 1.0) {
            this.defaultLayout.setGrayFill(d);
        }
    }

    public final void setDefaultHorizontalAlignment(int n) {
        this.defaultLayout.setHorizontalAlignment(n);
    }

    public final void setDefaultVerticalAlignment(int n) {
        this.defaultLayout.setVerticalAlignment(n);
    }

    public final void setDefaultRowspan(int n) {
        this.defaultLayout.setRowspan(n);
    }

    public final void setDefaultColspan(int n) {
        this.defaultLayout.setColspan(n);
    }

    public final void deleteColumn(int n) throws DocumentException {
        int[] nArray = new int[--this.columns];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.widths[n2];
            ++n2;
        }
        int n3 = n;
        while (n3 < this.columns) {
            nArray[n3] = this.widths[n3 + 1];
            ++n3;
        }
        this.setWidths(nArray);
        int n4 = 0;
        while (n4 < this.columns) {
            nArray[n4] = this.widths[n4];
            ++n4;
        }
        this.widths = nArray;
        int n5 = this.rows.size();
        int n6 = 0;
        while (n6 < n5) {
            Row row = (Row)this.rows.get(n6);
            row.deleteColumn(n);
            this.rows.set(n6, row);
            ++n6;
        }
    }

    public final boolean deleteRow(int n) {
        if (n < 0 || n >= this.rows.size()) {
            return false;
        }
        this.rows.remove(n);
        return true;
    }

    public final boolean deleteLastRow() {
        return this.deleteRow(this.rows.size() - 1);
    }

    public int endHeaders() {
        this.lastHeaderRow = this.currentRow;
        return this.lastHeaderRow;
    }

    public final void setAlignment(int n) {
        this.alignment = n;
    }

    public final void setCellpadding(int n) {
        this.cellpadding = n;
    }

    public final void setCellspacing(int n) {
        this.cellspacing = n;
    }

    public final void setWidth(int n) {
        this.widthPercentage = n;
    }

    public final void setWidths(int[] nArray) throws DocumentException {
        if (nArray.length != this.columns) {
            throw new DocumentException("Wrong number of columns.");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.columns) {
            n += nArray[n2];
            ++n2;
        }
        this.widths[this.columns - 1] = 100;
        int n3 = 0;
        while (n3 < this.columns - 1) {
            int n4;
            this.widths[n3] = n4 = (int)(0.5 + 100.0 * (double)nArray[n3] / (double)n);
            int n5 = this.columns - 1;
            this.widths[n5] = this.widths[n5] - n4;
            ++n3;
        }
    }

    public final int size() {
        return this.rows.size();
    }

    public Iterator iterator() {
        return ((AbstractList)this.rows).iterator();
    }

    public int alignment() {
        return this.alignment;
    }

    public int cellpadding() {
        return this.cellpadding;
    }

    public int cellspacing() {
        return this.cellspacing;
    }

    public int widthPercentage() {
        return this.widthPercentage;
    }

    public int firstDataRow() {
        return this.lastHeaderRow + 1;
    }

    public int[] getWidths(int n, int n2) {
        int[] nArray = new int[this.columns + 1];
        switch (this.alignment) {
            case 0: {
                nArray[0] = n;
                break;
            }
            case 2: {
                nArray[0] = n + n2 * (100 - this.widthPercentage) / 100;
                break;
            }
            default: {
                nArray[0] = n + n2 * (100 - this.widthPercentage) / 200;
            }
        }
        n2 = n2 * this.widthPercentage / 100;
        int n3 = 1;
        while (n3 < this.columns) {
            nArray[n3] = nArray[n3 - 1] + this.widths[n3 - 1] * n2 / 100;
            ++n3;
        }
        nArray[this.columns] = nArray[0] + n2;
        return nArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<TABLE WIDTH=\"");
        stringBuffer.append(this.widthPercentage);
        stringBuffer.append("%\" HORIZONTAL_ALIGNMENT=\"");
        switch (this.alignment) {
            case 0: {
                stringBuffer.append("Left");
                break;
            }
            case 1: {
                stringBuffer.append("Center");
                break;
            }
            case 2: {
                stringBuffer.append("Right");
                break;
            }
            case 3: {
                stringBuffer.append("Justify");
                break;
            }
            default: {
                stringBuffer.append("Default");
            }
        }
        stringBuffer.append("\" CELLPADDING=\"");
        stringBuffer.append(this.cellpadding);
        stringBuffer.append("\" CELLSPACING=\"");
        stringBuffer.append(this.cellspacing);
        stringBuffer.append("\">\n");
        stringBuffer.append("\t<WIDTHS>\n");
        int n = 0;
        while (n < this.widths.length) {
            stringBuffer.append("\t\t<WITDH COLUMN=\"");
            stringBuffer.append(n);
            stringBuffer.append("\">");
            stringBuffer.append(this.widths[n]);
            stringBuffer.append("</WIDTH>\n");
            ++n;
        }
        stringBuffer.append("\t</WIDTHS>\n");
        if (this.borderWidth > 0.0) {
            stringBuffer.append("\t<BORDER WIDTH=\"");
            stringBuffer.append(this.borderWidth);
            stringBuffer.append("\">");
            if (this.hasBorder(1)) {
                stringBuffer.append("\t\t<SIDE>");
                stringBuffer.append("top");
                stringBuffer.append("</SIDE>\n");
            }
            if (this.hasBorder(2)) {
                stringBuffer.append("\t\t<SIDE>");
                stringBuffer.append("bottom");
                stringBuffer.append("</SIDE>\n");
            }
            if (this.hasBorder(4)) {
                stringBuffer.append("\t\t<SIDE>");
                stringBuffer.append("left");
                stringBuffer.append("</SIDE>\n");
            }
            if (this.hasBorder(8)) {
                stringBuffer.append("\t\t<SIDE>");
                stringBuffer.append("right");
                stringBuffer.append("</SIDE>\n");
            }
            if (this.color != null) {
                stringBuffer.append("\t\t<COLOR>\n");
                stringBuffer.append("\t\t\t<RED>");
                stringBuffer.append(this.color.getRed());
                stringBuffer.append("</RED>\n");
                stringBuffer.append("\t\t\t<GREEN>");
                stringBuffer.append(this.color.getGreen());
                stringBuffer.append("</GREEN>\n");
                stringBuffer.append("\t\t\t<BLUE>");
                stringBuffer.append(this.color.getBlue());
                stringBuffer.append("</BLUE>\n");
                stringBuffer.append("\t\t</COLOR>\n");
            }
            stringBuffer.append("\t</BORDER>\n");
        }
        Iterator iterator = ((AbstractList)this.rows).iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            stringBuffer.append(row.toString());
        }
        stringBuffer.append("</TABLE>\n");
        return stringBuffer.toString();
    }
}

