/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import java.awt.Color;
import java.util.ArrayList;

public class Rectangle
implements Element {
    public static final int UNDEFINED = -1;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int NO_BORDER = 0;
    public static final int BOX = 15;
    protected int llx;
    protected int lly;
    protected int urx;
    protected int ury;
    protected int border = -1;
    protected double borderWidth = -1.0;
    protected Color color = null;
    protected Color background = null;
    protected double grayFill = 0.0;

    public Rectangle(int n, int n2, int n3, int n4) {
        this.llx = n;
        this.lly = n2;
        this.urx = n3;
        this.ury = n4;
    }

    public Rectangle(int n, int n2) {
        this(0, 0, n, n2);
    }

    public Rectangle(Rectangle rectangle) {
        this(rectangle.left(), rectangle.bottom(), rectangle.right(), rectangle.top());
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 30;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public Rectangle rectangle(int n, int n2) {
        Rectangle rectangle = new Rectangle(this);
        rectangle.setBorder(this.border);
        rectangle.setBorderWidth(this.borderWidth);
        rectangle.setBorderColor(this.color);
        rectangle.setBackgroundColor(this.background);
        rectangle.setGrayFill(this.grayFill);
        if (this.top() > n) {
            rectangle.setTop(n);
            rectangle.setBorder(this.border - (this.border & 1));
        }
        if (this.bottom() < n2) {
            rectangle.setBottom(n2);
            rectangle.setBorder(this.border - (this.border & 2));
        }
        return rectangle;
    }

    public Rectangle rotate() {
        return new Rectangle(this.lly, this.llx, this.ury, this.urx);
    }

    public void setLeft(int n) {
        this.llx = n;
    }

    public void setRight(int n) {
        this.urx = n;
    }

    public void setTop(int n) {
        this.ury = n;
    }

    public void setBottom(int n) {
        this.lly = n;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public void setBorderWidth(double d) {
        this.borderWidth = d;
    }

    public void setBorderColor(Color color) {
        this.color = color;
    }

    public void setBackgroundColor(Color color) {
        this.background = color;
    }

    public void setGrayFill(double d) {
        if (d >= 0.0 && d <= 1.0) {
            this.grayFill = d;
        }
    }

    public int left() {
        return this.llx;
    }

    public int right() {
        return this.urx;
    }

    public int top() {
        return this.ury;
    }

    public int bottom() {
        return this.lly;
    }

    public int left(int n) {
        return this.llx + n;
    }

    public int right(int n) {
        return this.urx - n;
    }

    public int top(int n) {
        return this.ury - n;
    }

    public int bottom(int n) {
        return this.lly + n;
    }

    public int width() {
        return this.urx - this.llx;
    }

    public int height() {
        return this.ury - this.lly;
    }

    public final boolean hasBorders() {
        return this.border > 0 && this.borderWidth > 0.0;
    }

    public final boolean hasBorder(int n) {
        return this.border != -1 && (this.border & n) == n;
    }

    public final int border() {
        return this.border;
    }

    public double borderWidth() {
        return this.borderWidth;
    }

    public final Color borderColor() {
        return this.color;
    }

    public final Color backgroundColor() {
        return this.background;
    }

    public final double grayFill() {
        return this.grayFill;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<RECTANGLE X1=\"");
        stringBuffer.append(this.llx);
        stringBuffer.append("\" Y1=\"");
        stringBuffer.append(this.ury);
        stringBuffer.append("\" X2=\"");
        stringBuffer.append(this.urx);
        stringBuffer.append("\" Y2=\"");
        stringBuffer.append(this.lly);
        stringBuffer.append("\">\n");
        if (this.borderWidth != -1.0) {
            stringBuffer.append("\t<BORDER WIDTH=\"");
            stringBuffer.append(this.borderWidth);
            stringBuffer.append("\">\n");
            if (this.hasBorder(4)) {
                stringBuffer.append("\t\tleft\n");
            }
            if (this.hasBorder(8)) {
                stringBuffer.append("\t\tright\n");
            }
            if (this.hasBorder(1)) {
                stringBuffer.append("\t\ttop\n");
            }
            if (this.hasBorder(2)) {
                stringBuffer.append("\t\tbottom\n");
            }
            stringBuffer.append("\t</BORDER>\n");
        }
        if (this.color != null) {
            stringBuffer.append("\t<COLOR RED=\"");
            stringBuffer.append(this.color.getRed());
            stringBuffer.append("\" GREEN=\"");
            stringBuffer.append(this.color.getGreen());
            stringBuffer.append("\" BLUE=\"");
            stringBuffer.append(this.color.getBlue());
            stringBuffer.append("\"></COLOR>\n");
        }
        stringBuffer.append("</RECTANGLE>\n");
        return stringBuffer.toString();
    }
}

