/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class Png
extends Image
implements Element {
    public static final int[] PNGID = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
    public static final String IHDR = "IHDR";
    public static final String PLTE = "PLTE";
    public static final String IDAT = "IDAT";
    public static final String IEND = "IEND";

    public Png(URL uRL) throws BadElementException, IOException {
        super(uRL);
        this.processParameters();
    }

    public Png(URL uRL, int n, int n2) throws BadElementException, IOException {
        this(uRL);
        this.scaledWidth = n;
        this.scaledHeight = n2;
    }

    public Png(String string) throws MalformedURLException, BadElementException, IOException {
        this(Image.toURL(string));
    }

    public Png(String string, int n, int n2) throws MalformedURLException, BadElementException, IOException {
        this(Image.toURL(string), n, n2);
    }

    public Png(byte[] byArray) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = byArray;
        this.processParameters();
    }

    public Png(byte[] byArray, int n, int n2) throws BadElementException, IOException {
        this(byArray);
        this.scaledWidth = n;
        this.scaledHeight = n2;
    }

    public static final int getInt(InputStream inputStream) throws IOException {
        return (inputStream.read() << 24) + (inputStream.read() << 16) + (inputStream.read() << 8) + inputStream.read();
    }

    public static final String getString(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 4) {
            stringBuffer.append((char)inputStream.read());
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void processParameters() throws BadElementException, IOException {
        this.type = 33;
        InputStream inputStream = null;
        try {
            String string;
            if (this.rawData == null) {
                inputStream = this.url.openStream();
                string = this.url.toString();
            } else {
                inputStream = new ByteArrayInputStream(this.rawData);
                string = "Byte array";
            }
            int n = 0;
            while (n < PNGID.length) {
                if (PNGID[n] != inputStream.read()) {
                    throw new BadElementException(string + " is not a valid PNG-file.");
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (inputStream != null) {
                inputStream.close();
            }
            this.plainWidth = this.width();
            this.plainHeight = this.height();
            throw throwable;
        }
        while (true) {
            int n = Png.getInt(inputStream);
            if (IHDR.equals(Png.getString(inputStream))) {
                this.scaledWidth = Png.getInt(inputStream);
                this.setRight((int)this.scaledWidth);
                this.scaledHeight = Png.getInt(inputStream);
                this.setTop((int)this.scaledHeight);
                break;
            }
            if (IEND.equals(Png.getString(inputStream))) break;
            this.skip(inputStream, n + 4);
        }
        Object var6_5 = null;
        if (inputStream != null) {
            inputStream.close();
        }
        this.plainWidth = this.width();
        this.plainHeight = this.height();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<PNG>");
        stringBuffer.append(super.toString());
        stringBuffer.append("</PNG>");
        return stringBuffer.toString();
    }
}

