/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Anchor;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Font;
import com.lowagie.text.Greek;
import com.lowagie.text.List;
import com.lowagie.text.Table;
import com.lowagie.text.TextElementArray;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Phrase
extends ArrayList
implements TextElementArray {
    protected int leading;

    public Phrase() {
        this(16);
    }

    public Phrase(int n) {
        this.leading = n;
    }

    public Phrase(Chunk chunk) {
        this(chunk.font().leading(1.5));
        super.add(chunk);
    }

    public Phrase(int n, Chunk chunk) {
        this(n);
        super.add(chunk);
    }

    public Phrase(String string) {
        this(new Font().leading(1.5), string, new Font());
    }

    public Phrase(String string, Font font) {
        this(font.leading(1.5), string, font);
    }

    public Phrase(int n, String string) {
        this(n, string, new Font());
    }

    public Phrase(int n, String string, Font font) {
        this(n);
        if (font.family() != 3 && font.family() != 4) {
            int n2;
            boolean bl = false;
            while ((n2 = Greek.index(string)) > -1) {
                Object object;
                if (n2 > 0) {
                    object = string.substring(0, n2);
                    super.add(new Chunk((String)object));
                    string = string.substring(n2);
                }
                object = new Font(3, font.size(), font.style(), font.color());
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Greek.getCorrespondingSymbol(string.charAt(0)));
                string = string.substring(1);
                while (Greek.index(string) == 0) {
                    stringBuffer.append(Greek.getCorrespondingSymbol(string.charAt(0)));
                    string = string.substring(1);
                }
                super.add(new Chunk(stringBuffer.toString(), (Font)object));
            }
        }
        super.add(new Chunk(string, font));
    }

    public final boolean process(ElementListener elementListener) {
        try {
            Iterator iterator = ((AbstractList)this).iterator();
            while (iterator.hasNext()) {
                elementListener.add((Element)iterator.next());
            }
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 11;
    }

    public ArrayList getChunks() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = ((AbstractList)this).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((Element)iterator.next()).getChunks());
        }
        return arrayList;
    }

    public void add(int n, Object object) {
        try {
            Element element = (Element)object;
            if (element.type() != 10 && element.type() != 11 && element.type() != 17 && element.type() != 22) {
                throw new ClassCastException(String.valueOf(element.type()));
            }
            super.add(n, element);
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("Insertion of illegal Element: " + classCastException.getMessage());
        }
    }

    public boolean add(Object object) {
        if (object instanceof String) {
            return super.add(new Chunk((String)object, this.font()));
        }
        try {
            Element element = (Element)object;
            switch (element.type()) {
                case 10: {
                    Chunk chunk = (Chunk)object;
                    return super.add(chunk);
                }
                case 11: 
                case 12: {
                    Phrase phrase = (Phrase)object;
                    boolean bl = true;
                    Iterator iterator = ((AbstractList)phrase).iterator();
                    while (iterator.hasNext()) {
                        bl &= super.add(iterator.next());
                    }
                    return bl;
                }
                case 17: {
                    return super.add((Anchor)object);
                }
                case 22: {
                    Table table = (Table)object;
                    return super.add(object);
                }
                case 14: {
                    List list = (List)object;
                    return super.add(list);
                }
            }
            throw new ClassCastException(String.valueOf(element.type()));
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("Insertion of illegal Element: " + classCastException.getMessage());
        }
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return true;
    }

    protected boolean addSpecial(Object object) {
        return super.add(object);
    }

    public final void setLeading(int n) {
        this.leading = n;
    }

    public final boolean isEmpty() {
        switch (this.size()) {
            case 0: {
                return true;
            }
            case 1: {
                Element element = (Element)this.get(0);
                return element.type() == 10 && ((Chunk)element).isEmpty();
            }
        }
        return false;
    }

    public final int leading() {
        return this.leading;
    }

    public final Font font() {
        if (this.size() < 1) {
            return new Font();
        }
        try {
            Element element = (Element)this.get(0);
            switch (element.type()) {
                case 10: {
                    return ((Chunk)element).font();
                }
                case 11: 
                case 17: {
                    return ((Phrase)element).font();
                }
            }
            return new Font();
        }
        catch (ClassCastException classCastException) {
            return new Font();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<phrase leading=\"");
        stringBuffer.append(this.leading);
        stringBuffer.append("\">\n");
        Iterator iterator = ((AbstractList)this).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
        }
        stringBuffer.append("</phrase>\n");
        return stringBuffer.toString();
    }
}

