/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class Jpeg
extends Image
implements Element {
    public static final int NOT_A_MARKER = -1;
    public static final int VALID_MARKER = 0;
    public static final int[] VALID_MARKERS = new int[]{192, 193, 194};
    public static final int UNSUPPORTED_MARKER = 1;
    public static final int[] UNSUPPORTED_MARKERS = new int[]{195, 197, 198, 199, 200, 201, 202, 203, 205, 206, 207};
    public static final int NOPARAM_MARKER = 2;
    public static final int[] NOPARAM_MARKERS = new int[]{208, 209, 210, 211, 212, 213, 214, 215, 216, 1};

    public Jpeg(URL uRL) throws BadElementException, IOException {
        super(uRL);
        this.processParameters();
    }

    public Jpeg(URL uRL, int n, int n2) throws BadElementException, IOException {
        this(uRL);
        this.scaledWidth = n;
        this.scaledHeight = n2;
    }

    public Jpeg(String string) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(string));
    }

    public Jpeg(String string, int n, int n2) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(string), n, n2);
    }

    public Jpeg(byte[] byArray) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = byArray;
        this.processParameters();
    }

    public Jpeg(byte[] byArray, int n, int n2) throws BadElementException, IOException {
        this(byArray);
        this.scaledWidth = n;
        this.scaledHeight = n2;
    }

    private static final int getShort(InputStream inputStream) throws IOException {
        return (inputStream.read() << 8) + inputStream.read();
    }

    private static final int marker(int n) {
        int n2 = 0;
        while (n2 < VALID_MARKERS.length) {
            if (n == VALID_MARKERS[n2]) {
                return 0;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < NOPARAM_MARKERS.length) {
            if (n == NOPARAM_MARKERS[n3]) {
                return 2;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < UNSUPPORTED_MARKERS.length) {
            if (n == UNSUPPORTED_MARKERS[n4]) {
                return 1;
            }
            ++n4;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void processParameters() throws BadElementException, IOException {
        block11: {
            this.type = 32;
            InputStream inputStream = null;
            try {
                String string;
                if (this.rawData == null) {
                    inputStream = this.url.openStream();
                    string = this.url.toString();
                } else {
                    inputStream = new ByteArrayInputStream(this.rawData);
                    string = "Byte array";
                }
                if (inputStream.read() != 255) throw new BadElementException(string + " is not a valid JPEG-file.");
                if (inputStream.read() != 216) {
                    throw new BadElementException(string + " is not a valid JPEG-file.");
                }
                while (true) {
                    if (inputStream.read() != 255) {
                        continue;
                    }
                    int n = inputStream.read();
                    int n2 = Jpeg.marker(n);
                    if (n2 == 0) {
                        this.skip(inputStream, 2);
                        if (inputStream.read() != 8) {
                            throw new BadElementException(string + " must have 8 bits per component.");
                        }
                        this.scaledHeight = Jpeg.getShort(inputStream);
                        this.setTop((int)this.scaledHeight);
                        this.scaledWidth = Jpeg.getShort(inputStream);
                        this.setRight((int)this.scaledWidth);
                        this.colorspace = inputStream.read();
                        Object var6_5 = null;
                        if (inputStream == null) break block11;
                        break;
                    }
                    if (n2 == 1) {
                        throw new BadElementException(string + ": unsupported JPEG marker: " + n);
                    }
                    if (n2 == 2) continue;
                    this.skip(inputStream, Jpeg.getShort(inputStream) - 2);
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                this.plainWidth = this.width();
                this.plainHeight = this.height();
                throw throwable;
            }
            inputStream.close();
        }
        this.plainWidth = this.width();
        this.plainHeight = this.height();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<JPEG>");
        stringBuffer.append(super.toString());
        stringBuffer.append("</JPEG>");
        return stringBuffer.toString();
    }
}

