/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import java.awt.Color;

public class Font
implements Comparable {
    public static final int COURIER = 0;
    public static final int HELVETICA = 1;
    public static final int TIMES_NEW_ROMAN = 2;
    public static final int SYMBOL = 3;
    public static final int ZAPFDINGBATS = 4;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final int STRIKETHRU = 8;
    public static final int BOLDITALIC = 3;
    public static final int UNDEFINED = -1;
    public static final int DEFAULTSIZE = 12;
    private int family = -1;
    private int size = -1;
    private int style = -1;
    private Color color = null;

    public Font(int n, int n2, int n3, Color color) {
        this.family = n;
        this.size = n2;
        this.style = n3;
        this.color = color;
    }

    public Font(int n, int n2, int n3) {
        this(n, n2, n3, null);
    }

    public Font(int n, int n2) {
        this(n, n2, -1, null);
    }

    public Font(int n) {
        this(n, -1, -1, null);
    }

    public Font() {
        this(-1, -1, -1, null);
    }

    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        try {
            Font font = (Font)object;
            if (this.family != font.family()) {
                return 1;
            }
            if (this.size != font.size()) {
                return 2;
            }
            if (this.style != font.style()) {
                return 3;
            }
            if (this.color == null) {
                if (font.color == null) {
                    return 0;
                }
                return 4;
            }
            if (font.color == null) {
                return 4;
            }
            if (this.color.equals(font.color())) {
                return 0;
            }
            return 4;
        }
        catch (ClassCastException classCastException) {
            return -2;
        }
    }

    public void setFamily(String string) {
        this.family = Font.getFamilyIndex(string);
    }

    public static int getFamilyIndex(String string) {
        if (string.equalsIgnoreCase("Courier")) {
            return 0;
        }
        if (string.equalsIgnoreCase("Helvetica")) {
            return 1;
        }
        if (string.equalsIgnoreCase("Times New Roman")) {
            return 2;
        }
        if (string.equalsIgnoreCase("Symbol")) {
            return 3;
        }
        if (string.equalsIgnoreCase("ZapfDingBats")) {
            return 4;
        }
        return -1;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void setStyle(String string) {
        this.style = Font.getStyleValue(string);
    }

    public static int getStyleValue(String string) {
        int n = 0;
        if (string.indexOf("normal") != -1) {
            n |= 0;
        }
        if (string.indexOf("bold") != -1) {
            n |= 1;
        }
        if (string.indexOf("italic") != -1) {
            n |= 2;
        }
        if (string.indexOf("underline") != -1) {
            n |= 4;
        }
        if (string.indexOf("strike") != -1) {
            n |= 8;
        }
        return n;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(int n, int n2, int n3) {
        this.color = new Color(n, n2, n3);
    }

    public int leading(double d) {
        if (this.size == -1) {
            return (int)(d * 12.0 + 0.5);
        }
        return (int)(d * (double)this.size + 0.5);
    }

    public boolean isStandardFont() {
        return this.family == -1 && this.size == -1 && this.color == null;
    }

    public Font difference(Font font) {
        Font font2 = new Font();
        if (this.family != font.family()) {
            font2.family = this.family;
        }
        if (this.size != font.size()) {
            font2.size = this.size;
        }
        if (this.style != font.style() && this.style != -1) {
            font2.style = this.style;
            if (font.style() != -1) {
                font2.style -= this.style & font.style();
            }
        }
        if (this.color == null || !this.color.equals(font.color())) {
            font2.color = this.color;
        }
        return font2;
    }

    public int family() {
        return this.family;
    }

    public int size() {
        return this.size;
    }

    public int style() {
        return this.style;
    }

    public boolean isBold() {
        if (this.style == -1) {
            return false;
        }
        return (this.style & 1) == 1;
    }

    public boolean isItalic() {
        if (this.style == -1) {
            return false;
        }
        return (this.style & 2) == 2;
    }

    public boolean isUnderlined() {
        if (this.style == -1) {
            return false;
        }
        return (this.style & 4) == 4;
    }

    public boolean isStrikethru() {
        if (this.style == -1) {
            return false;
        }
        return (this.style & 8) == 8;
    }

    public Color color() {
        return this.color;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(" font=\"");
        switch (this.family) {
            case 0: {
                stringBuffer.append("Courier");
                break;
            }
            case 1: {
                stringBuffer.append("Helvetica");
                break;
            }
            case 2: {
                stringBuffer.append("Times New Roman");
                break;
            }
            case 3: {
                stringBuffer.append("Symbol");
                break;
            }
            case 4: {
                stringBuffer.append("ZapfDingbats");
                break;
            }
            default: {
                stringBuffer.append("default");
            }
        }
        if (this.size != -1) {
            stringBuffer.append("\" size=\"");
            stringBuffer.append(this.size);
        }
        if (this.style != -1) {
            stringBuffer.append("\" style=\"");
            switch (this.style & 3) {
                case 0: {
                    stringBuffer.append("normal");
                    break;
                }
                case 1: {
                    stringBuffer.append("bold");
                    break;
                }
                case 2: {
                    stringBuffer.append("italic");
                    break;
                }
                case 3: {
                    stringBuffer.append("bold, italic");
                }
            }
        }
        if (this.color != null) {
            stringBuffer.append("\" red=\"");
            stringBuffer.append(this.color.getRed());
            stringBuffer.append("\" green=\"");
            stringBuffer.append(this.color.getGreen());
            stringBuffer.append("\" blue=\"");
            stringBuffer.append(this.color.getBlue());
        }
        return stringBuffer.append("\"").toString();
    }
}

