/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Watermark;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class DocWriter
implements DocListener {
    protected Rectangle pageSize;
    protected Document document;
    protected BufferedOutputStream os;
    protected boolean open = false;
    protected boolean pause = false;

    protected DocWriter(Document document, OutputStream outputStream) {
        this.document = document;
        this.os = new BufferedOutputStream(outputStream);
        this.open = true;
    }

    public void finalize() {
        this.close();
    }

    public boolean add(Element element) throws DocumentException {
        return false;
    }

    public void open() {
        this.open = true;
    }

    public boolean setPageSize(Rectangle rectangle) {
        this.pageSize = rectangle;
        return true;
    }

    public boolean add(Watermark watermark) {
        return false;
    }

    public void removeWatermark() {
    }

    public boolean setMargins(int n, int n2, int n3, int n4) {
        return false;
    }

    public boolean newPage() throws DocumentException {
        return this.open;
    }

    public void setHeader(HeaderFooter headerFooter) {
    }

    public void resetHeader() {
    }

    public void setFooter(HeaderFooter headerFooter) {
    }

    public void resetFooter() {
    }

    public void resetPageCount() {
    }

    public void setPageCount(int n) {
    }

    public void close() {
        this.open = false;
        try {
            this.os.flush();
            this.os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void pause() {
        this.pause = true;
    }

    public void resume() {
        this.pause = false;
    }

    public void flush() {
        try {
            this.os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void write(String string) throws IOException {
        this.os.write(string.getBytes());
    }
}

