/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.web.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.contentcapture.ContentCapture;
import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.imps.PlaybackTimeListener;
import com.elluminate.groupware.imps.view.ViewAPI;
import com.elluminate.groupware.imps.view.ViewMode;
import com.elluminate.groupware.imps.view.ViewModeEvent;
import com.elluminate.groupware.imps.view.ViewModeListener;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.module.PermissionFeatureFactory;
import com.elluminate.groupware.web.WebDebug;
import com.elluminate.groupware.web.module.PublishWebTourURLToChatCmd;
import com.elluminate.groupware.web.module.StartWebTourCmd;
import com.elluminate.groupware.web.module.StopWebTourCmd;
import com.elluminate.groupware.web.module.StringsProperties;
import com.elluminate.groupware.web.module.WebBean;
import com.elluminate.groupware.web.module.WebPublisher;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.VersionManager;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

@Singleton
public class WebModule
extends AbstractClientModule
implements PreferencesPanelOwner,
ModulePublisherInfo,
PlaybackTimeListener,
PropertyChangeListener,
ViewModeListener {
    private FeatureBroker broker;
    private ClientProvider clientProvider;
    private final String prefix = this.getClass().getName();
    private I18n i18n = I18n.create((Object)this);
    private ClientList clients = null;
    private WebBean webBean = null;
    private Provider<WebBean> beanProvider;
    private Imps imps;
    private ContentCapture contentCapture;
    private CRSession session;
    private Preferences preferences;
    private PermissionFeatureFactory permissionFeatureFactory;
    private ConferencingEngine confEngine;
    private Provider<StartWebTourCmd> startWebTourCmd;
    private Provider<StopWebTourCmd> stopWebTourCmd;
    private Provider<PublishWebTourURLToChatCmd> publishWebTourURLToChatCmd;
    private WebPublisher msgPublisher;
    private Logger logger;

    @Inject
    public void initContentCaptureProvider(ContentCaptureProvider contentCaptureProvider) {
        this.contentCapture = contentCaptureProvider.get();
    }

    @Inject
    protected void initPermissionFeatureFactory(PermissionFeatureFactory permissionFeatureFactory) {
        this.permissionFeatureFactory = permissionFeatureFactory;
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
    }

    @Inject
    protected void initPreferences(Preferences prefs) {
        this.preferences = prefs;
    }

    @Inject
    public void initConferencingEngine(ConferencingEngine ce) {
        this.confEngine = ce;
    }

    @Inject
    public void initStartWebTourCmd(Provider<StartWebTourCmd> cp) {
        this.startWebTourCmd = cp;
    }

    @Inject
    public void initStopWebTourCmd(Provider<StopWebTourCmd> cp) {
        this.stopWebTourCmd = cp;
    }

    @Inject
    public void initPublishWebTourURLToChatCmd(Provider<PublishWebTourURLToChatCmd> cp) {
        this.publishWebTourURLToChatCmd = cp;
    }

    @Inject
    public void initWebPublisher(WebPublisher pub) {
        this.msgPublisher = pub;
    }

    @Inject
    public void initLogger(Logger logger) {
        this.logger = logger;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getTitle() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.WEBMODULE_TITLE);
    }

    public Icon getIcon() {
        return this.i18n.getIcon((PropertiesEnum)StringsProperties.WEBMODULE_ICON);
    }

    @Inject
    protected void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    protected void initClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Inject
    protected void initVersionManager(VersionManager versionManager) {
        versionManager.registerComponent((Object)this);
    }

    @Inject
    protected void initWebBeanProvider(Provider<WebBean> bp) {
        this.beanProvider = bp;
    }

    @Inject
    protected void initImps(Imps imps) {
        this.imps = imps;
    }

    public void setupUI() {
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "setupUI", "entered");
        }
        this.webBean.setupFeatures();
        this.webBean.publishBrowserControlFeatures(true);
        BooleanFeature bf = this.permissionFeatureFactory.createPermissionFeature((Object)this, "WebTourPermission", "/web/webTourPermission", this.i18n.getString((PropertiesEnum)StringsProperties.WEBMODULE_MENUTITLE), "WebTour", this.i18n);
        bf.setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.WEBMODULE_MENUTITLE_ACCESSIBLENAME));
        this.session.registerAnnotation("WebTourActivityAnnotation", (Object)0);
        this.session.registerAnnotation("WebTourLagAnnotation", (Object)0);
    }

    public void cleanupUI() {
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "cleanupUI", "entered");
        }
        this.session.deRegisterAnnotation("WebTourLagAnnotation");
        this.session.deRegisterAnnotation("WebTourActivityAnnotation");
        this.webBean.publishBrowserControlFeatures(false);
        this.webBean.cleanupFeatures();
    }

    public String getDisplayNameOfModule() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.WEBMODULE_TITLE);
    }

    public Icon getModuleIcon() {
        return this.getIcon();
    }

    public String getNameOfModule() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.WEBMODULE_TITLE);
    }

    protected WebBean getWebBean() {
        return (WebBean)this.beanProvider.get();
    }

    public void start() {
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "start", "entered");
        }
        this.confEngine.registerCommand(this.startWebTourCmd);
        this.confEngine.registerCommand(this.stopWebTourCmd);
        this.confEngine.registerCommand(this.publishWebTourURLToChatCmd);
        ViewAPI api = (ViewAPI)this.imps.findBest(ViewAPI.class);
        if (api != null) {
            api.addViewModeListener((ViewModeListener)this);
        }
    }

    public void stop() {
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "stop", "entered");
        }
    }

    public void attach() {
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "attach", "entered");
        }
        this.webBean = (WebBean)this.beanProvider.get();
        this.webBean.loadPreferences(this.prefix, this.preferences);
        Client theClient = this.clientProvider.get();
        this.clients = theClient.getClientList();
        this.webBean.addPropertyChangeListener(this);
        this.clients.addClientListener(new ClientListener(){

            public void onRemoveClient(ClientEvent e) {
            }

            public void onAddClient(ClientEvent e) {
                if (e.isMe()) {
                    WebModule.this.clients.getMyClient().addPropertyChangeListener("webTourFloor", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            WebModule.this.sendWebTourEnabledStatusUpdateMessage((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
                        }
                    });
                }
            }
        });
        this.webBean.setClient(theClient);
    }

    protected void sendWebTourEnabledStatusUpdateMessage(Boolean oldValue, Boolean newValue) {
        if (oldValue != newValue && newValue != null) {
            this.msgPublisher.sendEnabledStatusChangeMessage(newValue);
        }
    }

    public void detach() {
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "detach", "entered");
        }
        if (this.webBean != null) {
            this.webBean.dispose();
            this.webBean = null;
        }
        this.clients.removePropertyChangeListener("chair", (PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("state")) {
            if (WebDebug.TRACE.show()) {
                this.logger.message((Object)this, "propertyChange", "state changed from " + e.getOldValue() + " to " + e.getNewValue());
            }
            if (this.webBean == null) {
                return;
            }
            switch (this.webBean.getState()) {
                case 2: {
                    if (!this.contentCapture.isEchoingData() || this.webBean.getInitState() == -1 || !this.webBean.isWebModeratorCheck()) break;
                    this.webBean.enableSomeBrowserControlFeatures(true);
                    break;
                }
                case 3: {
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    public void resetSession() {
    }

    public void setLinearity(PlaybackTimeListener.Linearity linearity) {
        WebBean wb = this.webBean;
        if (wb != null) {
            wb.setNonLinear(linearity != PlaybackTimeListener.Linearity.REALTIME);
        }
    }

    public void modeChanged(ViewModeEvent event) {
        ViewMode to = event.getNewMode();
        ViewMode from = event.getOldMode();
        if (to != ViewMode.WEBTOUR && from != ViewMode.WEBTOUR) {
            return;
        }
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "modeChanged", "switch was self-initiated?" + this.isSelfInitiated(event.getInitiator()));
        }
        this.webBean.handleModeSwitch(to == ViewMode.WEBTOUR, this.isSelfInitiated(event.getInitiator()));
    }

    private boolean isSelfInitiated(short addr) {
        return this.clients.getMyClient().getAddress() == addr;
    }
}

