/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.web.module;

import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.StartWebTourCommand;
import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.imps.view.ViewAPI;
import com.elluminate.groupware.imps.view.ViewMode;
import com.elluminate.groupware.imps.view.ViewModeEvent;
import com.elluminate.groupware.imps.view.ViewModeListener;
import com.elluminate.groupware.web.module.StringsProperties;
import com.elluminate.groupware.web.module.WebBean;
import com.elluminate.groupware.web.module.WebModule;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.net.MalformedURLException;

public class StartWebTourCmd
extends AbstractCommand
implements StartWebTourCommand {
    private static final long serialVersionUID = 1L;
    private String url = null;
    private ViewAPI viewApi = null;
    private WebBean bean = null;
    private ViewMode viewMode;
    private String pushURL = null;
    private Imps imps;
    @Inject
    private I18n i18n;
    @Inject
    private WebModule module;
    ViewModeListener viewModeListener = new ViewModeListener(){

        public void modeChanged(ViewModeEvent event) {
            StartWebTourCmd.this.viewMode = StartWebTourCmd.this.viewApi.getMode();
            if (StartWebTourCmd.this.viewMode == ViewMode.WEBTOUR && StartWebTourCmd.this.pushURL != null) {
                StartWebTourCmd.this.url = StartWebTourCmd.this.pushURL;
                StartWebTourCmd.this.pushURL = null;
                if (StartWebTourCmd.this.bean.getInitState() != 1) {
                    StartWebTourCmd.this.bean.pushURL(StartWebTourCmd.this.url);
                } else if (StartWebTourCmd.this.bean.getState() == 0) {
                    StartWebTourCmd.this.bean.openURL(StartWebTourCmd.this.url);
                } else {
                    StartWebTourCmd.this.bean.goToURL(StartWebTourCmd.this.url);
                }
            }
        }
    };

    public void initModule() {
    }

    @Inject
    void initImps(Imps imps) {
        this.imps = imps;
    }

    public void setURL(String url) {
        this.url = url;
    }

    protected void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        if (this.url == null || this.url.length() < 1) {
            throw new CommandParameterException("URL parameter must be set", this.i18n.getString((PropertiesEnum)StringsProperties.WEBTOURCMD_BADPARAMURLNOTSET));
        }
        if (this.bean == null) {
            this.bean = this.module.getWebBean();
        }
        try {
            this.url = this.bean.checkURL(this.url);
        }
        catch (MalformedURLException ex) {
            throw new CommandParameterException("Invalid URL: " + this.url, this.i18n.getString((PropertiesEnum)StringsProperties.WEBTOURCMD_BADPARAMURLINVALID, new Object[]{this.url}));
        }
        if (this.viewApi == null) {
            this.viewApi = (ViewAPI)this.imps.findBest(ViewAPI.class);
            if (this.viewApi != null) {
                this.viewApi.addViewModeListener(this.viewModeListener);
                this.viewMode = this.viewApi.getMode();
            }
        }
        this.pushURL = this.url;
        if (this.viewApi != null && this.viewMode != ViewMode.WEBTOUR) {
            this.viewApi.requestMode(ViewMode.WEBTOUR);
        } else {
            this.viewModeListener.modeChanged(null);
        }
    }
}

