/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx.client;

import com.elluminate.jinx.client.ClientAuthenticator;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SimpleClientAuthenticator
implements ClientAuthenticator {
    private String name = null;
    private String pass = null;

    public SimpleClientAuthenticator(String name, String pass) {
        this.name = name;
        this.pass = pass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getResponse(int version, String name, String challenge, String device) {
        String response;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            if (version == 512) {
                data.writeChars(device);
            }
            data.writeChars(challenge);
            data.writeChars(this.pass);
            data.close();
        }
        catch (IOException ex) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            response = this.toHex(digest.digest(bytes.toByteArray()));
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
        return response;
    }

    private String toHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(Character.forDigit(bytes[i] >> 4 & 0xF, 16));
            buf.append(Character.forDigit(bytes[i] & 0xF, 16));
        }
        return buf.toString();
    }
}

