/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.calculator.module;

import com.elluminate.groupware.calculator.CoordPair;
import com.elluminate.groupware.calculator.CoordSpace;
import com.elluminate.groupware.calculator.Function;
import com.elluminate.groupware.calculator.GraphModel;
import com.elluminate.groupware.calculator.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class Graph
extends JPanel
implements PropertyChangeListener {
    public static final int ClickNone = 0;
    public static final int ClickZoomIn = 1;
    public static final int ClickZoomOut = 2;
    public static final int ClickSetMark = 3;
    public static final int DragNone = 0;
    public static final int DragZoom = 1;
    public static final int DragPan = 2;
    public static final int DragIntersect = 3;
    private static final double CurveMargin = 1.0;
    private static final double IntersectionMargin = 0.001;
    private I18n i18n = I18n.create((Object)this);
    private Image image = null;
    private int imageHeight = 10;
    private int imageWidth = 10;
    private boolean replot = true;
    private GraphModel model = null;
    private boolean trace = false;
    private int clickAction = 0;
    private int dragAction = 0;
    private Point dragPoint = null;
    private CoordPair dragCenter = null;
    private Color markColor = new Color(0, 100, 0);
    private Rectangle dragSelect = null;

    public Graph() {
        this.image = this.createImage(this.imageWidth, this.imageHeight);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Graph.this.graphMouseMoved(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Graph.this.graphMouseDragged(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Graph.this.graphMouseClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Graph.this.graphMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Graph.this.graphMouseReleased(e);
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.replot = true;
        this.repaint();
    }

    public void setModel(GraphModel newModel) {
        if (this.model != null) {
            this.model.setDragging(false);
            this.model.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.model = newModel;
        if (this.model != null) {
            this.model.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.replot = true;
        this.repaint();
    }

    public int getClickAction() {
        return this.clickAction;
    }

    public void setClickAction(int action) {
        if (action < 0 || action > 3) {
            throw new IllegalArgumentException("Invalid click action value - " + action);
        }
        this.clickAction = action;
    }

    public int getDragAction() {
        return this.clickAction;
    }

    public void setDragAction(int action) {
        if (action < 0 || action > 3) {
            throw new IllegalArgumentException("Invalid drag action value - " + action);
        }
        this.dragAction = action;
    }

    public boolean isTracing() {
        return this.trace;
    }

    public void setTracing(boolean state) {
        this.trace = state;
    }

    @Override
    public void paint(Graphics g) {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        this.plotCheck();
        if (this.image == null) {
            return;
        }
        Border b = this.getBorder();
        if (b != null) {
            Insets insets = b.getBorderInsets(this);
            g.drawImage(this.image, insets.left, insets.top, null);
            b.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
            this.paintSelect(g);
        } else {
            g.drawImage(this.image, 0, 0, null);
            this.paintSelect(g);
        }
    }

    public void paintSelect(Graphics g) {
        if (this.dragSelect != null) {
            g.setXORMode(Color.darkGray);
            g.drawRect((int)Math.round(this.dragSelect.getMinX()), (int)Math.round(this.dragSelect.getMinY()), this.dragSelect.width, this.dragSelect.height);
            g.setPaintMode();
        }
    }

    public void plotCheck() {
        Border b = this.getBorder();
        int w = this.getWidth();
        int h = this.getHeight();
        if (b != null) {
            Insets insets = b.getBorderInsets(this);
            w -= insets.left + insets.right;
            h -= insets.top + insets.bottom;
        }
        if (w < 1 || h < 1) {
            return;
        }
        if (this.imageWidth != w || this.imageHeight != h) {
            this.imageWidth = w;
            this.imageHeight = h;
            this.image = this.createImage(w, h);
            this.replot = true;
        }
        if (this.replot) {
            this.plot();
            this.replot = false;
        }
    }

    public void plot() {
        Graphics g = this.image.getGraphics();
        g.setColor(new Color(0xE0E0E0));
        g.fillRect(0, 0, this.imageWidth, this.imageHeight);
        g.setColor(new Color(0xC0C0C0));
        this.drawGrid(g);
        g.setColor(Color.black);
        this.drawAxis(g);
        if (this.model == null) {
            return;
        }
        for (int i = 0; i < this.model.getFunctionCount(); ++i) {
            Function f = this.model.getFunction(i);
            Color c = this.model.getFunctionColor(i);
            if (!this.model.isFunctionVisible(i) || f == null) continue;
            g.setColor(c);
            this.plotFunction(g, f);
        }
        this.drawMark(g);
        g.dispose();
    }

    private void drawGrid(Graphics g) {
        int loc;
        double at;
        boolean drawHorizontal = true;
        boolean drawVertical = true;
        if (this.model == null || !this.model.isGridVisible()) {
            return;
        }
        double spacing = this.model.getGridSpacing();
        CoordSpace space = this.model.getCoordSpace();
        double minX = space.getMinX();
        double maxX = space.getMaxX();
        double minY = space.getMinY();
        double maxY = space.getMaxY();
        if (space.getXRange() / spacing > (double)(this.imageWidth / 2)) {
            drawVertical = false;
        }
        if (space.getYRange() / spacing > (double)(this.imageHeight / 2)) {
            drawHorizontal = false;
        }
        for (at = this.getGridStart(minX, maxX, spacing); drawVertical && (at < maxX || -at > minX); at += spacing) {
            if (at < maxX && at > minX) {
                loc = this.xCoordToPixel(at);
                g.drawLine(loc, 0, loc, this.imageHeight);
            }
            if (!(-at < maxX) || !(-at > minX)) continue;
            loc = this.xCoordToPixel(-at);
            g.drawLine(loc, 0, loc, this.imageHeight);
        }
        for (at = this.getGridStart(minY, maxY, spacing); drawHorizontal && (at < maxY || -at > minY); at += spacing) {
            if (at < maxY && at > minY) {
                loc = this.yCoordToPixel(at);
                g.drawLine(0, loc, this.imageWidth, loc);
            }
            if (!(-at < maxY) || !(-at > minY)) continue;
            loc = this.yCoordToPixel(-at);
            g.drawLine(0, loc, this.imageWidth, loc);
        }
    }

    private double getGridStart(double min, double max, double spacing) {
        if (min < 0.0 && max > 0.0) {
            return spacing;
        }
        double minAbs = min < 0.0 ? -min : min;
        double maxAbs = max < 0.0 ? -max : max;
        double lower = minAbs < maxAbs ? minAbs : maxAbs;
        return (double)((int)((lower - spacing) / spacing)) * spacing;
    }

    private void drawAxis(Graphics g) {
        int loc;
        if (this.model == null) {
            return;
        }
        CoordSpace space = this.model.getCoordSpace();
        if (space.getMinX() <= 0.0 && space.getMaxX() >= 0.0) {
            loc = this.xCoordToPixel(0.0);
            g.drawLine(loc, 0, loc, this.imageHeight);
        }
        if (space.getMinY() <= 0.0 && space.getMaxY() >= 0.0) {
            loc = this.yCoordToPixel(0.0);
            g.drawLine(0, loc, this.imageWidth, loc);
        }
    }

    private void plotFunction(Graphics g, Function f) {
        CoordSpace space = this.model.getCoordSpace();
        double prevY = f.setVariable("x", space.getMinX());
        int prevPY = this.yCoordToPixel(prevY);
        int w = this.imageWidth;
        int h = this.imageHeight;
        for (int px = 1; px < w; ++px) {
            double x = this.xPixelToCoord(px);
            double y = f.setVariable("x", x);
            int py = this.yCoordToPixel(y);
            boolean draw = true;
            if (Double.isNaN(y) || Double.isNaN(prevY)) {
                draw = false;
            } else if (Double.isInfinite(y) || Double.isInfinite(prevY)) {
                draw = false;
            } else if (Math.abs(y - prevY) > 50.0) {
                double prevX = this.xPixelToCoord(px - 1);
                double midX = (x + prevX) / 2.0;
                double midY = f.setVariable("x", midX);
                draw = this.between(midY, prevY, y, 1.0);
            }
            if (!(!draw || prevPY > h && py > h || prevPY < 0 && py < 0)) {
                int y1 = prevPY < 0 ? -1 : Math.min(prevPY, h - 1);
                int y2 = py < 0 ? -1 : Math.min(py, h - 1);
                g.drawLine(px - 1, y1, px, y2);
            }
            prevY = y;
            prevPY = py;
        }
    }

    private void drawMark(Graphics g) {
        CoordPair mark = this.model.getMark();
        CoordSpace space = this.model.getCoordSpace();
        if (mark == null) {
            return;
        }
        if (!space.contains(mark)) {
            return;
        }
        String label = this.i18n.getString((PropertiesEnum)StringsProperties.GRAPH_TOOLTIP, new Object[]{new Double(mark.x), new Double(mark.y)});
        int x = this.xCoordToPixel(mark.x);
        int y = this.yCoordToPixel(mark.y);
        g.setColor(this.markColor);
        g.drawLine(x, y, x, y);
        g.drawLine(x - 8, y - 8, x - 2, y - 2);
        g.drawLine(x - 8, y + 8, x - 2, y + 2);
        g.drawLine(x + 8, y - 8, x + 2, y - 2);
        g.drawLine(x + 8, y + 8, x + 2, y + 2);
        if (label != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Font f = g.getFont();
            FontMetrics fm = toolkit.getFontMetrics(f);
            Rectangle2D bounds = fm.getStringBounds(label, g);
            int width = (int)Math.round(bounds.getWidth());
            int height = (int)Math.round(bounds.getHeight());
            switch (space.getQuadrant(mark)) {
                case 0: {
                    x -= width + 10;
                    y += height + 10;
                    break;
                }
                case 1: {
                    x -= width + 10;
                    y -= 10;
                    break;
                }
                case 2: {
                    x += 10;
                    y += height + 10;
                    break;
                }
                case 3: {
                    x += 10;
                    y -= 10;
                }
            }
            g.drawString(label, x, y);
        }
    }

    void graphMouseClicked(MouseEvent e) {
        CoordSpace space = this.model.getCoordSpace();
        CoordPair coords = this.getCoordinates(e.getPoint());
        double xRange = space.getXRange();
        double yRange = space.getYRange();
        switch (this.clickAction) {
            case 1: {
                CoordSpace newSpace = new CoordSpace(coords.x - xRange / 4.0, coords.x + xRange / 4.0, coords.y - yRange / 4.0, coords.y + yRange / 4.0);
                this.model.setCoordSpace(newSpace);
                break;
            }
            case 2: {
                CoordSpace newSpace = new CoordSpace(coords.x - xRange, coords.x + xRange, coords.y - yRange, coords.y + yRange);
                this.model.setCoordSpace(newSpace);
                break;
            }
            case 3: {
                if ((e.getModifiers() & 0x10) != 0) {
                    this.model.setMark(coords);
                    break;
                }
                this.model.setMark(null);
            }
        }
    }

    void graphMouseMoved(MouseEvent e) {
        if (this.trace) {
            CoordPair coords = this.getCoordinates(e.getPoint());
            this.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.GRAPH_TOOLTIP, new Object[]{new Double(coords.x), new Double(coords.y)}));
        }
    }

    void graphMousePressed(MouseEvent e) {
        if (this.dragAction != 0) {
            CoordSpace space = this.model.getCoordSpace();
            this.dragPoint = e.getPoint();
            this.dragCenter = space.getCenter();
        }
    }

    void graphMouseReleased(MouseEvent e) {
        if (this.model.isDragging()) {
            switch (this.dragAction) {
                case 1: {
                    if (!(this.dragPoint.distance(e.getPoint()) > 3.0)) break;
                    CoordPair where = this.getCoordinates(e.getPoint());
                    CoordSpace space = new CoordSpace(this.getCoordinates(this.dragPoint), where);
                    this.model.setCoordSpace(space);
                    break;
                }
                case 3: {
                    Rectangle rect = new Rectangle(this.dragPoint);
                    rect.add(e.getPoint());
                    CoordPair where = this.findIntersection(rect);
                    this.model.setMark(where);
                }
            }
            this.model.setDragging(false);
            this.repaint();
        }
        this.dragPoint = null;
        this.dragCenter = null;
        this.dragSelect = null;
    }

    void graphMouseDragged(MouseEvent e) {
        if (this.dragAction == 0) {
            return;
        }
        if (this.dragPoint == null) {
            return;
        }
        CoordSpace space = this.model.getCoordSpace();
        Point mouse = e.getPoint();
        int deltaX = this.dragPoint.x - mouse.x;
        int deltaY = mouse.y - this.dragPoint.y;
        double xRange = space.getXRange();
        double yRange = space.getYRange();
        CoordPair center = new CoordPair();
        this.model.setDragging(true);
        switch (this.dragAction) {
            case 2: {
                center.x = this.dragCenter.x + xRange * (double)deltaX / (double)this.imageWidth;
                center.y = this.dragCenter.y + yRange * (double)deltaY / (double)this.imageHeight;
                CoordSpace newSpace = new CoordSpace(center.x - xRange / 2.0, center.x + xRange / 2.0, center.y - yRange / 2.0, center.y + yRange / 2.0);
                this.model.setCoordSpace(newSpace);
                break;
            }
            case 1: 
            case 3: {
                this.dragSelect = new Rectangle(this.dragPoint);
                this.dragSelect.add(mouse);
                this.repaint();
            }
        }
    }

    private CoordPair findIntersection(Rectangle rect) {
        int i;
        CoordPair intersection = null;
        CoordPair xIntercept = null;
        CoordPair yIntercept = null;
        CoordPair approximation = null;
        double approxError = 0.0;
        double approxMargin = this.model.getCoordSpace().getYRange() / 1000.0;
        Border b = this.getBorder();
        int delta = 0;
        int minX = (int)Math.round(rect.getMinX());
        int maxX = (int)Math.round(rect.getMaxX());
        double[] prevY = null;
        double[] thisY = null;
        double prevX = Double.NaN;
        int n = 0;
        Function[] func = null;
        if (approxMargin > 0.001) {
            approxMargin = 0.001;
        }
        for (i = 0; i < this.model.getFunctionCount(); ++i) {
            if (!this.model.isFunctionVisible(i) || this.model.getFunction(i) == null) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        prevY = new double[n];
        thisY = new double[n];
        func = new Function[n];
        int f = 0;
        for (i = 0; i < this.model.getFunctionCount(); ++i) {
            if (!this.model.isFunctionVisible(i) || this.model.getFunction(i) == null) continue;
            func[f] = this.model.getFunction(i);
            thisY[f] = Double.NaN;
            prevY[f] = Double.NaN;
            ++f;
        }
        if (b != null) {
            Insets insets = b.getBorderInsets(this);
            delta = insets.top;
            minX -= insets.left;
            maxX -= insets.left;
        }
        double minY = this.yPixelToCoord((int)Math.round(rect.getMaxY()) - delta);
        double maxY = this.yPixelToCoord((int)Math.round(rect.getMinY()) - delta);
        if (this.xPixelToCoord(minX) <= 0.0 && this.xPixelToCoord(maxX) >= 0.0) {
            for (f = 0; f < n; ++f) {
                double y = func[f].setVariable("x", 0.0);
                if (!(y <= maxY) || !(y >= minY)) continue;
                yIntercept = new CoordPair(0.0, y);
                break;
            }
        }
        boolean checkX = minY <= 0.0 && maxY >= 0.0;
        for (i = minX; i <= maxX; ++i) {
            double x = this.xPixelToCoord(i);
            for (f = 0; f < n; ++f) {
                prevY[f] = thisY[f];
                thisY[f] = func[f].setVariable("x", x);
                if (xIntercept == null && checkX) {
                    if (thisY[f] == 0.0) {
                        xIntercept = new CoordPair(x, 0.0);
                    } else {
                        double checkY;
                        xIntercept = this.getIntersection(prevX, x, 0.0, 0.0, prevY[f], thisY[f], minY, maxY);
                        if (xIntercept != null && !this.between(checkY = func[f].setVariable("x", xIntercept.x), prevY[f], thisY[f], 0.0)) {
                            xIntercept = null;
                        }
                    }
                }
                for (int g = 0; g < f; ++g) {
                    intersection = this.getIntersection(prevX, x, prevY[g], thisY[g], prevY[f], thisY[f], minY, maxY);
                    if (intersection != null) {
                        double checkY1 = func[f].setVariable("x", intersection.x);
                        double checkY2 = func[g].setVariable("x", intersection.x);
                        if (!this.between(checkY1, prevY[f], thisY[f], 1.0)) {
                            intersection = null;
                        } else if (!this.between(checkY2, prevY[g], thisY[g], 1.0)) {
                            intersection = null;
                        }
                    }
                    if (intersection != null) {
                        return intersection;
                    }
                    int p1 = this.yCoordToPixel(thisY[f]);
                    int p2 = this.yCoordToPixel(thisY[g]);
                    double err = Math.abs(thisY[f] - thisY[g]);
                    if (p1 != p2 || !(err < approxMargin) || !(thisY[f] >= minY) || !(thisY[f] <= maxY) || approximation != null && !(err < approxError)) continue;
                    approximation = new CoordPair(x, thisY[f]);
                    approxError = err;
                }
            }
            prevX = x;
        }
        if (approximation != null) {
            return approximation;
        }
        if (xIntercept != null) {
            return xIntercept;
        }
        return yIntercept;
    }

    private boolean between(double value, double from, double to, double margin) {
        if (Double.isNaN(value)) {
            return false;
        }
        if (value < Math.min(from, to) - margin) {
            return false;
        }
        return !(value > Math.max(from, to) + margin);
    }

    private CoordPair getIntersection(double x1, double x2, double l1y1, double l1y2, double l2y1, double l2y2, double minY, double maxY) {
        double x = Double.NaN;
        double y = Double.NaN;
        if (Double.isNaN(x1) || Double.isNaN(x2)) {
            return null;
        }
        if (l1y1 == l2y1) {
            x = x1;
            y = l1y1;
        } else if (l1y2 == l2y2) {
            x = x2;
            y = l1y2;
        } else if (l1y1 < l2y1 && l1y2 > l2y2 || l1y1 > l2y1 && l1y2 < l2y2) {
            double dx = x2 - x1;
            double s1 = (l1y2 - l1y1) / dx;
            double s2 = (l2y2 - l2y1) / dx;
            double i1 = l1y1 - s1 * x1;
            double i2 = l2y1 - s2 * x1;
            x = (i2 - i1) / (s1 - s2);
            y = s1 * x + i1;
        }
        if (Double.isNaN(y)) {
            return null;
        }
        if (y < minY || y > maxY) {
            return null;
        }
        return new CoordPair(x, y);
    }

    private int yCoordToPixel(double y) {
        CoordSpace space = this.model.getCoordSpace();
        double offset = y - space.getMinY();
        double pixelDouble = (double)this.imageHeight * offset / space.getYRange();
        double MAXY = 32767.0;
        double MINY = -32768.0;
        int pixel = (int)Math.min(32767.0, Math.max(pixelDouble, -32768.0));
        return this.imageHeight - pixel;
    }

    private int xCoordToPixel(double x) {
        CoordSpace space = this.model.getCoordSpace();
        double offset = x - space.getMinX();
        int pixel = (int)((double)this.imageWidth * offset / space.getXRange());
        return pixel;
    }

    private double yPixelToCoord(int pixel) {
        CoordSpace space = this.model.getCoordSpace();
        int h = this.imageHeight;
        return (double)(h - pixel) * space.getYRange() / (double)h + space.getMinY();
    }

    private double xPixelToCoord(int pixel) {
        CoordSpace space = this.model.getCoordSpace();
        return (double)pixel * space.getXRange() / (double)this.imageWidth + space.getMinX();
    }

    public CoordPair getCoordinates(Point p) {
        CoordPair coords = new CoordPair();
        int x = p.x;
        int y = p.y;
        Border b = this.getBorder();
        if (b != null) {
            Insets i = b.getBorderInsets(this);
            x -= i.left;
            y -= i.top;
        }
        coords.x = this.xPixelToCoord(x);
        coords.y = this.yPixelToCoord(y);
        return coords;
    }

    public static String coordToString(double v) {
        DecimalFormat fmt = new DecimalFormat("######0.0000");
        String str = fmt.format(v);
        return str;
    }
}

