/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.chair.module;

import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermission;
import com.elluminate.framework.session.CRPermissionDelegate;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRPermissionChangeListener;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEvent;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEventType;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.chair.ChairDebug;
import com.elluminate.groupware.chair.module.ChairBean;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ChairPermissionDelegate
implements CRPermissionDelegate,
PropertyChangeListener {
    private ListenerRegistry<CRPermissionChangeListener> listenerRegistry;
    private ChairProtocol chairProtocol;
    private ClientProvider clientProvider;
    private CRSession session;
    private ChairBean chairBean;
    private Object lockSet;
    private Logger logger;

    @Inject
    public ChairPermissionDelegate(Logger logger) {
        this.logger = logger;
        this.lockSet = null;
    }

    @Inject
    protected void initListenerRegistry(ListenerRegistry<CRPermissionChangeListener> listenerRegistry) {
        this.listenerRegistry = listenerRegistry;
    }

    public ChairProtocol getChairProtocol() {
        return this.chairProtocol;
    }

    public void setChairProtocol(ChairProtocol chairProtocol) {
        this.chairProtocol = chairProtocol;
    }

    public ClientProvider getClientProvider() {
        return this.clientProvider;
    }

    public void setClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    public ChairBean getChairBean() {
        return this.chairBean;
    }

    public void setChairBean(ChairBean chairBean) {
        this.chairBean = chairBean;
    }

    public CRSession getSession() {
        return this.session;
    }

    public void setSession(CRSession session) {
        this.session = session;
    }

    private Client getClient() {
        return this.clientProvider != null ? this.clientProvider.get() : null;
    }

    private CRParticipant getMe() {
        return this.session != null ? this.session.getMe() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(CRPermissionChangeListener listener) {
        ListenerRegistry<CRPermissionChangeListener> listenerRegistry = this.listenerRegistry;
        synchronized (listenerRegistry) {
            this.listenerRegistry.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(CRPermissionChangeListener listener) {
        ListenerRegistry<CRPermissionChangeListener> listenerRegistry = this.listenerRegistry;
        synchronized (listenerRegistry) {
            this.listenerRegistry.remove((Object)listener);
        }
    }

    public String getPropertyName() {
        return "chair";
    }

    private void firePermissionChanged(final CRPermissionChangeEvent event, final boolean isDefaultPermissionChanged) {
        FiringFunctor<CRPermissionChangeListener> ff = null;
        ff = new FiringFunctor<CRPermissionChangeListener>(){

            public void fire(CRPermissionChangeListener listener) {
                if (isDefaultPermissionChanged) {
                    listener.onPermissionDefaultChange(event);
                } else {
                    listener.onPermissionValueChange(event);
                }
            }
        };
        this.listenerRegistry.fire((FiringFunctor)ff);
    }

    public boolean getValue(short id) {
        boolean isChair = false;
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "getValue", "get value: id = " + id);
        }
        if (this.isInitialized()) {
            Chair chair = this.chairProtocol.fetchChair((Connection)this.getClient());
            isChair = chair.contains(id);
            if (ChairDebug.TRACE.show()) {
                this.logger.message((Object)this, "getValue", "isChair = " + isChair);
            }
        }
        if (!isChair) {
            isChair = this.getDefault();
        }
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "getValue", "return[isChair] = " + isChair);
        }
        return isChair;
    }

    public synchronized void setValue(CRPermission permission, boolean newValue) {
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "setValue", "setValue: " + permission + " " + newValue);
        }
        if (permission != null && this.canMeSet()) {
            while (this.lockSet != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            this.lockSet = newValue;
            Chair chair = this.chairProtocol.fetchChair((Connection)this.getClient());
            boolean oldValue = chair.contains(permission.getID());
            if (ChairDebug.TRACE.show()) {
                this.logger.message((Object)this, "setValue", "oldValue = " + oldValue);
            }
            boolean isChanged = false;
            if (oldValue != newValue) {
                ClientInfo who = this.getClient().getClientList().get(permission.getID());
                isChanged = newValue ? this.chairBean.giveChair(who, this.getConfirm()) : this.chairBean.takeChair(who);
            }
            if (!isChanged) {
                this.lockSet = null;
            }
        }
    }

    public synchronized void setValue(List<CRPermission> permissions, boolean newValue) {
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "setValue", "permissions.size = " + (permissions != null ? permissions.size() : 0) + " " + newValue);
        }
        if (this.canMeSet() && permissions != null && permissions.size() > 0) {
            while (this.lockSet != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            this.lockSet = newValue;
            ArrayList<ClientInfo> clientInfoList = new ArrayList<ClientInfo>(permissions.size());
            for (CRPermission p : permissions) {
                ClientInfo who = this.getClient().getClientList().get(p.getID());
                if (who == null) continue;
                clientInfoList.add(who);
            }
            Chair chair = this.chairProtocol.fetchChair((Connection)this.getClient());
            if (newValue) {
                chair.add(clientInfoList.toArray(new ClientInfo[clientInfoList.size()]));
            } else {
                chair.remove(clientInfoList.toArray(new ClientInfo[clientInfoList.size()]));
            }
        }
    }

    public boolean globalPermissionSupported() {
        return false;
    }

    public boolean getDefault() {
        return false;
    }

    public synchronized void setDefault(CRPermission permission, boolean newValue) {
    }

    public boolean canSet(short id) {
        return this.canMeSet();
    }

    public boolean canSetDefault(short id) {
        return this.canMeSet();
    }

    private void firePermissionChanged(CRPermission permission, boolean oldValue, boolean value, boolean isDefaultPermissionChanged) {
        CRPermissionChangeEvent event = null;
        if (!oldValue && value) {
            event = new CRPermissionChangeEvent(permission, CRPermissionChangeEventType.FALSE_TO_TRUE);
        } else if (oldValue && !value) {
            event = new CRPermissionChangeEvent(permission, CRPermissionChangeEventType.TRUE_TO_FALSE);
        } else {
            return;
        }
        this.firePermissionChanged(event, isDefaultPermissionChanged);
    }

    private boolean getConfirm() {
        CRParticipant me = this.getMe();
        return me != null;
    }

    private boolean isInitialized() {
        return this.getChairBean() != null && this.getClient() != null;
    }

    private boolean canMeSet() {
        CRParticipant me = this.getMe();
        boolean canSet = this.isInitialized();
        if (me != null) {
            Chair chair = this.chairProtocol.fetchChair((Connection)this.getClient());
            canSet = chair.contains(me.getID());
        } else {
            canSet = true;
        }
        return canSet;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChanged(evt, "chair");
    }

    private synchronized void firePropertyChanged(PropertyChangeEvent event, String property) {
        String name = event.getPropertyName();
        boolean isDefaultPermissionChanged = false;
        if (name.equals(property)) {
            short id;
            Short newchair;
            Short oldchair;
            int i$;
            int len$;
            short[] arr$;
            short[] oldList = (short[])event.getOldValue();
            short[] newList = (short[])event.getNewValue();
            if (ChairDebug.TRACE.show()) {
                this.logger.message((Object)this, "firePropertyChanged", "oldList = " + (oldList != null ? Integer.valueOf(oldList.length) : null) + "\nnewList = " + (newList != null ? Integer.valueOf(newList.length) : null));
            }
            if (newList == null) {
                return;
            }
            ArrayList<Short> oldChairs = new ArrayList<Short>();
            ArrayList<Short> newChairs = new ArrayList<Short>();
            if (oldList != null && oldList.length > newList.length) {
                arr$ = oldList;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    oldchair = arr$[i$];
                    oldChairs.add(oldchair);
                }
                arr$ = newList;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    newchair = arr$[i$];
                    oldChairs.remove(newchair);
                }
                if (ChairDebug.TRACE.show()) {
                    this.logger.message((Object)this, "firePropertyChange", "removed: " + oldChairs);
                }
            } else if (oldList != null && oldList.length < newList.length) {
                arr$ = newList;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    newchair = arr$[i$];
                    newChairs.add(newchair);
                }
                arr$ = oldList;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    oldchair = arr$[i$];
                    newChairs.remove(oldchair);
                }
                if (ChairDebug.TRACE.show()) {
                    this.logger.message((Object)this, "firePropertyChange", "added: " + newChairs);
                }
            } else if (oldList == null && 0 < newList.length) {
                arr$ = newList;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    newchair = arr$[i$];
                    newChairs.add(newchair);
                }
                if (ChairDebug.TRACE.show()) {
                    this.logger.message((Object)this, "firePropertyChange", "added: " + newChairs);
                }
            }
            Iterator i$2 = oldChairs.iterator();
            while (i$2.hasNext()) {
                id = (Short)i$2.next();
                CRPermission permission = this.session.getPermission("ChairPermission", id);
                if (permission == null) continue;
                this.firePermissionChanged(permission, Boolean.TRUE, Boolean.FALSE, false);
            }
            i$2 = newChairs.iterator();
            while (i$2.hasNext()) {
                id = (Short)i$2.next();
                CRPermission permission = this.session.getPermission("ChairPermission", id);
                if (permission == null) continue;
                this.firePermissionChanged(permission, Boolean.FALSE, Boolean.TRUE, false);
            }
            this.lockSet = null;
            this.notifyAll();
        }
    }
}

