/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module.event;

import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaAction;
import com.elluminate.groupware.agenda.AgendaFile;
import com.elluminate.groupware.agenda.AgendaItem;
import java.util.EventObject;

public class AgendaValidatorEvent
extends EventObject {
    public static final int PROBLEM_FOUND = 1;
    public static final int PROBLEM_RESOLVED = 2;
    public static final int TYPE_QUOTA_EXCEEDED = 11;
    public static final int TYPE_COMMAND_NOT_SPECIFIED = 12;
    public static final int TYPE_COMMAND_INVALID = 13;
    public static final int TYPE_PARAMETER_NOT_SPECIFIED = 14;
    public static final int TYPE_PARAMETER_INVALID = 15;
    public static final int TYPE_PARAMETER_FILE_INVALID = 16;
    public static final int TYPE_PARAMETER_URL_INVALID = 17;
    public static final int TYPE_PARAMETER_FILE_TYPE_INVALID = 18;
    public static final int TYPE_PARAMETER_PHONE_NUMBER_INVALID = 19;
    public static final int TYPE_PARAMETER_PHONE_SIP_INVALID = 20;
    public static final int TYPE_PARAMETER_PHONE_PIN_INVALID = 21;
    public static final int TYPE_PARAMETER_LIST_VALUE_INVALID = 22;
    public static final int TYPE_PARAMETER_INTEGER_INVALID = 23;
    public static final int TYPE_PARAMETER_INTEGER_TOO_SMALL = 24;
    public static final int TYPE_PARAMETER_INTEGER_TOO_LARGE = 25;
    public static final int TYPE_ITEM_DISABLED = 41;
    public static final int TYPE_ITEM_DEACTIVATED = 42;
    public static final int TYPE_FILE_NOT_LOADED = 43;
    private int id;
    private Agenda agenda;
    private AgendaItem item;
    private int problem;
    private Object culprit;

    public AgendaValidatorEvent(Object source, int id, Agenda agenda, AgendaItem item, int problem, Object culprit) {
        super(source);
        this.id = id;
        this.agenda = agenda;
        this.item = item;
        this.problem = problem;
        this.culprit = culprit;
    }

    public int getID() {
        return this.id;
    }

    public Agenda getAgenda() {
        return this.agenda;
    }

    public AgendaItem getItem() {
        return this.item;
    }

    public int getProblem() {
        return this.problem;
    }

    public Object getCulprit() {
        return this.culprit;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getName());
        b.append('[');
        b.append("id=");
        switch (this.id) {
            case 1: {
                b.append("PROBLEM_FOUND");
                break;
            }
            case 2: {
                b.append("PROBLEM_RESOLVED");
            }
        }
        b.append(",agenda=");
        b.append(this.agenda.getName());
        if (this.item != null) {
            b.append(",item=");
            if (this.item instanceof AgendaFile) {
                b.append(((AgendaFile)this.item).getName());
            } else if (this.item instanceof AgendaAction) {
                b.append(((AgendaAction)this.item).getDescription());
            } else {
                b.append(this.item);
            }
        }
        if (this.problem > 0) {
            b.append(",problem=");
            switch (this.problem) {
                case 11: {
                    b.append("TYPE_QUOTA_EXCEEDED");
                    break;
                }
                case 12: {
                    b.append("TYPE_COMMAND_NOT_SPECIFIED");
                    break;
                }
                case 13: {
                    b.append("TYPE_COMMAND_INVALID");
                    break;
                }
                case 14: {
                    b.append("TYPE_PARAMETER_NOT_SPECIFIED");
                    break;
                }
                case 15: {
                    b.append("TYPE_PARAMETER_INVALID");
                    break;
                }
                case 16: {
                    b.append("TYPE_PARAMETER_FILE_INVALID");
                    break;
                }
                case 17: {
                    b.append("TYPE_PARAMETER_URL_INVALID");
                    break;
                }
                case 18: {
                    b.append("TYPE_PARAMETER_FILE_TYPE_INVALID");
                    break;
                }
                case 19: {
                    b.append("TYPE_PARAMETER_PHONE_NUMBER_INVALID");
                    break;
                }
                case 20: {
                    b.append("TYPE_PARAMETER_PHONE_SIP_INVALID");
                    break;
                }
                case 21: {
                    b.append("TYPE_PARAMETER_PHONE_PIN_INVALID");
                    break;
                }
                case 22: {
                    b.append("TYPE_PARAMETER_LIST_VALUE_INVALID");
                    break;
                }
                case 23: {
                    b.append("TYPE_PARAMETER_INTEGER_INVALID");
                    break;
                }
                case 24: {
                    b.append("TYPE_PARAMETER_INTEGER_TOO_SMALL");
                    break;
                }
                case 25: {
                    b.append("TYPE_PARAMETER_INTEGER_TOO_LARGE");
                    break;
                }
                case 41: {
                    b.append("TYPE_ITEM_DISABLED");
                    break;
                }
                case 42: {
                    b.append("TYPE_ITEM_DEACTIVATED");
                    break;
                }
                case 43: {
                    b.append("TYPE_FILE_NOT_LOADED");
                }
            }
        }
        if (this.culprit != null) {
            b.append(",culprit=");
            if (this.culprit instanceof AgendaFile) {
                b.append(((AgendaFile)this.culprit).getName());
            } else if (this.culprit instanceof AgendaAction) {
                b.append(((AgendaAction)this.culprit).getDescription());
            } else if (this.culprit instanceof Class) {
                b.append(((Class)this.culprit).getName());
            } else {
                b.append(this.culprit);
            }
        }
        b.append(']');
        return b.toString();
    }
}

