/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import com.elluminate.groupware.agenda.module.AgendaPreferences;
import com.elluminate.groupware.agenda.module.StringsProperties;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.CColorPicker;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

@Singleton
public class ViewerOptionsPrefsPanel
extends AbstractPreferencesPanel {
    private I18n i18n;
    private JCheckBox openDisplaysAgendaBox;
    private JCheckBox viewActivatesAgendaBox;
    private JCheckBox executeBackwardBox;
    private JCheckBox executeRandomlyBox;
    private JCheckBox clickCurrentsNodeBox;
    private JCheckBox suppressActionErrorsBox;
    private CColorPicker coveredNodeColorPicker;
    private CColorPicker actionHyperlinkColorPicker;

    @Inject
    public ViewerOptionsPrefsPanel(PreferencesPanelOwner owner, I18n i18n) {
        super(owner, i18n.getString((PropertiesEnum)StringsProperties.VIEWEROPTIONS_TITLE));
        this.i18n = i18n;
    }

    protected void createContent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 5;
        gbc.weightx = 100.0;
        gbc.insets.left = 0;
        this.openDisplaysAgendaBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.VIEWEROPTIONS_OPENDISPLAYSAGENDABOX));
        this.openDisplaysAgendaBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewerOptionsPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.openDisplaysAgendaBox, gbc);
        ++gbc.gridy;
        gbc.insets.top = 6;
        gbc.gridx = 0;
        gbc.gridwidth = 5;
        gbc.weightx = 100.0;
        gbc.insets.left = 0;
        this.viewActivatesAgendaBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.VIEWEROPTIONS_VIEWACTIVATESAGENDABOX));
        this.viewActivatesAgendaBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewerOptionsPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.viewActivatesAgendaBox, gbc);
        ++gbc.gridy;
        gbc.insets.top = 6;
        gbc.gridx = 0;
        gbc.gridwidth = 5;
        gbc.weightx = 100.0;
        gbc.insets.left = 0;
        this.executeBackwardBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.VIEWEROPTIONS_EXECUTENODESBACKWARDBOX));
        this.executeBackwardBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewerOptionsPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.executeBackwardBox, gbc);
        ++gbc.gridy;
        gbc.insets.top = 6;
        gbc.gridx = 0;
        gbc.gridwidth = 5;
        gbc.weightx = 100.0;
        gbc.insets.left = 0;
        this.executeRandomlyBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.VIEWEROPTIONS_EXECUTENODESRANDOMLYBOX));
        this.executeRandomlyBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewerOptionsPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.executeRandomlyBox, gbc);
        ++gbc.gridy;
        gbc.insets.top = 6;
        gbc.gridx = 0;
        gbc.gridwidth = 5;
        gbc.weightx = 100.0;
        gbc.insets.left = 0;
        this.clickCurrentsNodeBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.VIEWEROPTIONS_CLICKCURRENTSNODEBOX));
        this.clickCurrentsNodeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewerOptionsPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.clickCurrentsNodeBox, gbc);
        ++gbc.gridy;
        gbc.insets.top = 6;
        gbc.gridx = 0;
        gbc.gridwidth = 5;
        gbc.weightx = 100.0;
        gbc.insets.left = 0;
        this.suppressActionErrorsBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.VIEWEROPTIONS_SUPPRESSACTIONERRORSBOX));
        this.suppressActionErrorsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewerOptionsPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.suppressActionErrorsBox, gbc);
        ++gbc.gridy;
        gbc.insets.top = 6;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        this.add(new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.VIEWEROPTIONS_COVEREDITEMCOLORLABEL)), gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 3;
        gbc.weightx = 100.0;
        gbc.insets.left = 6;
        this.coveredNodeColorPicker = new CColorPicker();
        this.coveredNodeColorPicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("color")) {
                    ViewerOptionsPrefsPanel.this.setModified(true);
                }
            }
        });
        this.add((Component)this.coveredNodeColorPicker, gbc);
        ++gbc.gridy;
        gbc.insets.top = 6;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        this.add(new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.VIEWEROPTIONS_ACTIONHYPERLINKCOLORLABEL)), gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 3;
        gbc.weightx = 100.0;
        gbc.insets.left = 6;
        this.actionHyperlinkColorPicker = new CColorPicker();
        this.actionHyperlinkColorPicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("color")) {
                    ViewerOptionsPrefsPanel.this.setModified(true);
                }
            }
        });
        this.add((Component)this.actionHyperlinkColorPicker, gbc);
    }

    protected void populate(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        this.openDisplaysAgendaBox.setSelected(AgendaPreferences.isOpenFunctionDisplaysAgenda(prefix, preferences));
        this.viewActivatesAgendaBox.setSelected(AgendaPreferences.isViewFunctionActivatesAgenda(prefix, preferences));
        this.executeBackwardBox.setSelected(AgendaPreferences.isProgressingBackwardExecutesNodes(prefix, preferences));
        this.executeRandomlyBox.setSelected(AgendaPreferences.isProgressingRandomlyExecutesNodes(prefix, preferences));
        this.clickCurrentsNodeBox.setSelected(AgendaPreferences.isClickingNodeMarksAsCurrent(prefix, preferences));
        this.suppressActionErrorsBox.setSelected(AgendaPreferences.isSuppressActionErrors(prefix, preferences));
        this.coveredNodeColorPicker.setColor(AgendaPreferences.getCoveredNodeColor(prefix, preferences));
        this.actionHyperlinkColorPicker.setColor(AgendaPreferences.getActionHyperlinkColor(prefix, preferences));
    }

    protected void apply(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        boolean selected = this.openDisplaysAgendaBox.isSelected();
        AgendaPreferences.setOpenFunctionDisplaysAgenda(prefix, preferences, selected);
        selected = this.viewActivatesAgendaBox.isSelected();
        AgendaPreferences.setViewFunctionActivatesAgenda(prefix, preferences, selected);
        selected = this.executeBackwardBox.isSelected();
        AgendaPreferences.setProgressingBackwardExecutesNodes(prefix, preferences, selected);
        selected = this.executeRandomlyBox.isSelected();
        AgendaPreferences.setProgressingRandomlyExecutesNodes(prefix, preferences, selected);
        selected = this.clickCurrentsNodeBox.isSelected();
        AgendaPreferences.setClickingNodeMarksAsCurrent(prefix, preferences, selected);
        selected = this.suppressActionErrorsBox.isSelected();
        AgendaPreferences.setSuppressActionErrors(prefix, preferences, selected);
        Color color = this.coveredNodeColorPicker.getColor();
        if (color != null) {
            AgendaPreferences.setCoveredNodeColor(prefix, preferences, color);
        }
        if ((color = this.actionHyperlinkColorPicker.getColor()) != null) {
            AgendaPreferences.setActionHyperlinkColor(prefix, preferences, color);
        }
    }

    protected void reset(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        AgendaPreferences.setOpenFunctionDisplaysAgenda(prefix, preferences, true);
        AgendaPreferences.setViewFunctionActivatesAgenda(prefix, preferences, true);
        AgendaPreferences.setProgressingBackwardExecutesNodes(prefix, preferences, true);
        AgendaPreferences.setProgressingRandomlyExecutesNodes(prefix, preferences, false);
        AgendaPreferences.setClickingNodeMarksAsCurrent(prefix, preferences, true);
        AgendaPreferences.setSuppressActionErrors(prefix, preferences, false);
        AgendaPreferences.setCoveredNodeColor(prefix, preferences, AgendaPreferences.COVERED_NODE_COLOR_DEFAULT);
        AgendaPreferences.setActionHyperlinkColor(prefix, preferences, AgendaPreferences.ACTION_HYPERLINK_COLOR_DEFAULT);
    }
}

