/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import com.elluminate.engine.ConferencingEngine;
import com.elluminate.engine.command.LoadFileCommand;
import com.elluminate.engine.command.LoadMultimediaCommand;
import com.elluminate.engine.command.LoadWhiteboardCommand;
import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaAction;
import com.elluminate.groupware.agenda.AgendaExecutable;
import com.elluminate.groupware.agenda.AgendaFile;
import com.elluminate.groupware.agenda.AgendaItem;
import com.elluminate.groupware.agenda.AgendaNode;
import com.elluminate.groupware.agenda.AgendaUtils;
import com.elluminate.groupware.agenda.event.AgendaAdapter;
import com.elluminate.groupware.agenda.event.AgendaEvent;
import com.elluminate.groupware.agenda.event.AgendaListener;
import com.elluminate.groupware.agenda.module.Actions;
import com.elluminate.groupware.agenda.module.action.ActionDependency;
import com.elluminate.groupware.agenda.module.action.ActionInfo;
import com.elluminate.groupware.agenda.module.action.ActionParameter;
import com.elluminate.groupware.agenda.module.action.ActionParameterValue;
import com.elluminate.groupware.agenda.module.event.AgendaValidatorEvent;
import com.elluminate.groupware.agenda.module.event.AgendaValidatorListener;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.TelephonyUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.event.EventListenerList;

public final class AgendaValidator
extends AgendaAdapter {
    private EmbeddedContentProvider contentProvider;
    private ConferencingEngine commandEngine;
    private long transferQuota = 0L;
    private long multimediaQuota = 0L;
    private long whiteboardQuota = 0L;
    private ArrayList agendas = new ArrayList();
    private HashMap agendaProperties = new HashMap();
    private LightweightTimer delayedChecker = new LightweightTimer(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AgendaValidator agendaValidator = AgendaValidator.this;
            synchronized (agendaValidator) {
                ((Object)((Object)AgendaValidator.this)).notify();
            }
        }
    });
    private EventListenerList listenerList = new EventListenerList();

    public AgendaValidator() {
        this(null);
    }

    public AgendaValidator(EmbeddedContentProvider contentProvider) {
        this.contentProvider = contentProvider;
        ValidatorThread th = new ValidatorThread();
        th.start();
    }

    public void setCommandEngine(ConferencingEngine commandEngine) {
        this.commandEngine = commandEngine;
    }

    public void setTransferQuota(long quota) {
        this.transferQuota = quota;
        this.recheckQuotas(LoadFileCommand.class);
    }

    public long getTransferQuota() {
        return this.transferQuota;
    }

    public void setMultimediaQuota(long quota) {
        this.multimediaQuota = quota;
        this.recheckQuotas(LoadMultimediaCommand.class);
    }

    public long getMultimediaQuota() {
        return this.multimediaQuota;
    }

    public void setWhiteboardQuota(long quota) {
        this.whiteboardQuota = quota;
        this.recheckQuotas(LoadWhiteboardCommand.class);
    }

    public long getWhiteboardQuota() {
        return this.whiteboardQuota;
    }

    public synchronized void monitor(Agenda agenda) {
        if (this.agendas.contains(agenda)) {
            return;
        }
        this.agendas.add(agenda);
        this.agendaProperties.put(agenda, new AgendaProperties(agenda));
        agenda.addAgendaListener((AgendaListener)this);
        this.queueCheck(agenda, 1, null, null);
    }

    public synchronized void stopMonitoring(Agenda agenda) {
        agenda.removeAgendaListener((AgendaListener)this);
        this.agendas.remove(agenda);
        this.agendaProperties.remove(agenda);
    }

    public AgendaValidatorEvent[] getProblems(Agenda agenda) {
        AgendaProperties props = (AgendaProperties)this.agendaProperties.get(agenda);
        if (props != null) {
            return props.getAgendaProblems();
        }
        return null;
    }

    public AgendaValidatorEvent[] getProblems(AgendaItem item) {
        AgendaProperties props = (AgendaProperties)this.agendaProperties.get(item.getParentAgenda());
        if (props != null) {
            return props.getItemProblems(item);
        }
        return null;
    }

    private synchronized void queueCheck(Agenda agenda, int checkTypes, AgendaItem item, Class commandInterface) {
        AgendaProperties props = (AgendaProperties)this.agendaProperties.get(agenda);
        if (props != null) {
            Check ch = new Check(checkTypes, item, commandInterface);
            if (props.addCheck(ch)) {
                this.agendas.remove(agenda);
                this.agendas.add(0, agenda);
            }
            this.delayedChecker.scheduleIn(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recheckQuotas(Class commandInterface) {
        ArrayList arrayList = this.agendas;
        synchronized (arrayList) {
            for (Agenda ag : this.agendas) {
                this.queueCheck(ag, 2, null, commandInterface);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recheckIntegerLimits(Class commandInterface) {
        ArrayList arrayList = this.agendas;
        synchronized (arrayList) {
            for (Agenda ag : this.agendas) {
                this.queueCheck(ag, 4, null, commandInterface);
            }
        }
    }

    public void addAgendaValidatorListener(AgendaValidatorListener l) {
        this.listenerList.add(AgendaValidatorListener.class, l);
    }

    public void addAgendaValidatorListener(Agenda agenda, AgendaValidatorListener l) {
        this.listenerList.add(AgendaSpecificListener.class, new AgendaSpecificListener(agenda, l));
    }

    public void removeAgendaValidatorListener(AgendaValidatorListener l) {
        this.listenerList.remove(AgendaValidatorListener.class, l);
    }

    public void removeAgendaValidatorListener(Agenda agenda, AgendaValidatorListener l) {
        AgendaSpecificListener[] sls = (AgendaSpecificListener[])this.listenerList.getListeners(AgendaSpecificListener.class);
        for (int i = 0; i < sls.length; ++i) {
            AgendaSpecificListener sl = sls[i];
            if (sl.agenda != agenda || sl.listener != l) continue;
            this.listenerList.remove(AgendaSpecificListener.class, sl);
            break;
        }
    }

    private void fireAgendaValidatorEvent(AgendaValidatorEvent e) {
        Object[] ls = this.listenerList.getListenerList();
        block4: for (int i = ls.length - 2; i >= 0; i -= 2) {
            AgendaValidatorListener l = null;
            if (ls[i] == AgendaValidatorListener.class) {
                l = (AgendaValidatorListener)ls[i + 1];
            } else if (ls[i] == AgendaSpecificListener.class) {
                AgendaSpecificListener sl = (AgendaSpecificListener)ls[i + 1];
                if (sl.agenda == e.getAgenda()) {
                    l = sl.listener;
                }
            }
            if (l == null) continue;
            switch (e.getID()) {
                case 1: {
                    l.problemFound(e);
                    continue block4;
                }
                case 2: {
                    l.problemResolved(e);
                }
            }
        }
    }

    public static CompatibilityReport checkCompatibility(Agenda agenda) {
        CompatibilityReport rep = new CompatibilityReport();
        float vers = agenda.getVersion();
        if (vers > 1.0f) {
            rep.setUnsupportedVersion(vers);
        }
        for (int i = 0; i < agenda.getNodeCount(); ++i) {
            AgendaNode node = agenda.getNode(i);
            if (!(node instanceof AgendaAction)) continue;
            AgendaValidator.checkKnownCommands((AgendaExecutable)((AgendaAction)node), rep);
        }
        return rep;
    }

    private static void checkKnownCommands(AgendaExecutable executable, CompatibilityReport report) {
        String cmd = executable.getCommandName();
        if (cmd != null && Actions.getAction(cmd) == null) {
            report.addUnknownCommand(executable);
        }
        if (executable instanceof AgendaAction) {
            AgendaAction act = (AgendaAction)executable;
            for (int i = 0; i < act.getActionCount(); ++i) {
                AgendaValidator.checkKnownCommands((AgendaExecutable)act.getAction(i), report);
            }
        }
    }

    public void itemAdded(AgendaEvent e) {
        Agenda ag = e.getAgenda();
        AgendaItem it = e.getItem();
        if (it instanceof AgendaFile) {
            this.queueCheck(ag, 58, it, null);
        } else if (it instanceof AgendaAction && !((AgendaAction)it).isCompoundAction()) {
            this.queueCheck(ag, 58, it, null);
        }
    }

    public void itemRemoved(AgendaEvent e) {
        Agenda ag = e.getAgenda();
        AgendaItem it = e.getItem();
        if (it instanceof AgendaFile) {
            this.queueCheck(ag, 34, it, null);
        } else if (it instanceof AgendaAction && !((AgendaAction)it).isCompoundAction()) {
            this.queueCheck(ag, 34, it, null);
        }
    }

    public void itemPropertyChanged(AgendaEvent e) {
        String prop;
        Agenda ag = e.getAgenda();
        AgendaItem it = e.getItem();
        if (it instanceof AgendaFile) {
            String prop2 = e.getProperty();
            if (prop2.equals("command") || prop2.startsWith("parameter")) {
                this.queueCheck(ag, 58, it, null);
            }
        } else if (it instanceof AgendaAction && !((AgendaAction)it).isCompoundAction() && ((prop = e.getProperty()).equals("command") || prop.startsWith("parameter"))) {
            this.queueCheck(ag, 58, it, null);
        }
    }

    private class AgendaProperties {
        private Agenda agenda;
        private ArrayList checkQueue = new ArrayList();
        private HashMap problems = new HashMap();

        private AgendaProperties(Agenda agenda) {
            this.agenda = agenda;
        }

        public boolean addCheck(Check check) {
            AgendaItem it;
            if (check.getTypes() != 1 && (it = check.getItem()) != null) {
                for (Check ch : this.checkQueue) {
                    if (ch.getItem() != it) continue;
                    return ch.addTypes(check.getTypes());
                }
            }
            this.checkQueue.add(check);
            return true;
        }

        public Check popFirstCheck() {
            if (this.checkQueue.size() != 0) {
                return (Check)this.checkQueue.remove(0);
            }
            return null;
        }

        public void setQuotaProblem(int problem, Object culprit) {
            this.setProblem(null, problem, culprit, 0);
        }

        public void setCommandProblem(AgendaItem item, int problem, Object culprit) {
            this.setProblem(item, problem, culprit, 1);
        }

        public void setDependencyProblem(AgendaItem item, int problem, Object culprit) {
            this.setProblem(item, problem, culprit, 2);
        }

        private void setProblem(AgendaItem item, int problem, Object culprit, int kind) {
            if (problem != -1) {
                Problems probs = (Problems)this.problems.get(item);
                if (probs == null) {
                    probs = new Problems();
                    this.problems.put(item, probs);
                }
                AgendaValidatorEvent e = new AgendaValidatorEvent((Object)AgendaValidator.this, 1, this.agenda, item, problem, culprit);
                switch (kind) {
                    case 0: {
                        if (e.equals(probs.quotaProblem)) break;
                        probs.quotaProblem = e;
                        AgendaValidator.this.fireAgendaValidatorEvent(e);
                        break;
                    }
                    case 1: {
                        if (e.equals(probs.commandProblem)) break;
                        probs.commandProblem = e;
                        AgendaValidator.this.fireAgendaValidatorEvent(e);
                        break;
                    }
                    case 2: {
                        if (e.equals(probs.dependencyProblem)) break;
                        probs.dependencyProblem = e;
                        AgendaValidator.this.fireAgendaValidatorEvent(e);
                    }
                }
            } else {
                AgendaValidatorEvent e = null;
                Problems probs = (Problems)this.problems.get(item);
                if (probs != null) {
                    switch (kind) {
                        case 0: {
                            if (probs.quotaProblem == null) break;
                            e = probs.quotaProblem;
                            probs.quotaProblem = null;
                            break;
                        }
                        case 1: {
                            if (probs.commandProblem == null) break;
                            e = probs.commandProblem;
                            probs.commandProblem = null;
                            break;
                        }
                        case 2: {
                            if (probs.dependencyProblem == null) break;
                            e = probs.dependencyProblem;
                            probs.dependencyProblem = null;
                        }
                    }
                    if (probs.areResolved()) {
                        this.problems.remove(item);
                    }
                    if (e != null) {
                        e = new AgendaValidatorEvent((Object)AgendaValidator.this, 2, e.getAgenda(), e.getItem(), e.getProblem(), e.getCulprit());
                        AgendaValidator.this.fireAgendaValidatorEvent(e);
                    }
                }
            }
        }

        public AgendaValidatorEvent[] getAgendaProblems() {
            return this.getProblems(null);
        }

        public AgendaValidatorEvent[] getItemProblems(AgendaItem item) {
            return this.getProblems(item);
        }

        private AgendaValidatorEvent[] getProblems(Object object) {
            Problems probs = (Problems)this.problems.get(object);
            if (probs != null) {
                ArrayList<AgendaValidatorEvent> l = new ArrayList<AgendaValidatorEvent>();
                if (probs.quotaProblem != null) {
                    l.add(probs.quotaProblem);
                }
                if (probs.commandProblem != null) {
                    l.add(probs.commandProblem);
                }
                if (probs.dependencyProblem != null) {
                    l.add(probs.dependencyProblem);
                }
                if (l.size() != 0) {
                    return l.toArray(new AgendaValidatorEvent[0]);
                }
            }
            return null;
        }

        private class Problems {
            public AgendaValidatorEvent quotaProblem;
            public AgendaValidatorEvent commandProblem;
            public AgendaValidatorEvent dependencyProblem;

            private Problems() {
            }

            public boolean areResolved() {
                return this.quotaProblem == null && this.commandProblem == null && this.dependencyProblem == null;
            }
        }
    }

    private class AgendaSpecificListener
    implements EventListener {
        public Agenda agenda;
        public AgendaValidatorListener listener;

        public AgendaSpecificListener(Agenda agenda, AgendaValidatorListener l) {
            this.agenda = agenda;
            this.listener = l;
        }
    }

    private static class Check {
        public static final int EVERYTHING = 1;
        public static final int LOAD_QUOTA = 2;
        public static final int INTEGER_LIMITS = 4;
        public static final int COMMAND_OF = 8;
        public static final int DEPENDENCIES_OF = 16;
        public static final int DEPENDENCIES_ON = 32;
        private int types;
        private AgendaItem item;
        private Class commandInterface;

        public Check(int types, AgendaItem item, Class commandInterface) {
            this.types = types;
            this.item = item;
            this.commandInterface = commandInterface;
        }

        public boolean addTypes(int types) {
            boolean alreadySet = true;
            for (int i = 0; i < 32; ++i) {
                if ((types >> i & 1) != 1 || (this.types >> i & 1) != 0) continue;
                alreadySet = false;
                break;
            }
            if (alreadySet) {
                return false;
            }
            this.types |= types;
            return true;
        }

        public int getTypes() {
            return this.types;
        }

        public AgendaItem getItem() {
            return this.item;
        }

        public Class getCommandInterface() {
            return this.commandInterface;
        }
    }

    public static class CompatibilityReport {
        private float unsupportedVersion = -1.0f;
        private ArrayList unknownCommands = new ArrayList();

        public void setUnsupportedVersion(float unsupportedVersion) {
            this.unsupportedVersion = unsupportedVersion;
        }

        public boolean isUnsupportedVersion() {
            return this.unsupportedVersion >= 0.0f;
        }

        public void addUnknownCommand(AgendaExecutable unknownCommand) {
            this.unknownCommands.add(unknownCommand);
        }

        public boolean hasUnknownCommands() {
            return this.unknownCommands.size() != 0;
        }
    }

    private static class DependencyState {
        public boolean activatedSet = false;
        public boolean enabledSet = false;
        public boolean activated;
        public boolean enabled;
        public int reason = 0;
        public Object culprit = null;

        public DependencyState(boolean activated, boolean enabled) {
            this.activated = activated;
            this.enabled = enabled;
        }
    }

    public static interface EmbeddedContentProvider {
        public boolean fileContainsQuiz(AgendaFile var1, String var2);

        public boolean fileContainsScreen(AgendaFile var1, String var2);
    }

    private class ValidatorThread
    extends Thread {
        public ValidatorThread() {
            super("Agenda Validator");
            this.setPriority(5);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    if (this.processNextCheck()) {
                        continue;
                    }
                    AgendaValidator agendaValidator = AgendaValidator.this;
                    synchronized (agendaValidator) {
                        ((Object)((Object)AgendaValidator.this)).wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processNextCheck() {
            Check ch;
            Agenda ag;
            AgendaValidator agendaValidator = AgendaValidator.this;
            synchronized (agendaValidator) {
                if (AgendaValidator.this.agendas.size() == 0) {
                    return false;
                }
                ag = (Agenda)AgendaValidator.this.agendas.get(0);
                AgendaProperties props = (AgendaProperties)AgendaValidator.this.agendaProperties.get(ag);
                ch = props.popFirstCheck();
                if (ch == null) {
                    return false;
                }
            }
            this.processCheck(ag, ch);
            return true;
        }

        private void processCheck(Agenda agenda, Check check) {
            AgendaProperties props = (AgendaProperties)AgendaValidator.this.agendaProperties.get(agenda);
            int types = check.getTypes();
            if (types == 1) {
                this.checkEverything(agenda, props);
            } else {
                AgendaItem it = check.getItem();
                Class cmd = check.getCommandInterface();
                if (cmd != null) {
                    if ((types & 2) != 0) {
                        this.validateQuota(agenda, cmd, props);
                    }
                    if ((types & 4) != 0) {
                        this.checkInteger(agenda, cmd, props);
                    }
                } else if (it instanceof AgendaFile) {
                    AgendaFile f = (AgendaFile)it;
                    if ((types & 2) != 0) {
                        this.checkQuota(agenda, (AgendaExecutable)f, props);
                    }
                    if ((types & 8) != 0) {
                        this.validateFileCommand(agenda, f, props);
                    }
                    if ((types & 0x10) != 0) {
                        this.validateFileDependency(agenda, f, props);
                    }
                    if ((types & 0x20) != 0) {
                        this.checkDependenciesOnFile(agenda, f, props);
                    }
                } else if (it instanceof AgendaAction) {
                    AgendaAction act = (AgendaAction)it;
                    if ((types & 2) != 0) {
                        this.checkQuota(agenda, (AgendaExecutable)act, props);
                    }
                    if ((types & 8) != 0) {
                        this.validateActionCommand(agenda, act, props);
                    }
                    if ((types & 0x10) != 0) {
                        this.validateActionDependencies(agenda, act, props);
                    }
                    if ((types & 0x20) != 0) {
                        this.checkDependenciesOnAction(agenda, act, props);
                    }
                }
            }
        }

        private void checkEverything(Agenda agenda, AgendaProperties properties) {
            this.validateQuota(agenda, LoadFileCommand.class, properties);
            this.validateQuota(agenda, LoadMultimediaCommand.class, properties);
            this.validateQuota(agenda, LoadWhiteboardCommand.class, properties);
            AgendaFile[] fs = agenda.getFiles();
            for (int i = 0; i < fs.length; ++i) {
                AgendaFile f = fs[i];
                this.validateFileCommand(agenda, f, properties);
                this.validateFileDependency(agenda, f, properties);
            }
            AgendaNode n = agenda.getFirstNode();
            while (n != null) {
                if (n instanceof AgendaAction) {
                    AgendaAction act = (AgendaAction)n;
                    this.validateActionCommand(agenda, act, properties);
                    this.validateActionDependencies(agenda, act, properties);
                }
                n = agenda.getNodeAfter(n, true);
            }
        }

        private void checkDependenciesOnFile(Agenda agenda, AgendaFile file, AgendaProperties properties) {
            AgendaNode n = agenda.getFirstNode();
            while (n != null) {
                AgendaAction act;
                ActionInfo a;
                if (n instanceof AgendaAction && (a = Actions.getAction((act = (AgendaAction)n).getCommandName())) != null) {
                    this.validateActionCommand(agenda, act, properties);
                    this.validateActionDependencies(agenda, act, properties);
                }
                n = agenda.getNodeAfter(n, true);
            }
        }

        private void checkDependenciesOnAction(Agenda agenda, AgendaAction action, AgendaProperties properties) {
            ActionInfo a = Actions.getAction(action.getCommandName());
            if (a != null && a.isLoadAction()) {
                AgendaFile[] fs = agenda.getFiles();
                for (int i = 0; i < fs.length; ++i) {
                    AgendaFile f = fs[i];
                    this.validateFileDependency(agenda, f, properties);
                }
            }
            AgendaNode n = agenda.getFirstNode();
            while (n != null) {
                if (n instanceof AgendaAction) {
                    AgendaAction act = (AgendaAction)n;
                    this.validateActionDependencies(agenda, act, properties);
                }
                n = agenda.getNodeAfter(n, true);
            }
        }

        private void validateQuota(Agenda agenda, Class commandInterface, AgendaProperties properties) {
            long quota = 0L;
            if (commandInterface == LoadFileCommand.class) {
                quota = AgendaValidator.this.transferQuota;
            } else if (commandInterface == LoadMultimediaCommand.class) {
                quota = AgendaValidator.this.multimediaQuota;
            } else if (commandInterface == LoadWhiteboardCommand.class) {
                quota = AgendaValidator.this.whiteboardQuota;
            }
            if (quota > 0L) {
                ActionInfo a;
                long total = 0L;
                for (int i = 0; i < agenda.getFileCount(); ++i) {
                    AgendaFile f = agenda.getFile(i);
                    if (!f.isAutoload() || (a = Actions.getAction(f.getCommandName())).getCommandInterface() != commandInterface) continue;
                    total += new File(f.getPath()).length();
                }
                AgendaNode n = agenda.getFirstNode();
                while (n != null) {
                    AgendaFile f;
                    String fileName;
                    AgendaAction act;
                    if (n instanceof AgendaAction && (a = Actions.getAction((act = (AgendaAction)n).getCommandName())) != null && a.getCommandInterface() == commandInterface && (fileName = act.getCommandParameter("file")) != null && (f = agenda.getFileByName(fileName)) != null) {
                        total += new File(f.getPath()).length();
                    }
                    n = agenda.getNodeAfter(n, true);
                }
                if (total > quota) {
                    properties.setQuotaProblem(11, commandInterface);
                    return;
                }
            }
            properties.setQuotaProblem(-1, null);
        }

        private void checkQuota(Agenda agenda, AgendaExecutable executable, AgendaProperties properties) {
            String cmdName = executable.getCommandName();
            if (cmdName == null || cmdName.length() == 0) {
                return;
            }
            ActionInfo a = Actions.getAction(cmdName);
            if (a == null || !a.isLoadAction()) {
                return;
            }
            this.validateQuota(agenda, a.getCommandInterface(), properties);
        }

        private void checkInteger(Agenda agenda, Class commandInterface, AgendaProperties properties) {
            ActionInfo a;
            for (int i = 0; i < agenda.getFileCount(); ++i) {
                AgendaFile f = agenda.getFile(i);
                a = null;
                String cmd = f.getCommandName();
                if (cmd != null && cmd.length() != 0) {
                    a = Actions.getAction(cmd);
                }
                if (a == null || a.getCommandInterface() != commandInterface) continue;
                ActionParameter[] params = a.getParameters();
                for (int j = 0; j < params.length; ++j) {
                    ActionParameter param = params[j];
                    if (param.getType() != 2) continue;
                    String val = f.getCommandParameter(param.getName());
                    this.validateInteger(agenda, (AgendaExecutable)f, param.getName(), val, properties);
                }
            }
            AgendaNode n = agenda.getFirstNode();
            while (n != null) {
                AgendaAction act;
                if (n instanceof AgendaAction && (a = Actions.getAction((act = (AgendaAction)n).getCommandName())) != null && a.getCommandInterface() == commandInterface) {
                    ActionParameter[] params = a.getParameters();
                    for (int j = 0; j < params.length; ++j) {
                        ActionParameter param = params[j];
                        if (param.getType() != 2) continue;
                        String val = act.getCommandParameter(param.getName());
                        this.validateInteger(agenda, (AgendaExecutable)act, param.getName(), val, properties);
                    }
                }
                n = agenda.getNodeAfter(n, true);
            }
        }

        private void validateFileDependency(Agenda agenda, AgendaFile file, AgendaProperties properties) {
            if (!file.isAutoload()) {
                boolean resolved = false;
                AgendaNode n = agenda.getFirstNode();
                while (n != null) {
                    if (n instanceof AgendaAction && this.resolveFileDependenciesAgainst(agenda, file, (AgendaAction)n)) {
                        resolved = true;
                        break;
                    }
                    n = agenda.getNodeAfter(n, true);
                }
                if (!resolved) {
                    properties.setDependencyProblem((AgendaItem)file, 43, null);
                    return;
                }
            }
            properties.setDependencyProblem((AgendaItem)file, -1, null);
        }

        private void validateActionDependencies(Agenda agenda, AgendaAction action, AgendaProperties properties) {
            ActionInfo a = null;
            String cmd = action.getCommandName();
            if (cmd != null && cmd.length() != 0) {
                a = Actions.getAction(cmd);
            }
            if (a != null && (a.requiresActivation() || a.requiresEnabling())) {
                DependencyState st = new DependencyState(!a.requiresActivation(), a.isDefaultEnabled());
                boolean resolved = false;
                AgendaNode n = agenda.getNodeBefore((AgendaNode)action, true);
                while (n != null) {
                    if (n instanceof AgendaAction) {
                        boolean oldActivated = st.activated;
                        if (this.resolveActionDependenciesAgainst(agenda, action, a, st, (AgendaExecutable)((AgendaAction)n))) {
                            resolved = true;
                            break;
                        }
                        if (!oldActivated && st.activated && !st.enabled) break;
                    }
                    n = agenda.getNodeBefore(n, true);
                }
                if (!resolved) {
                    AgendaFile f;
                    AgendaFile[] fs = agenda.getFiles();
                    for (int i = 0; !(i >= fs.length || (f = fs[i]).isAutoload() && this.resolveActionDependenciesAgainst(agenda, action, a, st, (AgendaExecutable)f)); ++i) {
                    }
                }
                if (a.requiresEnabling() && !st.enabled || st.reason == 4) {
                    properties.setDependencyProblem((AgendaItem)action, 41, st.culprit);
                    return;
                }
                if (a.requiresActivation() && !st.activated || st.reason == 2) {
                    properties.setDependencyProblem((AgendaItem)action, 42, st.culprit);
                    return;
                }
            }
            properties.setDependencyProblem((AgendaItem)action, -1, null);
        }

        private boolean resolveFileDependenciesAgainst(Agenda agenda, AgendaFile file, AgendaAction action) {
            String fileName;
            if (file.isAutoload()) {
                return true;
            }
            ActionInfo a = null;
            String cmd = action.getCommandName();
            if (cmd != null && cmd.length() != 0) {
                a = Actions.getAction(cmd);
            }
            return a != null && a.isLoadAction() && (fileName = action.getCommandParameter("file")) != null && fileName.equals(file.getName());
        }

        private boolean resolveActionDependenciesAgainst(Agenda agenda, AgendaAction action, ActionInfo actionInfo, DependencyState state, AgendaExecutable executable) {
            ActionDependency dep;
            ActionInfo exeInfo = null;
            String cmd = executable.getCommandName();
            if (cmd != null && cmd.length() != 0) {
                exeInfo = Actions.getAction(cmd);
            }
            if (exeInfo != null && (dep = actionInfo.getDependency(exeInfo.getCommandInterface())) != null) {
                boolean depends = true;
                int rel = dep.getRelationship();
                if (!(rel != 1 && rel != 3 || (depends = this.resolveParameterDependencyAgainst(agenda, action, actionInfo, dep, executable)))) {
                    state.culprit = dep.getParameter();
                }
                if (depends) {
                    switch (rel) {
                        case 1: {
                            if (state.activatedSet) break;
                            state.activated = true;
                            state.activatedSet = true;
                            if (actionInfo.requiresEnabling() && !state.enabled) break;
                            return true;
                        }
                        case 2: {
                            if (state.activatedSet) break;
                            state.activated = false;
                            state.culprit = (AgendaNode)executable;
                            state.reason = 2;
                            state.activatedSet = true;
                            return true;
                        }
                        case 3: {
                            if (state.enabledSet) break;
                            state.enabled = true;
                            state.enabledSet = true;
                            if (actionInfo.requiresActivation() && !state.activated) break;
                            return true;
                        }
                        case 4: {
                            if (state.enabledSet) break;
                            state.enabled = false;
                            state.culprit = (AgendaNode)executable;
                            state.reason = 4;
                            state.enabledSet = true;
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        private boolean resolveParameterDependencyAgainst(Agenda agenda, AgendaAction action, ActionInfo actionInfo, ActionDependency dependency, AgendaExecutable executable) {
            String paramName = dependency.getParameter();
            String otherParamName = dependency.getOtherParameter();
            if (paramName == null || otherParamName == null) {
                return true;
            }
            String paramValue = action.getCommandParameter(paramName);
            String otherParamValue = executable.getCommandParameter(otherParamName);
            if (paramValue == null || paramValue.length() == 0) {
                return true;
            }
            ActionParameter param = actionInfo.getParameter(paramName);
            switch (param.getType()) {
                case 11: {
                    if (executable instanceof AgendaFile) {
                        return paramValue.equals(((AgendaFile)executable).getName());
                    }
                    if (!(executable instanceof AgendaAction)) break;
                    if (otherParamValue != null && otherParamValue.indexOf("://") != -1) {
                        otherParamValue = otherParamValue.substring(otherParamValue.lastIndexOf("/") + 1);
                    }
                    return paramValue.equals(otherParamValue);
                }
                case 12: {
                    if (AgendaValidator.this.contentProvider == null) break;
                    if (executable instanceof AgendaFile) {
                        return AgendaValidator.this.contentProvider.fileContainsQuiz((AgendaFile)executable, paramValue);
                    }
                    if (!(executable instanceof AgendaAction) || otherParamValue == null) break;
                    AgendaFile f = agenda.getFileByName(otherParamValue);
                    if (f != null) {
                        return AgendaValidator.this.contentProvider.fileContainsQuiz(f, paramValue);
                    }
                    if (otherParamValue.indexOf("://") == -1) break;
                    return true;
                }
                case 13: {
                    boolean root = action.getCommandParameter("searchFromScreenGroup").equals("true");
                    boolean iterative = action.getCommandParameter("searchSubTopics").equals("true");
                    if (AgendaValidator.this.contentProvider == null) break;
                    if (executable instanceof AgendaFile) {
                        return AgendaValidator.this.contentProvider.fileContainsScreen((AgendaFile)executable, paramValue);
                    }
                    if (!(executable instanceof AgendaAction) || otherParamValue == null) break;
                    AgendaFile f = agenda.getFileByName(otherParamValue);
                    if (f != null) {
                        return AgendaValidator.this.contentProvider.fileContainsScreen(f, paramValue);
                    }
                    if (otherParamValue.indexOf("://") == -1) break;
                    return true;
                }
            }
            return paramValue.equals(otherParamValue);
        }

        private void validateFileCommand(Agenda agenda, AgendaFile file, AgendaProperties properties) {
            String cmd = file.getCommandName();
            if (cmd != null && cmd.length() != 0) {
                ActionInfo actionInfo = Actions.getAction(cmd);
                if (actionInfo == null) {
                    properties.setCommandProblem((AgendaItem)file, 13, cmd);
                    return;
                }
                if (AgendaValidator.this.commandEngine != null && !AgendaValidator.this.commandEngine.isCommandRegistered(actionInfo.getCommandInterface())) {
                    properties.setCommandProblem((AgendaItem)file, 13, cmd);
                    return;
                }
                ActionParameter[] params = actionInfo.getParameters();
                for (int i = 0; i < params.length; ++i) {
                    ActionParameter param = params[i];
                    String val = file.getCommandParameter(param.getName());
                    if (param.getName().equals("file")) {
                        if (val != null && val.length() != 0) {
                            properties.setCommandProblem((AgendaItem)file, 15, param.getName());
                            return;
                        }
                    } else if (param.isRequired() && (val == null || val.length() == 0)) {
                        properties.setCommandProblem((AgendaItem)file, 14, param.getName());
                        return;
                    }
                    if (val != null && val.length() == 0) continue;
                }
            }
            properties.setCommandProblem((AgendaItem)file, -1, null);
        }

        private void validateActionCommand(Agenda agenda, AgendaAction action, AgendaProperties properties) {
            if (action.isCompoundAction()) {
                return;
            }
            String cmd = action.getCommandName();
            if (cmd == null || cmd.length() == 0) {
                properties.setCommandProblem((AgendaItem)action, 12, null);
                return;
            }
            ActionInfo actionInfo = Actions.getAction(cmd);
            if (actionInfo == null) {
                properties.setCommandProblem((AgendaItem)action, 13, cmd);
                return;
            }
            if (AgendaValidator.this.commandEngine != null && !AgendaValidator.this.commandEngine.isCommandRegistered(actionInfo.getCommandInterface())) {
                properties.setCommandProblem((AgendaItem)action, 13, cmd);
                return;
            }
            ActionParameter[] params = actionInfo.getParameters();
            block12: for (int i = 0; i < params.length; ++i) {
                ActionParameter param = params[i];
                String val = action.getCommandParameter(param.getName());
                if (param.isRequired() && (val == null || val.length() == 0)) {
                    properties.setCommandProblem((AgendaItem)action, 14, param.getName());
                    return;
                }
                if (val == null || val.length() == 0) continue;
                switch (param.getType()) {
                    case 2: {
                        if (this.validateInteger(agenda, (AgendaExecutable)action, param.getName(), val, properties)) continue block12;
                        return;
                    }
                    case 6: {
                        if (this.validateFileReference(agenda, action, param.getName(), val, true, properties)) continue block12;
                        return;
                    }
                    case 11: {
                        if (this.validateFileReference(agenda, action, param.getName(), val, false, properties)) continue block12;
                        return;
                    }
                    case 12: {
                        if (this.validateQuizReference(agenda, action, param.getName(), val, properties)) continue block12;
                        return;
                    }
                    case 13: {
                        if (this.validateScreenReference(agenda, action, param.getName(), val, properties)) continue block12;
                        return;
                    }
                    case 15: {
                        if (this.validateURL(agenda, action, param.getName(), val, false, new String[]{"http", "https"}, properties)) continue block12;
                        return;
                    }
                    case 16: {
                        if (this.validatePhoneReference(agenda, action, param.getName(), val, false, properties)) continue block12;
                        return;
                    }
                    case 17: {
                        if (this.validatePhoneReference(agenda, action, param.getName(), val, true, properties)) continue block12;
                        return;
                    }
                    case 18: {
                        if (this.validatePhonePIN(agenda, action, param.getName(), val, properties)) continue block12;
                        return;
                    }
                    case 8: {
                        if (this.validateListValue(agenda, action, param.getName(), val, properties)) continue block12;
                        return;
                    }
                }
            }
            properties.setCommandProblem((AgendaItem)action, -1, null);
        }

        private boolean validateInteger(Agenda agenda, AgendaExecutable executable, String parameter, String integer, AgendaProperties properties) {
            int val;
            try {
                val = Integer.parseInt(integer);
            }
            catch (NumberFormatException ex) {
                properties.setCommandProblem((AgendaItem)executable, 23, parameter);
                return false;
            }
            ActionInfo a = Actions.getAction(executable.getCommandName());
            ActionParameter param = a.getParameter(parameter);
            int min = param.getMinimumValue();
            if (min != -1 && val < min) {
                properties.setCommandProblem((AgendaItem)executable, 24, parameter);
                return false;
            }
            int max = param.getMaximumValue();
            if (max != -1 && val > max) {
                properties.setCommandProblem((AgendaItem)executable, 25, parameter);
                return false;
            }
            properties.setCommandProblem((AgendaItem)executable, -1, null);
            return true;
        }

        private boolean validateFileReference(Agenda agenda, AgendaAction action, String parameter, String fileReference, boolean allowURL, AgendaProperties properties) {
            ActionInfo a = Actions.getAction(action.getCommandName());
            if (a.isLoadAction()) {
                AgendaFile f = agenda.getFileByName(fileReference);
                if (f != null) {
                    String ext = AgendaUtils.parseFileName((String)f.getPath())[1];
                    if (!a.containsExtension(ext) && !a.containsExtension("*")) {
                        properties.setCommandProblem((AgendaItem)action, 18, parameter);
                        return false;
                    }
                } else {
                    boolean isURL;
                    boolean bl = isURL = fileReference.indexOf("://") != -1;
                    if (!allowURL || !isURL) {
                        properties.setCommandProblem((AgendaItem)action, 16, parameter);
                        return false;
                    }
                    if (!this.validateURL(agenda, action, parameter, fileReference, true, new String[]{"http", "ftp", "https"}, properties)) {
                        return false;
                    }
                }
            }
            properties.setCommandProblem((AgendaItem)action, -1, null);
            return true;
        }

        private boolean validateQuizReference(Agenda agenda, AgendaAction action, String parameter, String quizReference, AgendaProperties properties) {
            properties.setCommandProblem((AgendaItem)action, -1, null);
            return true;
        }

        private boolean validateScreenReference(Agenda agenda, AgendaAction action, String parameter, String screenReference, AgendaProperties properties) {
            properties.setCommandProblem((AgendaItem)action, -1, null);
            return true;
        }

        private boolean validateURL(Agenda agenda, AgendaAction action, String parameter, String url, boolean requireProtocol, String[] validProtocols, AgendaProperties properties) {
            String ext;
            URL u = null;
            try {
                u = new URL(url);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (u == null && !requireProtocol && validProtocols.length != 0) {
                try {
                    int pos = url.indexOf("://");
                    if (pos == -1) {
                        u = new URL(validProtocols[0] + "://" + url);
                    }
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (u == null) {
                properties.setCommandProblem((AgendaItem)action, 17, parameter);
                return false;
            }
            boolean validProto = false;
            String proto = u.getProtocol();
            for (int i = 0; i < validProtocols.length; ++i) {
                if (!proto.equalsIgnoreCase(validProtocols[i])) continue;
                validProto = true;
                break;
            }
            if (!validProto) {
                properties.setCommandProblem((AgendaItem)action, 17, parameter);
                return false;
            }
            ActionInfo a = Actions.getAction(action.getCommandName());
            if (a.isLoadAction() && !a.containsExtension(ext = AgendaUtils.parseFileName((String)url)[1]) && !a.containsExtension("*")) {
                properties.setCommandProblem((AgendaItem)action, 18, parameter);
                return false;
            }
            properties.setCommandProblem((AgendaItem)action, -1, null);
            return true;
        }

        private boolean validatePhoneReference(Agenda agenda, AgendaAction action, String parameter, String phoneReference, boolean allowSIP, AgendaProperties properties) {
            if (!TelephonyUtils.checkTelephonyNumberIsATelephoneNumber((String)phoneReference)) {
                boolean isURL = phoneReference.startsWith("sip:");
                if (!allowSIP || !isURL) {
                    properties.setCommandProblem((AgendaItem)action, 19, parameter);
                    return false;
                }
                if (!TelephonyUtils.isStringAValidSipURI((String)phoneReference)) {
                    properties.setCommandProblem((AgendaItem)action, 20, parameter);
                    return false;
                }
            }
            properties.setCommandProblem((AgendaItem)action, -1, null);
            return true;
        }

        private boolean validatePhonePIN(Agenda agenda, AgendaAction action, String parameter, String phonePIN, AgendaProperties properties) {
            if (!TelephonyUtils.isStringAPin((String)phonePIN)) {
                properties.setCommandProblem((AgendaItem)action, 21, parameter);
                return false;
            }
            properties.setCommandProblem((AgendaItem)action, -1, null);
            return true;
        }

        private boolean validateListValue(Agenda agenda, AgendaAction action, String parameter, String listValue, AgendaProperties properties) {
            boolean valid = false;
            ActionInfo a = Actions.getAction(action.getCommandName());
            ActionParameter param = a.getParameter(parameter);
            for (ActionParameterValue v : param.getPossibleValues()) {
                if (!listValue.equals(v.getName())) continue;
                valid = true;
                break;
            }
            if (!valid) {
                properties.setCommandProblem((AgendaItem)action, 22, parameter);
                return false;
            }
            properties.setCommandProblem((AgendaItem)action, -1, null);
            return true;
        }
    }
}

