/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.LoadFeature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.imps.DisconnectQueryAPI;
import com.elluminate.groupware.imps.FileTransferClientAPI;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.module.PermissionFeatureFactory;
import com.elluminate.groupware.transfer.TransferProtocol;
import com.elluminate.groupware.transfer.module.ClientAPIImpl;
import com.elluminate.groupware.transfer.module.LoadFileCmd;
import com.elluminate.groupware.transfer.module.PromptToSaveFileCmd;
import com.elluminate.groupware.transfer.module.StringsProperties;
import com.elluminate.groupware.transfer.module.TransferBean;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.ConnectionEvent;
import com.elluminate.jinx.ConnectionListener;
import com.elluminate.jinx.JinxConnectionException;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;

@Singleton
public class TransferModule
extends AbstractClientModule
implements ConnectionListener,
ModulePublisherInfo,
PropertyChangeListener {
    public static final I18n i18n = I18n.create(TransferModule.class);
    public static final String MODULE_NAME = "Transfer";
    private ImageIcon accessIcon = i18n.getIcon("TransferModule.accessIcon");
    private FileTransferClientAPI impl = null;
    private TransferBean bean = null;
    private DisconnectQueryAPI discQuery = new DisconnectQueryAPI(){

        public String getProvider() {
            return TransferModule.MODULE_NAME;
        }

        public byte getTier() {
            return 32;
        }

        public byte mayDisconnect() {
            if (TransferModule.this.bean == null) {
                return 0;
            }
            return TransferModule.this.bean.disconnectQuery();
        }
    };
    private Provider<TransferBean> beanProvider;
    private ClientProvider clientProvider;
    private Imps imps;
    private FeatureBroker broker;
    private ComponentFeature transferPanelFeature;
    private BooleanFeature showMenuFeature;
    private ActionFeature loadFileFeature;
    private ActionFeature loadUrlFeature;
    private PermissionFeatureFactory permissionFeatureFactory;
    private Provider<LoadFileCmd> loadFileCmd;
    private ConferencingEngine confEngine;
    private Provider<PromptToSaveFileCmd> promptToSaveFileCmd;
    private LoadFeature loadFiles;
    private ChairProtocol chairProtocol;
    private Client client;
    private ClientList clients;
    private TransferProtocol transferProtocol;

    @Inject
    protected void initVersionManager(ComponentRegistrar cr) {
        cr.registerComponent((Object)this);
    }

    @Inject
    public void initTransferBeanProvider(Provider<TransferBean> bp) {
        this.beanProvider = bp;
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    protected void initPermissionFeatureFactory(PermissionFeatureFactory permissionFeatureFactory) {
        this.permissionFeatureFactory = permissionFeatureFactory;
    }

    @Inject
    public void initConferencingEngine(ConferencingEngine ce) {
        this.confEngine = ce;
    }

    @Inject
    public void initLoadFileCmd(Provider<LoadFileCmd> cp) {
        this.loadFileCmd = cp;
    }

    @Inject
    public void initPromptToSaveFileCmd(Provider<PromptToSaveFileCmd> cp) {
        this.promptToSaveFileCmd = cp;
    }

    @Inject
    public void initChairProtocol(ChairProtocol chairProtocol) {
        this.chairProtocol = chairProtocol;
    }

    @Inject
    public void initTransferProtocol(TransferProtocol transferProtocol) {
        this.transferProtocol = transferProtocol;
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getDisplayNameOfModule() {
        return i18n.getString((PropertiesEnum)StringsProperties.TRANSFERMODULE_TITLE);
    }

    public Icon getModuleIcon() {
        return this.accessIcon;
    }

    public void connectionStatusChanged(ConnectionEvent event) throws JinxConnectionException {
        this.updateFileMenu();
    }

    private void updateFileMenu() {
        boolean playback = false;
        boolean connected = false;
        Client client = this.clientProvider.get();
        if (client != null) {
            playback = client.isPlayback();
            connected = client.isConnected();
        }
        if (this.bean == null) {
            return;
        }
        if (!playback && connected) {
            this.broker.addFeature((Feature)this.loadFileFeature);
            this.broker.addFeature((Feature)this.loadUrlFeature);
        } else {
            this.broker.removeFeature((Feature)this.loadFileFeature);
            this.broker.removeFeature((Feature)this.loadUrlFeature);
        }
    }

    public boolean requestClose() {
        return false;
    }

    private void changeState(boolean state) {
        if (((Boolean)this.showMenuFeature.getValue()).booleanValue()) {
            this.broker.addFeature((Feature)this.transferPanelFeature);
        } else {
            this.broker.removeFeature((Feature)this.transferPanelFeature);
        }
        if (state) {
            String tip = i18n.getString((PropertiesEnum)StringsProperties.TRANSFERMODULE_HIDETIP);
        } else {
            String tip = i18n.getString((PropertiesEnum)StringsProperties.TRANSFERMODULE_SHOWTIP);
        }
        this.bean.setShowing(state);
    }

    public Class[] getCommandClasses() {
        return new Class[]{LoadFileCmd.class, PromptToSaveFileCmd.class};
    }

    private void createFeatures() {
        this.showMenuFeature = this.broker.createBooleanFeature((Object)this, "/transfer/showMenu", true, false, i18n.getString((PropertiesEnum)StringsProperties.TRANSFERMODULE_SHOWMENU), i18n.getString((PropertiesEnum)StringsProperties.TRANSFERMODULE_SHOWTIP));
        this.showMenuFeature.setTrueText(i18n.getString((PropertiesEnum)StringsProperties.TRANSFERMODULE_SHOWMENU));
        this.showMenuFeature.setFalseText(i18n.getString((PropertiesEnum)StringsProperties.TRANSFERMODULE_SHOWMENU));
        this.showMenuFeature.setTrueIcon(i18n.getImage("TransferModule.showIcon"));
        this.showMenuFeature.setFalseIcon(i18n.getImage("TransferModule.showIcon"));
        this.showMenuFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                TransferModule.this.changeState(true);
            }
        });
        this.broker.addFeature((Feature)this.showMenuFeature);
        this.loadFileFeature = this.broker.createActionFeature((Object)this, "/transfer/loadFileMenu", i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_LOADFILEMENU), null);
        this.loadFileFeature.setInteractive(true);
        this.loadFileFeature.setEnabled(false);
        this.loadFileFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                TransferModule.this.bean.doLoadFile();
                TransferModule.this.showMenuFeature.setValue((Object)true);
            }
        });
        this.loadUrlFeature = this.broker.createActionFeature((Object)this, "/transfer/loadURLMenu", i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_LOADURLMENU), null);
        this.loadUrlFeature.setInteractive(true);
        this.loadUrlFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                TransferModule.this.bean.doLoadURL();
            }
        });
        this.transferPanelFeature = this.broker.createComponentFeature((Object)this, "/transfer/transferPanel", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return TransferModule.this.bean;
            }
        }, i18n.getString((PropertiesEnum)StringsProperties.TRANSFERMODULE_TITLE), i18n.getString((PropertiesEnum)StringsProperties.TRANSFERMODULE_TITLE));
        this.loadFiles = this.broker.createLoadFeature((Object)this, "/transfer/loadFiles", "Transfer File", null);
        this.loadFiles.setDefaultIcon(i18n.getImage((PropertiesEnum)StringsProperties.TRANSFERMODULE_LOADFEATUREICON));
        this.loadFiles.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ArrayList files = (ArrayList)event.getParameter("files");
                if (files != null) {
                    TransferModule.this.showMenuFeature.setValue((Object)true);
                    for (File file : files) {
                        TransferModule.this.bean.doLoadFile(file);
                    }
                }
            }
        });
    }

    public void start() {
        this.confEngine.registerCommand(this.loadFileCmd);
        this.confEngine.registerCommand(this.promptToSaveFileCmd);
    }

    public void attach() {
        this.impl = new ClientAPIImpl(this.clientProvider.get(), this.transferProtocol);
        this.imps.provideAPI(FileTransferClientAPI.class, (ImpsAPI)this.impl);
        this.imps.provideAPI(DisconnectQueryAPI.class, (ImpsAPI)this.discQuery);
        this.client = this.clientProvider.get();
        this.clients = this.client.getClientList();
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.bean = (TransferBean)this.beanProvider.get();
        this.bean.setClient(this.client);
        if (this.client != null) {
            this.client.addConnectionListener((ConnectionListener)this);
        }
    }

    public void setupUI() {
        this.createFeatures();
        this.updateFileMenu();
    }

    public void cleanupUI() {
    }

    public void detach() {
        this.bean.shutdown();
        this.bean = null;
        this.imps.revokeAPI(FileTransferClientAPI.class, (ImpsAPI)this.impl);
        this.impl = null;
        this.imps.revokeAPI(DisconnectQueryAPI.class, (ImpsAPI)this.discQuery);
        this.discQuery = null;
    }

    public void stop() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String nm = propertyChangeEvent.getPropertyName();
        if (nm.equals("chair")) {
            Chair now = new Chair((Connection)this.client, propertyChangeEvent.getNewValue());
            this.broker.setFeaturePublished((Feature)this.loadFiles, now.isMe());
            this.loadFileFeature.setEnabled(now.isMe());
        }
    }
}

